/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.io.util.AbstractDataInput;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ByteBufferDataInput
extends AbstractDataInput
implements FileDataInput,
DataInput {
    private final ByteBuffer buffer;
    private final String filename;
    private final long segmentOffset;
    private int position;

    public ByteBufferDataInput(ByteBuffer buffer, String filename, long segmentOffset, int position) {
        assert (buffer != null);
        this.buffer = buffer;
        this.filename = filename;
        this.segmentOffset = segmentOffset;
        this.position = position;
    }

    @Override
    public void seek(long pos) throws IOException {
        long inSegmentPos = pos - this.segmentOffset;
        if (inSegmentPos < 0L || inSegmentPos > (long)this.buffer.capacity()) {
            throw new IOException(String.format("Seek position %d is not within mmap segment (seg offs: %d, length: %d)", pos, this.segmentOffset, this.buffer.capacity()));
        }
        this.position = (int)inSegmentPos;
    }

    @Override
    public long getFilePointer() {
        return this.segmentOffset + (long)this.position;
    }

    @Override
    public long getPosition() {
        return this.segmentOffset + (long)this.position;
    }

    @Override
    public long getPositionLimit() {
        return this.segmentOffset + (long)this.buffer.capacity();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void reset(FileMark mark) throws IOException {
        assert (mark instanceof MappedFileDataInputMark);
        this.position = ((MappedFileDataInputMark)mark).position;
    }

    @Override
    public FileMark mark() {
        return new MappedFileDataInputMark(this.position);
    }

    @Override
    public long bytesPastMark(FileMark mark) {
        assert (mark instanceof MappedFileDataInputMark);
        assert (this.position >= ((MappedFileDataInputMark)mark).position);
        return this.position - ((MappedFileDataInputMark)mark).position;
    }

    @Override
    public boolean isEOF() throws IOException {
        return this.position == this.buffer.capacity();
    }

    @Override
    public long bytesRemaining() throws IOException {
        return this.buffer.capacity() - this.position;
    }

    @Override
    public String getPath() {
        return this.filename;
    }

    @Override
    public int read() throws IOException {
        if (this.isEOF()) {
            return -1;
        }
        return this.buffer.get(this.position++) & 0xFF;
    }

    @Override
    public ByteBuffer readBytes(int length) throws IOException {
        int remaining = this.buffer.remaining() - this.position;
        if (length > remaining) {
            throw new IOException(String.format("mmap segment underflow; remaining is %d but %d requested", remaining, length));
        }
        if (length == 0) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        ByteBuffer bytes = this.buffer.duplicate();
        bytes.position(this.buffer.position() + this.position).limit(this.buffer.position() + this.position + length);
        this.position += length;
        ByteBuffer clone = ByteBuffer.allocate(bytes.remaining());
        clone.put(bytes);
        clone.flip();
        return clone;
    }

    @Override
    public final void readFully(byte[] bytes) throws IOException {
        ByteBufferUtil.arrayCopy(this.buffer, this.buffer.position() + this.position, bytes, 0, bytes.length);
        this.position += bytes.length;
    }

    @Override
    public final void readFully(byte[] bytes, int offset, int count) throws IOException {
        ByteBufferUtil.arrayCopy(this.buffer, this.buffer.position() + this.position, bytes, offset, count);
        this.position += count;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + "filename='" + this.filename + "'" + ", position=" + this.position + ")";
    }

    private static class MappedFileDataInputMark
    implements FileMark {
        int position;

        MappedFileDataInputMark(int position) {
            this.position = position;
        }
    }
}

