/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.hsqldb.DatabaseURL;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.Util;
import org.hsqldb.persist.HsqlProperties;

public class JDBCDriver
implements Driver {
    public static JDBCDriver driverInstance;
    public final ThreadLocal threadConnection = new ThreadLocal();

    public Connection connect(String url, Properties info) throws SQLException {
        if (url.regionMatches(true, 0, "jdbc:default:connection", 0, "jdbc:default:connection".length())) {
            JDBCConnection conn = (JDBCConnection)this.threadConnection.get();
            if (conn == null) {
                return null;
            }
            return conn;
        }
        return JDBCDriver.getConnection(url, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Connection getConnection(String url, Properties info) throws SQLException {
        SQLException[] ex;
        JDBCConnection[] conn;
        block20: {
            String loginTimeoutProperty;
            final HsqlProperties props = DatabaseURL.parseURL(url, true, false);
            if (props == null) {
                throw Util.invalidArgument();
            }
            if (props.isEmpty()) {
                return null;
            }
            long timeout = 0L;
            if (info != null && info.containsKey("loginTimeout") && (loginTimeoutProperty = info.getProperty("loginTimeout")) != null && (loginTimeoutProperty = loginTimeoutProperty.trim()).length() > 0) {
                try {
                    timeout = Integer.parseInt(loginTimeoutProperty);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            props.addProperties(info);
            if (timeout == 0L) {
                timeout = DriverManager.getLoginTimeout();
            }
            if (timeout == 0L) {
                return new JDBCConnection(props);
            }
            String connType = props.getProperty("connection_type");
            if (DatabaseURL.isInProcessDatabaseType(connType)) {
                return new JDBCConnection(props);
            }
            conn = new JDBCConnection[1];
            ex = new SQLException[1];
            Thread t = new Thread(){

                public void run() {
                    try {
                        conn[0] = new JDBCConnection(props);
                    }
                    catch (SQLException se) {
                        ex[0] = se;
                    }
                }
            };
            t.start();
            long start = System.currentTimeMillis();
            try {
                t.join(1000L * timeout);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            t.stop();
            Object var13_12 = null;
            try {
                t.setContextClassLoader(null);
            }
            catch (Throwable th) {}
            break block20;
            {
                catch (Exception e) {
                    Object var13_13 = null;
                    try {
                        t.setContextClassLoader(null);
                    }
                    catch (Throwable th) {}
                }
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                try {
                    t.setContextClassLoader(null);
                }
                catch (Throwable th) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (ex[0] != null) {
            throw ex[0];
        }
        if (conn[0] != null) {
            return conn[0];
        }
        throw Util.sqlException(1351);
    }

    public boolean acceptsURL(String url) {
        if (url == null) {
            return false;
        }
        if (url.regionMatches(true, 0, "jdbc:hsqldb:", 0, "jdbc:hsqldb:".length())) {
            return true;
        }
        return url.regionMatches(true, 0, "jdbc:default:connection", 0, "jdbc:default:connection".length());
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        if (!this.acceptsURL(url)) {
            return new DriverPropertyInfo[0];
        }
        String[] choices = new String[]{"true", "false"};
        DriverPropertyInfo[] pinfo = new DriverPropertyInfo[6];
        if (info == null) {
            info = new Properties();
        }
        DriverPropertyInfo p = new DriverPropertyInfo("user", null);
        p.value = info.getProperty("user");
        p.required = true;
        pinfo[0] = p;
        p = new DriverPropertyInfo("password", null);
        p.value = info.getProperty("password");
        p.required = true;
        pinfo[1] = p;
        p = new DriverPropertyInfo("get_column_name", null);
        p.value = info.getProperty("get_column_name", "true");
        p.required = false;
        p.choices = choices;
        pinfo[2] = p;
        p = new DriverPropertyInfo("ifexists", null);
        p.value = info.getProperty("ifexists", "false");
        p.required = false;
        p.choices = choices;
        pinfo[3] = p;
        p = new DriverPropertyInfo("default_schema", null);
        p.value = info.getProperty("default_schema", "false");
        p.required = false;
        p.choices = choices;
        pinfo[4] = p;
        p = new DriverPropertyInfo("shutdown", null);
        p.value = info.getProperty("shutdown", "false");
        p.required = false;
        p.choices = choices;
        pinfo[5] = p;
        return pinfo;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 1;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    static {
        try {
            driverInstance = new JDBCDriver();
            DriverManager.registerDriver(driverInstance);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

