/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import org.jruby.compiler.ir.Interp;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.CopyInstr;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.NoOperandInstr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ReceiveArgumentInstruction
extends NoOperandInstr {
    int argIndex;
    boolean restOfArgArray;

    public ReceiveArgumentInstruction(Variable destination, int argIndex, boolean restOfArgArray) {
        super(Operation.RECV_ARG, destination);
        this.argIndex = argIndex;
        this.restOfArgArray = restOfArgArray;
    }

    public ReceiveArgumentInstruction(Variable destination, int index2) {
        this(destination, index2, false);
    }

    public Instr cloneForInlining(InlinerInfo ii) {
        return new CopyInstr(ii.getRenamedVariable(this.result), ii.getCallArg(this.argIndex, this.restOfArgArray));
    }

    public String toString() {
        return super.toString() + "(" + this.argIndex + (this.restOfArgArray ? ", ALL" : "") + ")";
    }

    public Label interpret(InterpreterContext interp, IRubyObject self) {
        Variable destination = this.getResult();
        if (this.restOfArgArray) {
            this.interpretAsRestArg(destination, interp);
        } else {
            destination.store(interp, interp.getParameter(this.argIndex));
        }
        return null;
    }

    @Interp
    private void interpretAsRestArg(Operand destination, InterpreterContext interp) {
        destination.store(interp, interp.getRuntime().newArray(interp.getParametersFrom(this.argIndex)));
    }
}

