/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.facets.FacetCountCollectorSource;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.filter.EmptyFilter;
import com.browseengine.bobo.facets.filter.RandomAccessAndFilter;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.facets.filter.RandomAccessOrFilter;
import com.browseengine.bobo.sort.DocComparatorSource;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class ComboFacetHandler
extends FacetHandler<FacetHandler.FacetDataNone> {
    private static final String DFEAULT_SEPARATOR = ":";
    private final String _separator;

    public ComboFacetHandler(String name, Set<String> dependsOn) {
        this(name, DFEAULT_SEPARATOR, dependsOn);
    }

    public ComboFacetHandler(String name, String seperator, Set<String> dependsOn) {
        super(name, dependsOn);
        this._separator = seperator;
    }

    public String getSeparator() {
        return this._separator;
    }

    @Override
    public RandomAccessFilter buildRandomAccessFilter(String value, Properties selectionProperty) throws IOException {
        FacetHandler<?> handler;
        RandomAccessFilter retFilter = EmptyFilter.getInstance();
        ComboSelection comboSel = ComboSelection.parse(value, this._separator);
        if (comboSel != null && (handler = this.getDependedFacetHandler(comboSel.name)) != null) {
            retFilter = handler.buildRandomAccessFilter(comboSel.val, selectionProperty);
        }
        return retFilter;
    }

    private static Map<String, List<String>> convertMap(String[] vals, String sep) {
        HashMap<String, List<String>> retmap = new HashMap<String, List<String>>();
        for (String val : vals) {
            ComboSelection sel = ComboSelection.parse(val, sep);
            if (sel == null) continue;
            LinkedList<String> valList = (LinkedList<String>)retmap.get(sel.name);
            if (valList == null) {
                valList = new LinkedList<String>();
                retmap.put(sel.name, valList);
            }
            valList.add(sel.val);
        }
        return retmap;
    }

    @Override
    public RandomAccessFilter buildRandomAccessAndFilter(String[] vals, Properties prop) throws IOException {
        Map<String, List<String>> valMap = ComboFacetHandler.convertMap(vals, this._separator);
        Set<Map.Entry<String, List<String>>> entries = valMap.entrySet();
        LinkedList<RandomAccessFilter> filterList = new LinkedList<RandomAccessFilter>();
        for (Map.Entry<String, List<String>> entry : entries) {
            String name = entry.getKey();
            FacetHandler<?> facetHandler = this.getDependedFacetHandler(name);
            if (facetHandler == null) {
                return EmptyFilter.getInstance();
            }
            List<String> selVals = entry.getValue();
            if (selVals == null || selVals.size() == 0) {
                return EmptyFilter.getInstance();
            }
            RandomAccessFilter f = facetHandler.buildRandomAccessAndFilter(selVals.toArray(new String[0]), prop);
            if (f == EmptyFilter.getInstance()) {
                return f;
            }
            filterList.add(f);
        }
        if (filterList.size() == 0) {
            return EmptyFilter.getInstance();
        }
        if (filterList.size() == 1) {
            return (RandomAccessFilter)((Object)filterList.get(0));
        }
        return new RandomAccessAndFilter(filterList);
    }

    @Override
    public RandomAccessFilter buildRandomAccessOrFilter(String[] vals, Properties prop, boolean isNot) throws IOException {
        Map<String, List<String>> valMap = ComboFacetHandler.convertMap(vals, this._separator);
        Set<Map.Entry<String, List<String>>> entries = valMap.entrySet();
        LinkedList<RandomAccessFilter> filterList = new LinkedList<RandomAccessFilter>();
        for (Map.Entry<String, List<String>> entry : entries) {
            RandomAccessFilter f;
            List<String> selVals;
            String name = entry.getKey();
            FacetHandler<?> facetHandler = this.getDependedFacetHandler(name);
            if (facetHandler == null || (selVals = entry.getValue()) == null || selVals.size() == 0 || (f = facetHandler.buildRandomAccessOrFilter(selVals.toArray(new String[0]), prop, isNot)) == EmptyFilter.getInstance()) continue;
            filterList.add(f);
        }
        if (filterList.size() == 0) {
            return EmptyFilter.getInstance();
        }
        if (filterList.size() == 1) {
            return (RandomAccessFilter)((Object)filterList.get(0));
        }
        if (isNot) {
            return new RandomAccessAndFilter(filterList);
        }
        return new RandomAccessOrFilter(filterList);
    }

    @Override
    public DocComparatorSource getDocComparatorSource() {
        throw new UnsupportedOperationException("sorting not supported for " + ComboFacetHandler.class);
    }

    @Override
    public FacetCountCollectorSource getFacetCountCollectorSource(BrowseSelection sel, FacetSpec fspec) {
        throw new UnsupportedOperationException("facet counting not supported for " + ComboFacetHandler.class);
    }

    @Override
    public String[] getFieldValues(BoboIndexReader reader, int id) {
        Set<String> dependsOn = this.getDependsOn();
        LinkedList<String> valueList = new LinkedList<String>();
        for (String depends : dependsOn) {
            String[] fieldValues;
            FacetHandler<?> facetHandler = this.getDependedFacetHandler(depends);
            for (String fieldVal : fieldValues = facetHandler.getFieldValues(reader, id)) {
                StringBuilder buf = new StringBuilder();
                buf.append(depends).append(this._separator).append(fieldVal);
                valueList.add(buf.toString());
            }
        }
        return valueList.toArray(new String[0]);
    }

    @Override
    public int getNumItems(BoboIndexReader reader, int id) {
        Set<String> dependsOn = this.getDependsOn();
        LinkedList valueList = new LinkedList();
        int count = 0;
        for (String depends : dependsOn) {
            FacetHandler<?> facetHandler = this.getDependedFacetHandler(depends);
            String[] fieldValues = facetHandler.getFieldValues(reader, id);
            if (fieldValues == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public FacetHandler.FacetDataNone load(BoboIndexReader reader) throws IOException {
        return FacetHandler.FacetDataNone.instance;
    }

    private static class ComboSelection {
        final String name;
        final String val;

        private ComboSelection(String name, String val) {
            this.name = name;
            this.val = val;
        }

        static ComboSelection parse(String value, String sep) {
            StringTokenizer strtok = new StringTokenizer(value, sep);
            if (strtok.hasMoreTokens()) {
                String name = strtok.nextToken();
                if (strtok.hasMoreTokens()) {
                    String val = strtok.nextToken();
                    return new ComboSelection(name, val);
                }
            }
            return null;
        }
    }
}

