/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence;

import com.liferay.portal.NoSuchVirtualHostException;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.model.VirtualHost;
import com.liferay.portal.model.impl.VirtualHostImpl;
import com.liferay.portal.model.impl.VirtualHostModelImpl;
import com.liferay.portal.service.persistence.VirtualHostPersistence;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VirtualHostPersistenceImpl
extends BasePersistenceImpl<VirtualHost>
implements VirtualHostPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = VirtualHostImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = String.valueOf(FINDER_CLASS_NAME_ENTITY) + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = String.valueOf(FINDER_CLASS_NAME_ENTITY) + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostModelImpl.FINDER_CACHE_ENABLED, VirtualHostImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostModelImpl.FINDER_CACHE_ENABLED, VirtualHostImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_FETCH_BY_HOSTNAME = new FinderPath(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostModelImpl.FINDER_CACHE_ENABLED, VirtualHostImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByHostname", new String[]{String.class.getName()}, VirtualHostModelImpl.HOSTNAME_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_HOSTNAME = new FinderPath(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByHostname", new String[]{String.class.getName()});
    private static final String _FINDER_COLUMN_HOSTNAME_HOSTNAME_1 = "virtualHost.hostname IS NULL";
    private static final String _FINDER_COLUMN_HOSTNAME_HOSTNAME_2 = "virtualHost.hostname = ?";
    private static final String _FINDER_COLUMN_HOSTNAME_HOSTNAME_3 = "(virtualHost.hostname IS NULL OR virtualHost.hostname = '')";
    public static final FinderPath FINDER_PATH_FETCH_BY_C_L = new FinderPath(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostModelImpl.FINDER_CACHE_ENABLED, VirtualHostImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByC_L", new String[]{Long.class.getName(), Long.class.getName()}, VirtualHostModelImpl.COMPANYID_COLUMN_BITMASK | VirtualHostModelImpl.LAYOUTSETID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_C_L = new FinderPath(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_L", new String[]{Long.class.getName(), Long.class.getName()});
    private static final String _FINDER_COLUMN_C_L_COMPANYID_2 = "virtualHost.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_L_LAYOUTSETID_2 = "virtualHost.layoutSetId = ?";
    private static final String _SQL_SELECT_VIRTUALHOST = "SELECT virtualHost FROM VirtualHost virtualHost";
    private static final String _SQL_SELECT_VIRTUALHOST_WHERE = "SELECT virtualHost FROM VirtualHost virtualHost WHERE ";
    private static final String _SQL_COUNT_VIRTUALHOST = "SELECT COUNT(virtualHost) FROM VirtualHost virtualHost";
    private static final String _SQL_COUNT_VIRTUALHOST_WHERE = "SELECT COUNT(virtualHost) FROM VirtualHost virtualHost WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "virtualHost.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No VirtualHost exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No VirtualHost exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = PropsValues.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE;
    private static Log _log = LogFactoryUtil.getLog(VirtualHostPersistenceImpl.class);
    private static VirtualHost _nullVirtualHost = new VirtualHostImpl(){

        @Override
        public Object clone() {
            return this;
        }

        @Override
        public CacheModel<VirtualHost> toCacheModel() {
            return _nullVirtualHostCacheModel;
        }
    };
    private static CacheModel<VirtualHost> _nullVirtualHostCacheModel = new CacheModel<VirtualHost>(){

        public VirtualHost toEntityModel() {
            return _nullVirtualHost;
        }
    };

    public VirtualHost findByHostname(String hostname) throws NoSuchVirtualHostException, SystemException {
        VirtualHost virtualHost = this.fetchByHostname(hostname);
        if (virtualHost == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("hostname=");
            msg.append(hostname);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchVirtualHostException(msg.toString());
        }
        return virtualHost;
    }

    public VirtualHost fetchByHostname(String hostname) throws SystemException {
        return this.fetchByHostname(hostname, true);
    }

    public VirtualHost fetchByHostname(String hostname, boolean retrieveFromCache) throws SystemException {
        VirtualHost virtualHost;
        Object[] finderArgs = new Object[]{hostname};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_HOSTNAME, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result instanceof VirtualHost && !Validator.equals((Object)hostname, (Object)(virtualHost = (VirtualHost)result).getHostname())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_VIRTUALHOST_WHERE);
            boolean bindHostname = false;
            if (hostname == null) {
                query.append(_FINDER_COLUMN_HOSTNAME_HOSTNAME_1);
            } else if (hostname.equals("")) {
                query.append(_FINDER_COLUMN_HOSTNAME_HOSTNAME_3);
            } else {
                bindHostname = true;
                query.append(_FINDER_COLUMN_HOSTNAME_HOSTNAME_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    List list;
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    if (bindHostname) {
                        qPos.add(hostname);
                    }
                    if ((list = q.list()).isEmpty()) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_HOSTNAME, (Object[])finderArgs, (Object)list);
                    } else {
                        VirtualHost virtualHost2 = (VirtualHost)list.get(0);
                        result = virtualHost2;
                        this.cacheResult(virtualHost2);
                        if (virtualHost2.getHostname() == null || !virtualHost2.getHostname().equals(hostname)) {
                            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_HOSTNAME, (Object[])finderArgs, (Object)virtualHost2);
                        }
                    }
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_HOSTNAME, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (VirtualHost)result;
    }

    public VirtualHost removeByHostname(String hostname) throws NoSuchVirtualHostException, SystemException {
        VirtualHost virtualHost = this.findByHostname(hostname);
        return (VirtualHost)this.remove((BaseModel)virtualHost);
    }

    public int countByHostname(String hostname) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_HOSTNAME;
        Object[] finderArgs = new Object[]{hostname};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_VIRTUALHOST_WHERE);
            boolean bindHostname = false;
            if (hostname == null) {
                query.append(_FINDER_COLUMN_HOSTNAME_HOSTNAME_1);
            } else if (hostname.equals("")) {
                query.append(_FINDER_COLUMN_HOSTNAME_HOSTNAME_3);
            } else {
                bindHostname = true;
                query.append(_FINDER_COLUMN_HOSTNAME_HOSTNAME_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    if (bindHostname) {
                        qPos.add(hostname);
                    }
                    count = (Long)q.uniqueResult();
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public VirtualHost findByC_L(long companyId, long layoutSetId) throws NoSuchVirtualHostException, SystemException {
        VirtualHost virtualHost = this.fetchByC_L(companyId, layoutSetId);
        if (virtualHost == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("companyId=");
            msg.append(companyId);
            msg.append(", layoutSetId=");
            msg.append(layoutSetId);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchVirtualHostException(msg.toString());
        }
        return virtualHost;
    }

    public VirtualHost fetchByC_L(long companyId, long layoutSetId) throws SystemException {
        return this.fetchByC_L(companyId, layoutSetId, true);
    }

    public VirtualHost fetchByC_L(long companyId, long layoutSetId, boolean retrieveFromCache) throws SystemException {
        VirtualHost virtualHost;
        Object[] finderArgs = new Object[]{companyId, layoutSetId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_C_L, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result instanceof VirtualHost && (companyId != (virtualHost = (VirtualHost)result).getCompanyId() || layoutSetId != virtualHost.getLayoutSetId())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_VIRTUALHOST_WHERE);
            query.append(_FINDER_COLUMN_C_L_COMPANYID_2);
            query.append(_FINDER_COLUMN_C_L_LAYOUTSETID_2);
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(companyId);
                    qPos.add(layoutSetId);
                    List list = q.list();
                    if (list.isEmpty()) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_C_L, (Object[])finderArgs, (Object)list);
                    } else {
                        VirtualHost virtualHost2 = (VirtualHost)list.get(0);
                        result = virtualHost2;
                        this.cacheResult(virtualHost2);
                        if (virtualHost2.getCompanyId() != companyId || virtualHost2.getLayoutSetId() != layoutSetId) {
                            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_C_L, (Object[])finderArgs, (Object)virtualHost2);
                        }
                    }
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_C_L, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (VirtualHost)result;
    }

    public VirtualHost removeByC_L(long companyId, long layoutSetId) throws NoSuchVirtualHostException, SystemException {
        VirtualHost virtualHost = this.findByC_L(companyId, layoutSetId);
        return (VirtualHost)this.remove((BaseModel)virtualHost);
    }

    public int countByC_L(long companyId, long layoutSetId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_C_L;
        Object[] finderArgs = new Object[]{companyId, layoutSetId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_VIRTUALHOST_WHERE);
            query.append(_FINDER_COLUMN_C_L_COMPANYID_2);
            query.append(_FINDER_COLUMN_C_L_LAYOUTSETID_2);
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(companyId);
                    qPos.add(layoutSetId);
                    count = (Long)q.uniqueResult();
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public VirtualHostPersistenceImpl() {
        this.setModelClass(VirtualHost.class);
    }

    public void cacheResult(VirtualHost virtualHost) {
        EntityCacheUtil.putResult((boolean)VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostImpl.class, (Serializable)Long.valueOf(virtualHost.getPrimaryKey()), (Serializable)virtualHost);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_HOSTNAME, (Object[])new Object[]{virtualHost.getHostname()}, (Object)virtualHost);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_C_L, (Object[])new Object[]{virtualHost.getCompanyId(), virtualHost.getLayoutSetId()}, (Object)virtualHost);
        virtualHost.resetOriginalValues();
    }

    public void cacheResult(List<VirtualHost> virtualHosts) {
        for (VirtualHost virtualHost : virtualHosts) {
            if (EntityCacheUtil.getResult((boolean)VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostImpl.class, (Serializable)Long.valueOf(virtualHost.getPrimaryKey())) == null) {
                this.cacheResult(virtualHost);
                continue;
            }
            virtualHost.resetOriginalValues();
        }
    }

    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear((String)VirtualHostImpl.class.getName());
        }
        EntityCacheUtil.clearCache((String)VirtualHostImpl.class.getName());
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(VirtualHost virtualHost) {
        EntityCacheUtil.removeResult((boolean)VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostImpl.class, (Serializable)Long.valueOf(virtualHost.getPrimaryKey()));
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache(virtualHost);
    }

    public void clearCache(List<VirtualHost> virtualHosts) {
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (VirtualHost virtualHost : virtualHosts) {
            EntityCacheUtil.removeResult((boolean)VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostImpl.class, (Serializable)Long.valueOf(virtualHost.getPrimaryKey()));
            this.clearUniqueFindersCache(virtualHost);
        }
    }

    protected void cacheUniqueFindersCache(VirtualHost virtualHost) {
        if (virtualHost.isNew()) {
            Object[] args = new Object[]{virtualHost.getHostname()};
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_HOSTNAME, (Object[])args, (Object)1L);
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_HOSTNAME, (Object[])args, (Object)virtualHost);
            args = new Object[]{virtualHost.getCompanyId(), virtualHost.getLayoutSetId()};
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_C_L, (Object[])args, (Object)1L);
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_C_L, (Object[])args, (Object)virtualHost);
        } else {
            Object[] args;
            VirtualHostModelImpl virtualHostModelImpl = (VirtualHostModelImpl)virtualHost;
            if ((virtualHostModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_HOSTNAME.getColumnBitmask()) != 0L) {
                args = new Object[]{virtualHost.getHostname()};
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_HOSTNAME, (Object[])args, (Object)1L);
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_HOSTNAME, (Object[])args, (Object)virtualHost);
            }
            if ((virtualHostModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_C_L.getColumnBitmask()) != 0L) {
                args = new Object[]{virtualHost.getCompanyId(), virtualHost.getLayoutSetId()};
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_C_L, (Object[])args, (Object)1L);
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_C_L, (Object[])args, (Object)virtualHost);
            }
        }
    }

    protected void clearUniqueFindersCache(VirtualHost virtualHost) {
        VirtualHostModelImpl virtualHostModelImpl = (VirtualHostModelImpl)virtualHost;
        Object[] args = new Object[]{virtualHost.getHostname()};
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_HOSTNAME, (Object[])args);
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_HOSTNAME, (Object[])args);
        if ((virtualHostModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_HOSTNAME.getColumnBitmask()) != 0L) {
            args = new Object[]{virtualHostModelImpl.getOriginalHostname()};
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_HOSTNAME, (Object[])args);
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_HOSTNAME, (Object[])args);
        }
        args = new Object[]{virtualHost.getCompanyId(), virtualHost.getLayoutSetId()};
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_C_L, (Object[])args);
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_C_L, (Object[])args);
        if ((virtualHostModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_C_L.getColumnBitmask()) != 0L) {
            args = new Object[]{virtualHostModelImpl.getOriginalCompanyId(), virtualHostModelImpl.getOriginalLayoutSetId()};
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_C_L, (Object[])args);
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_C_L, (Object[])args);
        }
    }

    public VirtualHost create(long virtualHostId) {
        VirtualHostImpl virtualHost = new VirtualHostImpl();
        virtualHost.setNew(true);
        virtualHost.setPrimaryKey(virtualHostId);
        return virtualHost;
    }

    public VirtualHost remove(long virtualHostId) throws NoSuchVirtualHostException, SystemException {
        return this.remove(Long.valueOf(virtualHostId));
    }

    public VirtualHost remove(Serializable primaryKey) throws NoSuchVirtualHostException, SystemException {
        Session session = null;
        try {
            session = this.openSession();
            VirtualHost virtualHost = (VirtualHost)session.get(VirtualHostImpl.class, primaryKey);
            if (virtualHost == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchVirtualHostException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            VirtualHost virtualHost2 = (VirtualHost)this.remove((BaseModel)virtualHost);
            return virtualHost2;
        }
        catch (NoSuchVirtualHostException nsee) {
            throw nsee;
        }
        catch (Exception e2) {
            throw this.processException(e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected VirtualHost removeImpl(VirtualHost virtualHost) throws SystemException {
        virtualHost = this.toUnwrappedModel(virtualHost);
        Session session = null;
        try {
            try {
                session = this.openSession();
                if (!session.contains((Object)virtualHost)) {
                    virtualHost = (VirtualHost)session.get(VirtualHostImpl.class, virtualHost.getPrimaryKeyObj());
                }
                if (virtualHost != null) {
                    session.delete((Object)virtualHost);
                }
            }
            catch (Exception e2) {
                throw this.processException(e2);
            }
        }
        finally {
            this.closeSession(session);
        }
        if (virtualHost != null) {
            this.clearCache(virtualHost);
        }
        return virtualHost;
    }

    public VirtualHost updateImpl(VirtualHost virtualHost) throws SystemException {
        virtualHost = this.toUnwrappedModel(virtualHost);
        boolean isNew = virtualHost.isNew();
        Session session = null;
        try {
            try {
                session = this.openSession();
                if (virtualHost.isNew()) {
                    session.save((Object)virtualHost);
                    virtualHost.setNew(false);
                } else {
                    session.merge((Object)virtualHost);
                }
            }
            catch (Exception e2) {
                throw this.processException(e2);
            }
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (isNew || !VirtualHostModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }
        EntityCacheUtil.putResult((boolean)VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostImpl.class, (Serializable)Long.valueOf(virtualHost.getPrimaryKey()), (Serializable)virtualHost);
        this.clearUniqueFindersCache(virtualHost);
        this.cacheUniqueFindersCache(virtualHost);
        return virtualHost;
    }

    protected VirtualHost toUnwrappedModel(VirtualHost virtualHost) {
        if (virtualHost instanceof VirtualHostImpl) {
            return virtualHost;
        }
        VirtualHostImpl virtualHostImpl = new VirtualHostImpl();
        virtualHostImpl.setNew(virtualHost.isNew());
        virtualHostImpl.setPrimaryKey(virtualHost.getPrimaryKey());
        virtualHostImpl.setVirtualHostId(virtualHost.getVirtualHostId());
        virtualHostImpl.setCompanyId(virtualHost.getCompanyId());
        virtualHostImpl.setLayoutSetId(virtualHost.getLayoutSetId());
        virtualHostImpl.setHostname(virtualHost.getHostname());
        return virtualHostImpl;
    }

    public VirtualHost findByPrimaryKey(Serializable primaryKey) throws NoSuchVirtualHostException, SystemException {
        VirtualHost virtualHost = this.fetchByPrimaryKey(primaryKey);
        if (virtualHost == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchVirtualHostException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return virtualHost;
    }

    public VirtualHost findByPrimaryKey(long virtualHostId) throws NoSuchVirtualHostException, SystemException {
        return this.findByPrimaryKey(Long.valueOf(virtualHostId));
    }

    public VirtualHost fetchByPrimaryKey(Serializable primaryKey) throws SystemException {
        VirtualHost virtualHost = (VirtualHost)EntityCacheUtil.getResult((boolean)VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostImpl.class, (Serializable)primaryKey);
        if (virtualHost == _nullVirtualHost) {
            return null;
        }
        if (virtualHost == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    virtualHost = (VirtualHost)session.get(VirtualHostImpl.class, primaryKey);
                    if (virtualHost != null) {
                        this.cacheResult(virtualHost);
                    } else {
                        EntityCacheUtil.putResult((boolean)VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostImpl.class, (Serializable)primaryKey, (Serializable)_nullVirtualHost);
                    }
                }
                catch (Exception e2) {
                    EntityCacheUtil.removeResult((boolean)VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostImpl.class, (Serializable)primaryKey);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return virtualHost;
    }

    public VirtualHost fetchByPrimaryKey(long virtualHostId) throws SystemException {
        return this.fetchByPrimaryKey(Long.valueOf(virtualHostId));
    }

    public List<VirtualHost> findAll() throws SystemException {
        return this.findAll(-1, -1, null);
    }

    public List<VirtualHost> findAll(int start, int end) throws SystemException {
        return this.findAll(start, end, null);
    }

    public List<VirtualHost> findAll(int start, int end, OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 3);
                query.append(_SQL_SELECT_VIRTUALHOST);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_VIRTUALHOST;
                if (pagination) {
                    sql = sql.concat(" ORDER BY virtualHost.virtualHostId ASC");
                }
            }
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    if (!pagination) {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                        Collections.sort(list);
                        list = new UnmodifiableList(list);
                    } else {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() throws SystemException {
        for (VirtualHost virtualHost : this.findAll()) {
            this.remove((BaseModel)virtualHost);
        }
    }

    public int countAll() throws SystemException {
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])FINDER_ARGS_EMPTY, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(_SQL_COUNT_VIRTUALHOST);
                    count = (Long)q.uniqueResult();
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])FINDER_ARGS_EMPTY, (Object)count);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])FINDER_ARGS_EMPTY);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("value.object.listener.com.liferay.portal.model.VirtualHost")));
        if (listenerClassNames.length > 0) {
            try {
                ArrayList<ModelListener> listenersList = new ArrayList<ModelListener>();
                String[] stringArray = listenerClassNames;
                int n = listenerClassNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String listenerClassName = stringArray[n2];
                    listenersList.add((ModelListener)InstanceFactory.newInstance((ClassLoader)this.getClassLoader(), (String)listenerClassName));
                    ++n2;
                }
                this.listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            }
            catch (Exception e2) {
                _log.error((Throwable)e2);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache((String)VirtualHostImpl.class.getName());
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

