/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.shopping.model.ShoppingCategory;
import com.liferay.portlet.shopping.service.ShoppingCategoryLocalServiceUtil;
import com.liferay.portlet.shopping.service.permission.ShoppingPermission;

public class ShoppingCategoryPermission {
    public static void check(PermissionChecker permissionChecker, long groupId, long categoryId, String actionId) throws PortalException, SystemException {
        if (!ShoppingCategoryPermission.contains(permissionChecker, groupId, categoryId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, ShoppingCategory category, String actionId) throws PortalException, SystemException {
        if (!ShoppingCategoryPermission.contains(permissionChecker, category, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long categoryId, String actionId) throws PortalException, SystemException {
        if (categoryId == 0L) {
            return ShoppingPermission.contains(permissionChecker, groupId, actionId);
        }
        ShoppingCategory category = ShoppingCategoryLocalServiceUtil.getCategory((long)categoryId);
        return ShoppingCategoryPermission.contains(permissionChecker, category, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, ShoppingCategory category, String actionId) throws PortalException, SystemException {
        if (actionId.equals("ADD_CATEGORY")) {
            actionId = "ADD_SUBCATEGORY";
        }
        if (actionId.equals("VIEW") && PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
            long categoryId = category.getCategoryId();
            while (categoryId != 0L) {
                category = ShoppingCategoryLocalServiceUtil.getCategory((long)categoryId);
                if (!ShoppingCategoryPermission._hasPermission(permissionChecker, category, actionId)) {
                    return false;
                }
                categoryId = category.getParentCategoryId();
            }
            return ShoppingPermission.contains(permissionChecker, category.getGroupId(), actionId);
        }
        return ShoppingCategoryPermission._hasPermission(permissionChecker, category, actionId);
    }

    private static boolean _hasPermission(PermissionChecker permissionChecker, ShoppingCategory category, String actionId) {
        return permissionChecker.hasOwnerPermission(category.getCompanyId(), ShoppingCategory.class.getName(), category.getCategoryId(), category.getUserId(), actionId) || permissionChecker.hasPermission(category.getGroupId(), ShoppingCategory.class.getName(), category.getCategoryId(), actionId);
    }
}

