/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import java.net.UnknownHostException;
import java.util.List;
import org.gcube.contentmanagement.blobstorage.resource.MemoryType;
import org.gcube.contentmanagement.blobstorage.resource.RequestObject;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.operation.Download;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.MongoIOManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MoveDir
extends Operation {
    final Logger logger = LoggerFactory.getLogger(Download.class);
    private String sourcePath;
    private String destinationPath;
    private RequestObject resource;

    public MoveDir(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType, String[] dbs) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType, dbs);
    }

    @Override
    public String initOperation(RequestObject file, String remotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        this.sourcePath = file.getLocalPath();
        this.destinationPath = remotePath;
        this.sourcePath = new BucketCoding().bucketFileCoding(file.getLocalPath(), rootArea);
        this.destinationPath = new BucketCoding().bucketFileCoding(remotePath, rootArea);
        this.setResource(file);
        this.bucket = this.destinationPath;
        return this.bucket;
    }

    @Override
    public String doIt(RequestObject myFile) throws RemoteBackendException {
        TransportManager tm = this.getTransport(myFile);
        List<String> ids = null;
        try {
            ids = tm.moveDir(this);
        }
        catch (UnknownHostException e) {
            tm.close();
            this.logger.error("Problem in moveDir from: " + this.sourcePath + " to: " + this.destinationPath + ": " + e.getMessage());
            throw new RemoteBackendException(" Error in moveDir operation ", e.getCause());
        }
        return ids.toString();
    }

    @Override
    public String initOperation(RequestObject resource, String remotePath, String author, String[] server, String rootArea) {
        this.sourcePath = resource.getLocalPath();
        this.destinationPath = resource.getRemotePath();
        this.sourcePath = new BucketCoding().bucketFileCoding(resource.getLocalPath(), rootArea);
        this.destinationPath = new BucketCoding().bucketFileCoding(resource.getRemotePath(), rootArea);
        this.setResource(resource);
        this.bucket = this.destinationPath;
        return this.bucket;
    }

    public abstract List<String> execute(MongoIOManager var1, RequestObject var2, String var3, String var4, MemoryType var5) throws UnknownHostException;

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public String getDestinationPath() {
        return this.destinationPath;
    }

    public void setDestinationPath(String destinationPath) {
        this.destinationPath = destinationPath;
    }

    public RequestObject getResource() {
        return this.resource;
    }

    public void setResource(RequestObject resource) {
        this.resource = resource;
    }
}

