/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport.backend.operation;

import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFSDBFile;
import java.io.FileNotFoundException;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;
import org.gcube.contentmanagement.blobstorage.resource.RequestObject;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Unlock;
import org.gcube.contentmanagement.blobstorage.transport.backend.MongoIOManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnlockOperator
extends Unlock {
    Logger logger = LoggerFactory.getLogger(UnlockOperator.class);

    public UnlockOperator(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType, String[] dbs) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType, dbs);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String execute(MongoIOManager mongoPrimaryInstance, MongoIOManager mongoSecondaryInstance, RequestObject resource, String bucket, String key4unlock) throws Exception {
        GridFSDBFile f;
        String id = null;
        OperationDefinition op = resource.getOperationDefinition();
        OperationDefinition.REMOTE_RESOURCE remoteResourceIdentifier = resource.getOperation().getRemoteResource();
        this.logger.info("MongoClient unlock method: " + op.toString());
        String dir = resource.getRemoteDir();
        String name = resource.getName();
        String path = this.getBucket();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DIR: " + dir + " name: " + name + " fullPath " + path + " bucket: " + bucket);
        }
        if ((f = mongoPrimaryInstance.retrieveRemoteDescriptor(path, remoteResourceIdentifier, true)) == null) {
            mongoPrimaryInstance.close();
            throw new FileNotFoundException(path);
        }
        String oldir = (String)f.get("dir");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("old dir  found " + oldir);
        }
        if (!oldir.equalsIgnoreCase(resource.getRemoteDir()) && resource.getRemoteDir() != null) {
            mongoPrimaryInstance.close();
            throw new FileNotFoundException(path);
        }
        String lock = (String)f.get("lock");
        if (lock != null && !lock.isEmpty()) {
            String lck = (String)f.get("lock");
            if (lck.equalsIgnoreCase(key4unlock)) {
                f.put("lock", null);
                f.put("timestamp", null);
                mongoPrimaryInstance.updateCommonFields((DBObject)f, resource, OperationDefinition.OPERATION.UNLOCK);
                f.save();
                return id;
            }
            mongoPrimaryInstance.close();
            throw new IllegalAccessError("bad key for unlock");
        }
        mongoPrimaryInstance.updateCommonFields((DBObject)f, resource, OperationDefinition.OPERATION.UNLOCK);
        f.save();
        return id;
    }
}

