/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import java.io.Serializable;

public class ByteArrays {
    public static final long ONEOVERPHI = 106039L;
    public static final byte[] EMPTY_ARRAY = new byte[0];
    public static final Hash.Strategy<byte[]> HASH_STRATEGY = new ArrayHashStrategy();

    private ByteArrays() {
    }

    public static byte[] ensureCapacity(byte[] array, int length) {
        if (length > array.length) {
            byte[] t = new byte[length];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static byte[] ensureCapacity(byte[] array, int length, int preserve) {
        if (length > array.length) {
            byte[] t = new byte[length];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static byte[] grow(byte[] array, int length) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            byte[] t = new byte[newLength];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static byte[] grow(byte[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            byte[] t = new byte[newLength];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static byte[] trim(byte[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        byte[] t = length == 0 ? EMPTY_ARRAY : new byte[length];
        System.arraycopy(array, 0, t, 0, length);
        return t;
    }

    public static byte[] setLength(byte[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return ByteArrays.trim(array, length);
        }
        return ByteArrays.ensureCapacity(array, length);
    }

    public static byte[] copy(byte[] array, int offset, int length) {
        ByteArrays.ensureOffsetLength(array, offset, length);
        byte[] a = length == 0 ? EMPTY_ARRAY : new byte[length];
        System.arraycopy(array, offset, a, 0, length);
        return a;
    }

    public static byte[] copy(byte[] array) {
        return (byte[])array.clone();
    }

    public static void fill(byte[] array, byte value) {
        int i = array.length;
        while (i-- != 0) {
            array[i] = value;
        }
    }

    public static void fill(byte[] array, int from, int to, byte value) {
        ByteArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            for (int i = from; i < to; ++i) {
                array[i] = value;
            }
        }
    }

    public static boolean equals(byte[] a1, byte[] a2) {
        int i = a1.length;
        if (i != a2.length) {
            return false;
        }
        while (i-- != 0) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(byte[] a, int from, int to) {
        Arrays.ensureFromTo(a.length, from, to);
    }

    public static void ensureOffsetLength(byte[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ArrayHashStrategy
    implements Hash.Strategy<byte[]>,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(byte[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(byte[] a, byte[] b) {
            return ByteArrays.equals(a, b);
        }
    }
}

