/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import java.io.OutputStream;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.service.operation.Upload;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.MongoIOManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanagement.blobstorage.transport.backend.operation.UploadOperator;

public abstract class Unlock
extends Operation {
    private String keyUnlock;
    protected String localPath;
    protected String remotePath;
    protected OutputStream os;
    protected MyFile resource;
    protected Upload upload;

    public Unlock(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType, String[] dbs) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType, dbs);
    }

    @Override
    public String doIt(MyFile myFile) throws RemoteBackendException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" UPLOAD " + myFile.getLocalPath() + " author: " + myFile.getOwner());
        }
        String objectId = null;
        try {
            UploadOperator upload = new UploadOperator(this.getServer(), this.getUser(), this.getPassword(), this.getBucket(), this.getMonitor(), this.isChunk(), this.getBackendType(), this.getDbNames());
            objectId = this.put(upload, myFile, this.isChunk(), false, false, true);
        }
        catch (Exception e) {
            TransportManager tm = this.getTransport(myFile);
            tm.close();
            throw new RemoteBackendException(" Error in unlock operation ", e.getCause());
        }
        return objectId;
    }

    @Override
    public String initOperation(MyFile file, String remotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        String bucketName = null;
        bucketName = remotePath.length() < 23 || remotePath.contains("/") ? new BucketCoding().bucketFileCoding(remotePath, rootArea) : remotePath;
        this.bucket = bucketName;
        return this.bucket;
    }

    @Override
    public String initOperation(MyFile resource, String RemotePath, String author, String[] server, String rootArea) {
        return null;
    }

    public abstract String execute(MongoIOManager var1, MongoIOManager var2, MyFile var3, String var4, String var5) throws Exception;

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public String getRemotePath() {
        return this.remotePath;
    }

    public void setRemotePath(String remotePath) {
        this.remotePath = remotePath;
    }

    public OutputStream getOs() {
        return this.os;
    }

    public void setOs(OutputStream os) {
        this.os = os;
    }

    public MyFile getResource() {
        return this.resource;
    }

    public void setResource(MyFile resource) {
        this.resource = resource;
    }

    public Upload getUpload() {
        return this.upload;
    }

    public void setUpload(Upload upload) {
        this.upload = upload;
    }

    public String getKeyUnlock() {
        return this.keyUnlock;
    }

    public void setKeyUnlock(String keyUnlock) {
        this.keyUnlock = keyUnlock;
    }
}

