/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport.backend.operation;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DuplicateKeyException;
import com.mongodb.gridfs.GridFSDBFile;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.Objects;
import org.bson.types.ObjectId;
import org.gcube.contentmanagement.blobstorage.resource.MemoryType;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.SoftCopy;
import org.gcube.contentmanagement.blobstorage.transport.backend.MongoIOManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.MongoOperationManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanagement.blobstorage.transport.backend.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoftCopyOperator
extends SoftCopy {
    Logger logger = LoggerFactory.getLogger(SoftCopyOperator.class);
    private MemoryType memoryType;
    private MongoIOManager mongoPrimaryInstance;
    private MyFile resource;

    public SoftCopyOperator(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType, String[] dbs) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType, dbs);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String execute(MongoIOManager mongoPrimaryInstance, MyFile resource, String sourcePath, String destinationPath) throws UnknownHostException {
        OperationDefinition.REMOTE_RESOURCE remoteResourceIdentifier = resource.getOperation().getRemoteResource();
        OperationDefinition.LOCAL_RESOURCE localResourceIdentifier = resource.getOperation().getLocalResource();
        String source = null;
        source = localResourceIdentifier.equals((Object)OperationDefinition.LOCAL_RESOURCE.ID) ? resource.getId() : sourcePath;
        String destination = null;
        destination = remoteResourceIdentifier.equals((Object)OperationDefinition.REMOTE_RESOURCE.ID) ? resource.getId() : destinationPath;
        if (resource != null) {
            String dir = resource.getRemoteDir();
            String name = resource.getName();
            this.setMemoryType(resource.getGcubeMemoryType());
        }
        this.setMongoPrimaryInstance(mongoPrimaryInstance);
        ObjectId mapId = null;
        GridFSDBFile destObject = null;
        this.logger.debug("softCopy operation on Mongo backend, parameters: source path: " + source + " destination path: " + destination);
        if (source == null || source.isEmpty()) throw new RemoteBackendException("Invalid arguments: source " + source + " destination " + destination);
        GridFSDBFile sourceObject = mongoPrimaryInstance.retrieveRemoteDescriptor(source, remoteResourceIdentifier, true);
        if (sourceObject != null) {
            sourceObject = mongoPrimaryInstance.retrieveLinkPayload(sourceObject);
            ObjectId sourceId = (ObjectId)sourceObject.getId();
            this.logger.debug("source id is " + sourceId);
            InputStream is = sourceObject.getInputStream();
            resource.setInputStream(is);
            GridFSDBFile dest = null;
            if (destination == null || destination.isEmpty()) {
                if (sourceId == null) {
                    throw new RemoteBackendException("source object not found: " + source);
                }
                destination = this.fillGenericDestinationFields(resource, sourceId);
                this.logger.warn("SoftCopy without destination parameter. The operation will be executed with the following destination path " + destination);
            } else {
                dest = mongoPrimaryInstance.retrieveRemoteDescriptor(destination, remoteResourceIdentifier, false);
            }
            ObjectId removedId = null;
            if (dest != null) {
                String destId = dest.getId().toString();
                this.logger.debug("destination id is " + destId);
                if (sourceId.toString().equals(destId)) {
                    this.logger.info("source and destination are pointing to the same object. The copy operation will have no effects");
                    return destId;
                }
                if (!resource.isReplace()) return destId;
                removedId = mongoPrimaryInstance.removeFile(resource, null, resource.isReplace(), null, dest);
            }
            DBCollection metaCollectionInstance = this.getMetaCollection();
            String md5 = sourceObject.getMD5();
            ObjectId md5Id = this.getDuplicatesMap(md5);
            if (this.isMap(sourceObject)) {
                this.logger.debug("the sourceObject with the following id: " + sourceId + " is already a map");
                mapId = sourceId;
                DBObject newObject = this.createNewLinkObject(resource, sourceObject, destination, metaCollectionInstance, md5, mapId, removedId);
                destObject = mongoPrimaryInstance.retrieveRemoteDescriptor(destination, remoteResourceIdentifier, true);
                mapId = this.addToDuplicateMap(metaCollectionInstance, mapId, destObject);
            } else if (md5Id != null) {
                mapId = md5Id;
                this.logger.debug("retrieved md5 on backend with the following id: " + mapId);
                mapId = this.addToDuplicateMap(metaCollectionInstance, mapId, sourceObject);
                DBObject newObject = this.createNewLinkObject(resource, sourceObject, destination, metaCollectionInstance, md5, mapId, removedId);
                destObject = mongoPrimaryInstance.retrieveRemoteDescriptor(destination, remoteResourceIdentifier, true);
                mapId = this.addToDuplicateMap(metaCollectionInstance, mapId, destObject);
            } else {
                mapId = this.createNewDuplicatesMap(metaCollectionInstance, resource, sourceObject, destination, sourceId);
                mapId = this.addToDuplicateMap(metaCollectionInstance, mapId, sourceObject);
                DBObject newObject = this.createNewLinkObject(resource, sourceObject, destination, metaCollectionInstance, md5, mapId, removedId);
                destObject = mongoPrimaryInstance.retrieveRemoteDescriptor(destination, remoteResourceIdentifier, true);
                mapId = this.addToDuplicateMap(metaCollectionInstance, mapId, destObject);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("mapId created/updated: " + mapId);
            }
        } else {
            mongoPrimaryInstance.close();
            throw new RemoteBackendException(" the source path is wrong. There isn't a file at " + source);
        }
        mongoPrimaryInstance.close();
        return destObject.getId().toString();
    }

    private String fillGenericDestinationFields(MyFile resource, ObjectId souceId) {
        String destination = resource.getRootPath() + souceId;
        resource.setName(souceId.toString());
        resource.setRemoteDir(resource.getRootPath());
        return destination;
    }

    private ObjectId createNewDuplicatesMap(DBCollection metaCollectionInstance, Object resource, GridFSDBFile sourceObject, String bucket, ObjectId sourceId) throws UnknownHostException {
        ObjectId id = null;
        String dir = ((MyFile)resource).getRemoteDir();
        if (dir != null && !dir.isEmpty() && bucket != null && !bucket.isEmpty()) {
            this.getMongoPrimaryInstance().buildDirTree(this.getMongoPrimaryInstance().getMetaDataCollection(null), dir);
        }
        id = this.createNewObjectMap(metaCollectionInstance, (MyFile)resource, sourceObject, sourceId);
        return id;
    }

    private ObjectId createNewObjectMap(DBCollection metaCollectionInstance, MyFile resource, GridFSDBFile source, ObjectId sourceId) throws UnknownHostException {
        String md5 = source.getMD5();
        BasicDBObject document = new BasicDBObject("type", (Object)"map");
        document.put("count", (Object)0);
        ObjectId id = new ObjectId();
        document.put("_id", (Object)id);
        this.logger.debug("generated id for new map" + id);
        document = this.fillCommonfields((DBObject)document, resource, source, metaCollectionInstance, md5);
        this.getMongoPrimaryInstance().updateChunksCollection(sourceId, id);
        return id;
    }

    private DBObject createNewLinkObject(MyFile resource, GridFSDBFile sourceObject, String destination, DBCollection metaCollectionInstance, String md5, ObjectId mapId, ObjectId newId) {
        BasicDBObject document = new BasicDBObject("type", (Object)"file");
        document.put("filename", (Object)destination);
        document.put("name", (Object)resource.getName());
        document.put("dir", (Object)resource.getRemoteDir());
        document.put("owner", (Object)resource.getOwner());
        document.put("link", (Object)mapId.toString());
        ObjectId id = null;
        if (newId == null) {
            id = new ObjectId();
            this.logger.debug("generated id for new object link " + id);
        } else {
            id = newId;
            this.logger.debug("restored id for new object link " + id);
        }
        document.put("_id", (Object)id);
        return this.fillCommonfields((DBObject)document, resource, sourceObject, metaCollectionInstance, md5);
    }

    private DBObject fillCommonfields(DBObject document, MyFile resource, GridFSDBFile sourceObject, DBCollection metaCollectionInstance, String md5) {
        document.put("mimetype", (Object)resource.getMimeType());
        document.put("creationTime", (Object)DateUtils.now("dd MM yyyy 'at' hh:mm:ss z"));
        document.put("md5", (Object)md5);
        document.put("length", (Object)sourceObject.getLength());
        document.put("chunkSize", (Object)sourceObject.getChunkSize());
        try {
            metaCollectionInstance.insert(new DBObject[]{document});
            metaCollectionInstance.save(document);
        }
        catch (DuplicateKeyException e) {
            this.logger.warn("key already present or not completely removed. Wait few seconds and retry");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            metaCollectionInstance.insert(new DBObject[]{document});
            metaCollectionInstance.save(document);
        }
        return document;
    }

    private DBCollection getMetaCollection() throws UnknownHostException {
        DBCollection metaCollectionInstance = null;
        metaCollectionInstance = this.getMemoryType() != MemoryType.VOLATILE ? this.mongoPrimaryInstance.getMetaDataCollection(this.mongoPrimaryInstance.getConnectionDB(MongoOperationManager.getPrimaryCollectionName(), true)) : this.mongoPrimaryInstance.getMetaDataCollection(this.mongoPrimaryInstance.getConnectionDB(MongoOperationManager.getPrimaryCollectionName(), false));
        return metaCollectionInstance;
    }

    private ObjectId addToDuplicateMap(DBCollection metaCollectionInstance, ObjectId mapId, GridFSDBFile f) throws UnknownHostException {
        f.put("link", (Object)mapId.toString());
        this.mongoPrimaryInstance.updateCommonFields((DBObject)f, this.getResource(), OperationDefinition.OPERATION.SOFT_COPY);
        f.save();
        this.incrementCountField(metaCollectionInstance, mapId);
        return mapId;
    }

    private void incrementCountField(DBCollection metaCollectionInstance, ObjectId mapId) throws UnknownHostException {
        this.logger.info("increment count field on" + mapId + " object map");
        BasicDBObject searchQuery = new BasicDBObject();
        searchQuery.put((Object)"_id", (Object)mapId);
        DBObject mapObject = this.mongoPrimaryInstance.findCollectionObject(metaCollectionInstance, searchQuery);
        if (!Objects.isNull(mapObject)) {
            Object counting = mapObject.get("count");
            if (Objects.nonNull(counting)) {
                int count = (Integer)counting;
                mapObject.put("count", (Object)(++count));
            } else {
                mapObject.put("count", (Object)1);
            }
            metaCollectionInstance.save(mapObject);
        } else {
            this.logger.error("no object found associated to the following id: " + mapId);
        }
    }

    private ObjectId getDuplicatesMap(String md5) {
        ObjectId id = this.checkMd5(md5);
        return id;
    }

    private boolean isMap(GridFSDBFile sourceObject) {
        String type = sourceObject.get("type").toString();
        this.logger.debug("object type: " + type);
        if (type.equals("map")) {
            this.logger.debug("sourceFile is a map: " + sourceObject.toString());
            return true;
        }
        return false;
    }

    private ObjectId checkMd5(String md5) {
        return null;
    }

    public MemoryType getMemoryType() {
        return this.memoryType;
    }

    public void setMemoryType(MemoryType memoryType) {
        this.memoryType = memoryType;
    }

    public MongoIOManager getMongoPrimaryInstance() {
        return this.mongoPrimaryInstance;
    }

    public void setMongoPrimaryInstance(MongoIOManager mongoPrimaryInstance) {
        this.mongoPrimaryInstance = mongoPrimaryInstance;
    }

    @Override
    public MyFile getResource() {
        return this.resource;
    }

    @Override
    public void setResource(MyFile resource) {
        this.resource = resource;
    }
}

