/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jackrabbit.core.config.BeanConfig;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.xml.ProtectedNodeImporter;
import org.apache.jackrabbit.core.xml.ProtectedPropertyImporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportConfig {
    private static final Logger log = LoggerFactory.getLogger(ImportConfig.class);
    private final List<BeanConfig> protectedNodeImporters;
    private final List<BeanConfig> protectedPropertyImporters;

    public ImportConfig() {
        this.protectedNodeImporters = Collections.emptyList();
        this.protectedPropertyImporters = Collections.emptyList();
    }

    public ImportConfig(List<BeanConfig> protectedNodeImporters, List<BeanConfig> protectedPropertyImporters) {
        this.protectedNodeImporters = protectedNodeImporters;
        this.protectedPropertyImporters = protectedPropertyImporters;
    }

    public List<ProtectedNodeImporter> getProtectedNodeImporters() {
        ArrayList<ProtectedNodeImporter> pnis = new ArrayList<ProtectedNodeImporter>();
        for (BeanConfig bc : this.protectedNodeImporters) {
            try {
                pnis.add(bc.newInstance(ProtectedNodeImporter.class));
            }
            catch (ConfigurationException e) {
                log.warn(e.getMessage());
            }
        }
        return pnis;
    }

    public List<ProtectedPropertyImporter> getProtectedPropertyImporters() {
        ArrayList<ProtectedPropertyImporter> ppis = new ArrayList<ProtectedPropertyImporter>();
        for (BeanConfig bc : this.protectedPropertyImporters) {
            try {
                ppis.add(bc.newInstance(ProtectedPropertyImporter.class));
            }
            catch (ConfigurationException e) {
                log.warn(e.getMessage());
            }
        }
        return ppis;
    }
}

