/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import org.hsqldb.lib.tar.RB;
import org.hsqldb.lib.tar.TarGenerator;
import org.hsqldb.lib.tar.TarMalformatException;
import org.hsqldb.lib.tar.TarReader;

public class DbBackup {
    protected File dbDir;
    protected File archiveFile;
    protected String instanceName;
    protected boolean overWrite = false;
    protected boolean abortUponModify = true;

    public static void main(String[] sa) throws IOException, TarMalformatException {
        block13: {
            try {
                if (sa.length < 1) {
                    System.out.println(RB.DbBackup_syntax.getString(DbBackup.class.getName()));
                    System.out.println();
                    System.out.println(RB.listing_format.getString());
                    System.exit(0);
                }
                if (sa[0].equals("--save")) {
                    boolean overWrite = sa.length > 1 && sa[1].equals("--overwrite");
                    if (sa.length != (overWrite ? 4 : 3)) {
                        throw new IllegalArgumentException();
                    }
                    DbBackup backup = new DbBackup(new File(sa[sa.length - 2]), sa[sa.length - 1]);
                    backup.setOverWrite(overWrite);
                    backup.write();
                    break block13;
                }
                if (sa[0].equals("--list")) {
                    if (sa.length < 2) {
                        throw new IllegalArgumentException();
                    }
                    String[] patternStrings = null;
                    if (sa.length > 2) {
                        patternStrings = new String[sa.length - 2];
                        for (int i = 2; i < sa.length; ++i) {
                            patternStrings[i - 2] = sa[i];
                        }
                    }
                    new TarReader(new File(sa[1]), 0, patternStrings, new Integer(DbBackup.generateBufferBlockValue(new File(sa[1]))), null).read();
                    break block13;
                }
                if (sa[0].equals("--extract")) {
                    int firstPatInd;
                    boolean overWrite = sa.length > 1 && sa[1].equals("--overwrite");
                    int n = firstPatInd = overWrite ? 4 : 3;
                    if (sa.length < firstPatInd) {
                        throw new IllegalArgumentException();
                    }
                    String[] patternStrings = null;
                    if (sa.length > firstPatInd) {
                        patternStrings = new String[sa.length - firstPatInd];
                        for (int i = firstPatInd; i < sa.length; ++i) {
                            patternStrings[i - firstPatInd] = sa[i];
                        }
                    }
                    File tarFile = new File(sa[overWrite ? 2 : 1]);
                    int tarReaderMode = overWrite ? 2 : 1;
                    new TarReader(tarFile, tarReaderMode, patternStrings, new Integer(DbBackup.generateBufferBlockValue(tarFile)), new File(sa[firstPatInd - 1])).read();
                    break block13;
                }
                throw new IllegalArgumentException();
            }
            catch (IllegalArgumentException iae) {
                System.out.println(RB.DbBackup_syntaxerr.getString(DbBackup.class.getName()));
                System.exit(2);
            }
        }
    }

    public DbBackup(File archiveFile, String dbPath) {
        this.archiveFile = archiveFile;
        File dbPathFile = new File(dbPath);
        this.dbDir = dbPathFile.getAbsoluteFile().getParentFile();
        this.instanceName = dbPathFile.getName();
    }

    public void setOverWrite(boolean overWrite) {
        this.overWrite = overWrite;
    }

    public void setAbortUponModify(boolean abortUponModify) {
        this.abortUponModify = abortUponModify;
    }

    public boolean getOverWrite() {
        return this.overWrite;
    }

    public boolean getAbortUponModify() {
        return this.abortUponModify;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException, TarMalformatException {
        File propertiesFile = new File(this.dbDir, this.instanceName + ".properties");
        File scriptFile = new File(this.dbDir, this.instanceName + ".script");
        File[] componentFiles = new File[]{propertiesFile, scriptFile, new File(this.dbDir, this.instanceName + ".backup"), new File(this.dbDir, this.instanceName + ".data"), new File(this.dbDir, this.instanceName + ".log"), new File(this.dbDir, this.instanceName + ".lobs")};
        boolean[] existList = new boolean[componentFiles.length];
        long startTime = new Date().getTime();
        for (int i = 0; i < existList.length; ++i) {
            existList[i] = componentFiles[i].exists();
            if (i >= 2 || existList[i]) continue;
            throw new FileNotFoundException(RB.file_missing.getString(componentFiles[i].getAbsolutePath()));
        }
        if (this.abortUponModify) {
            Properties p = new Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propertiesFile);
                p.load(fis);
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    Object var12_17 = null;
                    fis = null;
                }
                catch (Throwable throwable2) {
                    Object var12_18 = null;
                    fis = null;
                    throw throwable2;
                }
                throw throwable;
            }
            try {
                if (fis != null) {
                    fis.close();
                }
                Object var12_15 = null;
                fis = null;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                fis = null;
                throw throwable;
            }
            String modifiedString = p.getProperty("modified");
            if (modifiedString != null && (modifiedString.equalsIgnoreCase("yes") || modifiedString.equalsIgnoreCase("true"))) {
                throw new IllegalStateException(RB.modified_property.getString(modifiedString));
            }
        }
        TarGenerator generator = new TarGenerator(this.archiveFile, this.overWrite, new Integer(DbBackup.generateBufferBlockValue(componentFiles)));
        for (File componentFile : componentFiles) {
            if (!componentFile.exists()) continue;
            generator.queueEntry(componentFile.getName(), componentFile);
        }
        generator.write();
        if (this.abortUponModify) {
            try {
                for (int i = 0; i < componentFiles.length; ++i) {
                    if (componentFiles[i].exists()) {
                        if (!existList[i]) {
                            throw new FileNotFoundException(RB.file_disappeared.getString(componentFiles[i].getAbsolutePath()));
                        }
                        if (componentFiles[i].lastModified() <= startTime) continue;
                        throw new FileNotFoundException(RB.file_changed.getString(componentFiles[i].getAbsolutePath()));
                    }
                    if (!existList[i]) continue;
                    throw new FileNotFoundException(RB.file_appeared.getString(componentFiles[i].getAbsolutePath()));
                }
            }
            catch (IllegalStateException ise) {
                if (!this.archiveFile.delete()) {
                    System.out.println(RB.cleanup_rmfail.getString(this.archiveFile.getAbsolutePath()));
                }
                throw ise;
            }
        }
    }

    protected static int generateBufferBlockValue(File[] files) {
        long maxFileSize = 0L;
        for (File file : files) {
            if (file == null || file.length() <= maxFileSize) continue;
            maxFileSize = file.length();
        }
        int idealBlocks = (int)(maxFileSize / 5120L);
        if (idealBlocks < 1) {
            return 1;
        }
        if (idealBlocks > 40960) {
            return 40960;
        }
        return idealBlocks;
    }

    protected static int generateBufferBlockValue(File file) {
        return DbBackup.generateBufferBlockValue(new File[]{file});
    }
}

