/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

public class TimeData {
    final int zone;
    final int seconds;
    final int nanos;

    public TimeData(int seconds, int nanos, int zoneSeconds) {
        while (seconds < 0) {
            seconds += 86400;
        }
        if (seconds > 86400) {
            seconds %= 86400;
        }
        this.zone = zoneSeconds;
        this.seconds = seconds;
        this.nanos = nanos;
    }

    public TimeData(int seconds, int nanos) {
        this(seconds, nanos, 0);
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getNanos() {
        return this.nanos;
    }

    public int getZone() {
        return this.zone;
    }

    public boolean equals(Object other) {
        if (other instanceof TimeData) {
            return this.seconds == ((TimeData)other).seconds && this.nanos == ((TimeData)other).nanos && this.zone == ((TimeData)other).zone;
        }
        return false;
    }

    public int hashCode() {
        return this.seconds ^ this.nanos;
    }

    public int compareTo(TimeData b) {
        long diff = this.seconds - b.seconds;
        if (diff == 0L && (diff = (long)(this.nanos - b.nanos)) == 0L) {
            return 0;
        }
        return diff > 0L ? 1 : -1;
    }
}

