/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar.backgroundtask;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.BaseBackgroundTaskExecutor;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.DateRange;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.lar.backgroundtask.LayoutExportImportBackgroundTaskStatusMessageTranslator;
import com.liferay.portal.model.BackgroundTask;
import com.liferay.portal.service.BackgroundTaskLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import java.io.File;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class LayoutExportBackgroundTaskExecutor
extends BaseBackgroundTaskExecutor {
    public LayoutExportBackgroundTaskExecutor() {
        this.setBackgroundTaskStatusMessageTranslator(new LayoutExportImportBackgroundTaskStatusMessageTranslator());
        this.setSerial(true);
    }

    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        Map taskContextMap = backgroundTask.getTaskContextMap();
        long userId = MapUtil.getLong((Map)taskContextMap, (String)"userId");
        String fileName = MapUtil.getString((Map)taskContextMap, (String)"fileName");
        long groupId = MapUtil.getLong((Map)taskContextMap, (String)"groupId");
        boolean privateLayout = MapUtil.getBoolean((Map)taskContextMap, (String)"privateLayout");
        long[] layoutIds = GetterUtil.getLongValues(taskContextMap.get("layoutIds"));
        Map parameterMap = (Map)taskContextMap.get("parameterMap");
        Date startDate = (Date)taskContextMap.get("startDate");
        Date endDate = (Date)taskContextMap.get("endDate");
        File larFile = LayoutLocalServiceUtil.exportLayoutsAsFile((long)groupId, (boolean)privateLayout, (long[])layoutIds, (Map)parameterMap, (Date)startDate, (Date)endDate);
        BackgroundTaskLocalServiceUtil.addBackgroundTaskAttachment((long)userId, (long)backgroundTask.getBackgroundTaskId(), (String)fileName, (File)larFile);
        boolean updateLastPublishDate = MapUtil.getBoolean((Map)parameterMap, (String)"UPDATE_LAST_PUBLISH_DATE");
        if (updateLastPublishDate) {
            DateRange dateRange = new DateRange(startDate, endDate);
            StagingUtil.updateLastPublishDate((long)groupId, (boolean)privateLayout, (DateRange)dateRange, (Date)endDate);
        }
        return BackgroundTaskResult.SUCCESS;
    }

    public String handleException(BackgroundTask backgroundTask, Exception e2) {
        JSONObject jsonObject = StagingUtil.getExceptionMessagesJSONObject((Locale)this.getLocale(backgroundTask), (Exception)e2, (Map)backgroundTask.getTaskContextMap());
        return jsonObject.toString();
    }
}

