/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.service;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.api.BrowseException;
import com.browseengine.bobo.impl.BrowseServiceImpl;
import com.browseengine.bobo.impl.DefaultBrowseServiceImpl;
import com.browseengine.bobo.service.BrowseService;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;

public class BrowseServiceFactory {
    private static Logger logger = Logger.getLogger(BrowseServiceFactory.class);

    public static BrowseService createBrowseService(File idxDir) throws BrowseException {
        if (idxDir == null) {
            throw new IllegalArgumentException("Null index dir specified");
        }
        return new BrowseServiceImpl(idxDir);
    }

    public static BrowseService createBrowseService(BoboIndexReader bReader) {
        return new DefaultBrowseServiceImpl(bReader);
    }

    public static BoboIndexReader getBoboIndexReader(Directory idxDir) throws BrowseException {
        try {
            if (!BoboIndexReader.indexExists((Directory)idxDir)) {
                throw new BrowseException("Index does not exist at: " + idxDir);
            }
        }
        catch (IOException ioe) {
            throw new BrowseException(ioe.getMessage(), ioe);
        }
        IndexReader reader = null;
        try {
            reader = IndexReader.open((Directory)idxDir, (boolean)true);
        }
        catch (IOException ioe) {
            throw new BrowseException(ioe.getMessage(), ioe);
        }
        BoboIndexReader bReader = null;
        try {
            bReader = BoboIndexReader.getInstance(reader);
        }
        catch (IOException ioe) {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            throw new BrowseException(ioe.getMessage(), ioe);
        }
        return bReader;
    }

    public static BrowseService createBrowseService(Directory idxDir) throws BrowseException {
        BoboIndexReader bReader = BrowseServiceFactory.getBoboIndexReader(idxDir);
        DefaultBrowseServiceImpl bs = (DefaultBrowseServiceImpl)BrowseServiceFactory.createBrowseService(bReader);
        bs.setCloseReaderOnCleanup(true);
        return bs;
    }
}

