/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.oidc.lr62;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.gcube.oidc.rest.JWTToken;
import org.gcube.portal.oidc.lr62.IntraVMJWTCacheProxy;

public abstract class JWTCacheProxy {
    protected static final Log log = LogFactoryUtil.getLog(JWTCacheProxy.class);
    protected static JWTCacheProxy instance;

    public JWTCacheProxy() {
        instance = this;
        Timer timer = new Timer(true);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                instance.dumpOnLog();
            }
        }, 0L, 60000L);
    }

    public static synchronized JWTCacheProxy getInstance() {
        return instance != null ? instance : new IntraVMJWTCacheProxy();
    }

    public abstract void setOIDCToken(User var1, String var2, JWTToken var3);

    public abstract void setUMAToken(User var1, String var2, JWTToken var3);

    public abstract JWTToken getOIDCToken(User var1, String var2);

    public abstract JWTToken getUMAToken(User var1, String var2);

    public abstract void removeOIDCToken(User var1, String var2);

    public abstract void removeUMAToken(User var1, String var2);

    public abstract void removeAllOIDCTokens(User var1);

    public abstract void removeAllUMATokens(User var1);

    public abstract void clearOIDCTokens();

    public abstract void clearUMATokens();

    public abstract void clearAllTokens();

    public abstract Map<String, String> getMutexFor(User var1);

    public abstract void dumpOnLog();
}

