/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientRuntime {
    public static final String location_property = "GLOBUS_LOCATION";
    private static Logger log = LoggerFactory.getLogger(ClientRuntime.class);
    private static final String installation_name = "ghn-client-distro";
    private static final String archive_name = "ghn-client-distro.zip";

    public static synchronized void start() {
        String location = System.getProperty(location_property);
        if (location == null || !new File(location).exists()) {
            try {
                ClientRuntime.install();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            ClientRuntime.stop();
                        }
                        catch (Throwable t) {
                            log.warn("could not stop the client container and its services", t);
                        }
                    }
                });
            }
            catch (Throwable t) {
                throw new RuntimeException("could not start client runtime", t);
            }
        } else {
            log.info("client runtime is already started");
        }
    }

    public static synchronized void stop() {
        try {
            new File(ClientRuntime.tempDir(), archive_name).delete();
            new File(ClientRuntime.tempDir(), installation_name).delete();
            log.info("stopped client runtime");
        }
        catch (Throwable t) {
            throw new RuntimeException("could not stop client runtime", t);
        }
    }

    private static File tempDir() throws Exception {
        File random = File.createTempFile("temp", null);
        File dir = random.getParentFile();
        random.delete();
        return dir;
    }

    private static void copy(InputStream in, File file) throws Exception {
        byte[] data = new byte[2048];
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        int read = 0;
        while ((read = in.read(data)) != -1) {
            out.write(data, 0, read);
        }
        out.flush();
        out.close();
        in.close();
    }

    private static void install() throws Exception {
        InputStream embedded = ClientRuntime.class.getResourceAsStream("/ghn-client-distro.zip");
        File archive = new File(ClientRuntime.tempDir(), archive_name);
        ClientRuntime.copy(embedded, archive);
        ZipFile zipFile = new ZipFile(archive);
        Enumeration<? extends ZipEntry> zipFileEntries = zipFile.entries();
        while (zipFileEntries.hasMoreElements()) {
            ZipEntry entry = zipFileEntries.nextElement();
            File destFile = new File(ClientRuntime.tempDir(), entry.getName());
            if (entry.isDirectory()) {
                destFile.mkdirs();
                continue;
            }
            ClientRuntime.copy(zipFile.getInputStream(entry), destFile);
        }
        zipFile.close();
        String installation = new File(ClientRuntime.tempDir(), installation_name).getAbsolutePath();
        System.setProperty(location_property, installation);
        log.info("started client container in {}", (Object)installation);
    }
}

