/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.layerindependent.descriptions;

public class BasicReferenceDescription {
    public static final String PROPAGATE_DELETE_TARGET_IF_SINGLE_APPEARANCE = "delete-target-if-single-apperance";
    public static final String PROPAGATE_DELETE_SOURCE_IF_SINGLE_APPEARANCE = "delete-source-if-single-apperance";
    public static final String PROPAGATE_DELETE_TARGET = "delete-target-propagate";
    public static final String PROPAGATE_DELETE_SOURCE = "delete-source-propagate";
    public static final String PROPAGATE_NO_DELETE = "no-delete-propagate";
    public static final int UNDEFINED_POSITION = -1;
    public static final String ANY_ROLE = "*";
    public static final String RELATION_ROLE_MEMBERSHIP = "contentmanagement:is-member-of";
    public static final String RELATION_ROLE_CONTAINS = "contentmanagement:has-part";
    public static final String REFERENCE = "contentmanagement:reference";
    public static final String ROLE = "contentmanagement:reference-role";
    @Deprecated
    public static final String RELATION_LEGACY_ROLE_CONTAINED = "contentmanagement:is-part-of";
    public static final String RELATION_ROLE_REPRESENTATION = "contentmanagement:is-represented-by";
    public static final String RELATION_ROLE_METADATA = "contentmanagement:is-described-by";
    @Deprecated
    public static final String RELATION_ROLE_ANNOTATION = "contentmanagement:is-annotated-by";
    private String sourceoid;
    private String targetoid;
    private String propagationRule;
    private String role;
    private String secondaryRole;
    private int position;

    public int getPosition() {
        if (this.role == RELATION_LEGACY_ROLE_CONTAINED) {
            return -1;
        }
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public String getPropagationRule() {
        if (this.role == RELATION_LEGACY_ROLE_CONTAINED) {
            if (PROPAGATE_DELETE_SOURCE.equals(this.role)) {
                return PROPAGATE_DELETE_TARGET;
            }
            if (PROPAGATE_DELETE_TARGET.equals(this.role)) {
                return PROPAGATE_DELETE_SOURCE;
            }
            if (this.role.equals(PROPAGATE_DELETE_SOURCE_IF_SINGLE_APPEARANCE)) {
                return PROPAGATE_DELETE_TARGET_IF_SINGLE_APPEARANCE;
            }
            if (this.role.equals(PROPAGATE_DELETE_TARGET_IF_SINGLE_APPEARANCE)) {
                return PROPAGATE_DELETE_TARGET_IF_SINGLE_APPEARANCE;
            }
        }
        return this.propagationRule;
    }

    public void setPropagationRule(String propagationRule) {
        this.propagationRule = propagationRule;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = RELATION_LEGACY_ROLE_CONTAINED.equalsIgnoreCase(role) ? RELATION_LEGACY_ROLE_CONTAINED : role;
    }

    public BasicReferenceDescription(String sourceoid, String targetoid, String role, int position, String rule) {
        this(sourceoid, targetoid, role, null, position, rule);
    }

    public BasicReferenceDescription(String sourceoid, String targetoid, String role, String secondaryRole, int position, String rule) {
        this.position = position;
        this.propagationRule = rule;
        this.setRole(role);
        this.sourceoid = sourceoid;
        this.targetoid = targetoid;
        this.secondaryRole = secondaryRole;
    }

    public BasicReferenceDescription() {
        this.position = -1;
        this.sourceoid = null;
        this.targetoid = null;
    }

    public String getSourceOID() {
        return this.role == RELATION_LEGACY_ROLE_CONTAINED ? this.targetoid : this.sourceoid;
    }

    public void setSourceOID(String sourceoid) {
        this.sourceoid = sourceoid;
    }

    public String getTargetOID() {
        return this.role == RELATION_LEGACY_ROLE_CONTAINED ? this.sourceoid : this.targetoid;
    }

    public void setTargetOID(String targetoid) {
        this.targetoid = targetoid;
    }

    public String getSecondaryRole() {
        return this.secondaryRole;
    }

    public void setSecondaryRole(String secondaryRole) {
        this.secondaryRole = secondaryRole;
    }
}

