/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.md;

import java.security.MessageDigest;

public class MD4
extends MessageDigest
implements Cloneable {
    private static final int BLOCK_LENGTH = 64;
    private int[] context = new int[4];
    private long count;
    private byte[] buffer = new byte[64];
    private int[] X = new int[16];

    public Object clone() {
        return new MD4(this);
    }

    public void engineReset() {
        this.context[0] = 1732584193;
        this.context[1] = -271733879;
        this.context[2] = -1732584194;
        this.context[3] = 271733878;
        this.count = 0L;
        int n = 0;
        while (n < 64) {
            this.buffer[n] = 0;
            ++n;
        }
    }

    public void engineUpdate(byte by) {
        int n = (int)(this.count % 64L);
        ++this.count;
        this.buffer[n] = by;
        if (n == 63) {
            this.transform(this.buffer, 0);
        }
    }

    public void engineUpdate(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || (long)n + (long)n2 > (long)byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = (int)(this.count % 64L);
        this.count += (long)n2;
        int n4 = 64 - n3;
        int n5 = 0;
        if (n2 >= n4) {
            System.arraycopy(byArray, n, this.buffer, n3, n4);
            this.transform(this.buffer, 0);
            n5 = n4;
            while (n5 + 64 - 1 < n2) {
                this.transform(byArray, n + n5);
                n5 += 64;
            }
            n3 = 0;
        }
        if (n5 < n2) {
            System.arraycopy(byArray, n + n5, this.buffer, n3, n2 - n5);
        }
    }

    public byte[] engineDigest() {
        int n = (int)(this.count % 64L);
        int n2 = n < 56 ? 56 - n : 120 - n;
        byte[] byArray = new byte[n2 + 8];
        byArray[0] = -128;
        int n3 = 0;
        while (n3 < 8) {
            byArray[n2 + n3] = (byte)(this.count * 8L >>> 8 * n3);
            ++n3;
        }
        this.engineUpdate(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[16];
        int n4 = 0;
        while (n4 < 4) {
            int n5 = 0;
            while (n5 < 4) {
                byArray2[n4 * 4 + n5] = (byte)(this.context[n4] >>> 8 * n5);
                ++n5;
            }
            ++n4;
        }
        this.engineReset();
        return byArray2;
    }

    private void transform(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < 16) {
            this.X[n2] = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
            ++n2;
        }
        n2 = this.context[0];
        int n3 = this.context[1];
        int n4 = this.context[2];
        int n5 = this.context[3];
        n2 = this.FF(n2, n3, n4, n5, this.X[0], 3);
        n5 = this.FF(n5, n2, n3, n4, this.X[1], 7);
        n4 = this.FF(n4, n5, n2, n3, this.X[2], 11);
        n3 = this.FF(n3, n4, n5, n2, this.X[3], 19);
        n2 = this.FF(n2, n3, n4, n5, this.X[4], 3);
        n5 = this.FF(n5, n2, n3, n4, this.X[5], 7);
        n4 = this.FF(n4, n5, n2, n3, this.X[6], 11);
        n3 = this.FF(n3, n4, n5, n2, this.X[7], 19);
        n2 = this.FF(n2, n3, n4, n5, this.X[8], 3);
        n5 = this.FF(n5, n2, n3, n4, this.X[9], 7);
        n4 = this.FF(n4, n5, n2, n3, this.X[10], 11);
        n3 = this.FF(n3, n4, n5, n2, this.X[11], 19);
        n2 = this.FF(n2, n3, n4, n5, this.X[12], 3);
        n5 = this.FF(n5, n2, n3, n4, this.X[13], 7);
        n4 = this.FF(n4, n5, n2, n3, this.X[14], 11);
        n3 = this.FF(n3, n4, n5, n2, this.X[15], 19);
        n2 = this.GG(n2, n3, n4, n5, this.X[0], 3);
        n5 = this.GG(n5, n2, n3, n4, this.X[4], 5);
        n4 = this.GG(n4, n5, n2, n3, this.X[8], 9);
        n3 = this.GG(n3, n4, n5, n2, this.X[12], 13);
        n2 = this.GG(n2, n3, n4, n5, this.X[1], 3);
        n5 = this.GG(n5, n2, n3, n4, this.X[5], 5);
        n4 = this.GG(n4, n5, n2, n3, this.X[9], 9);
        n3 = this.GG(n3, n4, n5, n2, this.X[13], 13);
        n2 = this.GG(n2, n3, n4, n5, this.X[2], 3);
        n5 = this.GG(n5, n2, n3, n4, this.X[6], 5);
        n4 = this.GG(n4, n5, n2, n3, this.X[10], 9);
        n3 = this.GG(n3, n4, n5, n2, this.X[14], 13);
        n2 = this.GG(n2, n3, n4, n5, this.X[3], 3);
        n5 = this.GG(n5, n2, n3, n4, this.X[7], 5);
        n4 = this.GG(n4, n5, n2, n3, this.X[11], 9);
        n3 = this.GG(n3, n4, n5, n2, this.X[15], 13);
        n2 = this.HH(n2, n3, n4, n5, this.X[0], 3);
        n5 = this.HH(n5, n2, n3, n4, this.X[8], 9);
        n4 = this.HH(n4, n5, n2, n3, this.X[4], 11);
        n3 = this.HH(n3, n4, n5, n2, this.X[12], 15);
        n2 = this.HH(n2, n3, n4, n5, this.X[2], 3);
        n5 = this.HH(n5, n2, n3, n4, this.X[10], 9);
        n4 = this.HH(n4, n5, n2, n3, this.X[6], 11);
        n3 = this.HH(n3, n4, n5, n2, this.X[14], 15);
        n2 = this.HH(n2, n3, n4, n5, this.X[1], 3);
        n5 = this.HH(n5, n2, n3, n4, this.X[9], 9);
        n4 = this.HH(n4, n5, n2, n3, this.X[5], 11);
        n3 = this.HH(n3, n4, n5, n2, this.X[13], 15);
        n2 = this.HH(n2, n3, n4, n5, this.X[3], 3);
        n5 = this.HH(n5, n2, n3, n4, this.X[11], 9);
        n4 = this.HH(n4, n5, n2, n3, this.X[7], 11);
        n3 = this.HH(n3, n4, n5, n2, this.X[15], 15);
        this.context[0] = this.context[0] + n2;
        this.context[1] = this.context[1] + n3;
        this.context[2] = this.context[2] + n4;
        this.context[3] = this.context[3] + n5;
    }

    private int FF(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n + (n2 & n3 | ~n2 & n4) + n5;
        return n7 << n6 | n7 >>> 32 - n6;
    }

    private int GG(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n + (n2 & (n3 | n4) | n3 & n4) + n5 + 1518500249;
        return n7 << n6 | n7 >>> 32 - n6;
    }

    private int HH(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n + (n2 ^ n3 ^ n4) + n5 + 1859775393;
        return n7 << n6 | n7 >>> 32 - n6;
    }

    public MD4() {
        super("MD4");
        this.engineReset();
    }

    private MD4(MD4 mD4) {
        this();
        this.context = (int[])mD4.context.clone();
        this.buffer = (byte[])mD4.buffer.clone();
        this.count = mD4.count;
    }
}

