/*
 * Decompiled with CFR 0.152.
 */
package xjava.security;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import xjava.security.Cipher;
import xjava.security.IJCE;

public class CipherInputStream
extends FilterInputStream {
    private static final boolean DEBUG = true;
    private static int debuglevel = IJCE.getDebugLevel("CipherInputStream");
    private static PrintWriter err = IJCE.getDebugOutput();
    private Cipher cipher;
    private final byte[] preallocated1 = new byte[256];
    private final byte[] preallocated2 = new byte[256];
    private final byte[] tempByte = new byte[1];
    private byte[] outBuf;
    private int outPtr;
    private int buffered;
    private boolean isDPBC;

    private static void debug(String string) {
        err.println("CipherInputStream: " + string);
    }

    private static String dump(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        return byArray.toString();
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        byte[] byArray2;
        int n4;
        byte[] byArray3;
        if (debuglevel >= 5) {
            CipherInputStream.debug("read(<" + byArray + ">, " + n + ", " + n2 + ") ...");
        }
        if (this.cipher == null) {
            if (debuglevel >= 7) {
                CipherInputStream.debug("... stream closed");
            }
            return -1;
        }
        if (n2 <= 0) {
            return 0;
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("offset < 0");
        }
        int n5 = 0;
        if (this.buffered > 0) {
            n5 = this.buffered < n2 ? this.buffered : n2;
            System.arraycopy(this.outBuf, this.outPtr, byArray, n, n5);
            this.outPtr += n5;
            this.buffered -= n5;
            n += n5;
            n2 -= n5;
            if (debuglevel >= 7) {
                CipherInputStream.debug("  outBuf = <" + CipherInputStream.dump(this.outBuf) + ">, outPtr = " + this.outPtr + ", buffered = " + this.buffered + ", offset = " + n + ", length = " + n2);
            }
            if (this.buffered == 0) {
                this.outPtr = 0;
            }
            if (n2 == 0) {
                if (debuglevel >= 5) {
                    CipherInputStream.debug("... = " + n5);
                }
                return n5;
            }
        }
        int n6 = this.cipher.inBufferSize(n2);
        if (this.isDPBC) {
            ++n6;
        }
        byte[] byArray4 = byArray3 = n6 <= this.preallocated1.length ? this.preallocated1 : new byte[n6];
        if (debuglevel >= 7) {
            CipherInputStream.debug("  inLen = " + n6);
        }
        if ((n4 = this.readFully(byArray3, 0, n6)) < n6) {
            Cipher cipher = this.cipher;
            this.cipher = null;
            int n7 = cipher.outBufferSizeFinal(n4);
            byArray2 = n7 <= this.preallocated2.length ? this.preallocated2 : new byte[n7];
            n3 = cipher.crypt(byArray3, 0, n4, byArray2, 0);
        } else {
            int n8 = this.cipher.outBufferSize(n4);
            byArray2 = n8 <= this.preallocated2.length ? this.preallocated2 : new byte[n8];
            n3 = this.cipher.update(byArray3, 0, n4, byArray2, 0);
        }
        if (debuglevel >= 7) {
            CipherInputStream.debug("  temp = <" + CipherInputStream.dump(byArray2) + ">, n = " + n3);
        }
        if (n3 > n2) {
            this.buffered = n3 - n2;
            if (this.buffered > this.outBuf.length) {
                this.outBuf = new byte[this.buffered];
            }
            System.arraycopy(byArray2, n2, this.outBuf, 0, this.buffered);
            n3 = n2;
            if (debuglevel >= 7) {
                CipherInputStream.debug("  buffered = " + this.buffered + ", length = " + n2 + ", n = " + n3);
            }
        }
        System.arraycopy(byArray2, 0, byArray, n, n3);
        if ((n3 += n5) == 0 && this.cipher == null) {
            n3 = -1;
        }
        if (debuglevel >= 5) {
            CipherInputStream.debug("... = " + n3);
        }
        return n3;
    }

    private int readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = 0;
        do {
            n4 = super.read(byArray, n3 += n4, n2 - n3);
            if (debuglevel < 7) continue;
            CipherInputStream.debug("  n = " + n3 + ", k = " + n4);
        } while (n4 >= 0 && n3 < n2);
        return n3;
    }

    public synchronized int read() throws IOException {
        if (this.read(this.tempByte, 0, 1) < 1) {
            return -1;
        }
        return this.tempByte[0] & 0xFF;
    }

    public synchronized long skip(long l) throws IOException {
        int n = 100000;
        int n2 = l < 100000L ? (int)l : 100000;
        byte[] byArray = new byte[n2];
        long l2 = l;
        while (l2 > 0L) {
            if ((n2 = this.read(byArray, 0, n2)) < 0) {
                return l - l2;
            }
            int n3 = n2 = (l2 -= (long)n2) < 100000L ? (int)l2 : 100000;
        }
        return l;
    }

    public synchronized int available() throws IOException {
        if (this.cipher == null) {
            return 0;
        }
        return this.buffered + this.cipher.outBufferSize(super.available());
    }

    public synchronized void close() throws IOException {
        this.cipher = null;
        super.close();
    }

    public void mark(int n) {
    }

    public void reset() throws IOException {
        throw new IOException("CipherInputStream does not support mark/reset");
    }

    public boolean markSupported() {
        return false;
    }

    public CipherInputStream(InputStream inputStream, Cipher cipher) {
        super(inputStream);
        if (cipher == null) {
            throw new NullPointerException("cipher");
        }
        int n = cipher.getState();
        if (n != 1 && n != 2) {
            throw new IllegalStateException("cipher is uninitialized");
        }
        this.outBuf = new byte[cipher.getOutputBlockSize()];
        this.buffered = 0;
        this.outPtr = 0;
        this.isDPBC = cipher.isPaddingBlockCipher() && n == 2;
        this.cipher = cipher;
    }
}

