/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.contexts;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.axis.client.Stub;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.gcube.common.core.contexts.GCUBEContext;
import org.gcube.common.core.contexts.GCUBEPortTypeContext;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBERetryEquivalentFault;
import org.gcube.common.core.faults.GCUBERetrySameFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.security.GCUBEDefaultSecurityConfiguration;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.context.SecurityContextFactory;
import org.gcube.common.scope.api.ScopeProvider;
import org.globus.wsrf.impl.security.descriptor.GSISecureConvAuthMethod;
import org.globus.wsrf.impl.security.descriptor.GSITransportAuthMethod;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityDescriptor;
import org.globus.wsrf.jndi.NamingContext;
import org.globus.wsrf.tools.jndi.JNDIConfigRuleSet;

public class GCUBERemotePortTypeContext<PORTTYPE extends Remote>
extends GCUBEContext {
    public static final String CLASS_HEADER_NAME = "serviceClass";
    public static final String NAME_HEADER_NAME = "serviceName";
    public static final String SCOPE_HEADER_NAME = "scope";
    public static final String SCOPE_NS = "http://gcube-system.org/namespaces/scope";
    protected static String JNDI_STUBS_ROOT_CONTEXT = "java:comp/env//stubs/services/";
    protected static String JNDI_FILE_NAME = "deploy-jndi-config.xml";
    protected static String WSDD_FILE_NAME = "deploy-server.wsdd";
    protected static String BUILD_PROPERTIES_FILE_NAME = "build.properties";
    protected static String JNDI_NAME_BUILD_PROPERTY = "jndi.name";
    public static final String CALLER_HEADER_NAME = "caller";
    public static final String CALLER_NS = "http://gcube-system.org/namespaces/caller";
    protected static Map<Class<? extends Remote>, GCUBERemotePortTypeContext<?>> contexts = new HashMap();
    protected Class<? extends Remote> portTypeClass;
    protected GCUBEService service = GHNContext.getImplementation(GCUBEService.class);
    protected String serviceJNDIName;
    protected String portTypeJNDIName;
    protected WSDDService deploymentDescriptor;
    protected ServiceSecurityDescriptor securityDescriptor;
    private static final int CALL_TIMEOUT = 60000;

    private GCUBERemotePortTypeContext(PORTTYPE stub) throws Exception {
        this.portTypeClass = stub.getClass();
        try {
            InputStream profile = this.getResource("profile.xml");
            if (profile == null) {
                throw new Exception("profile.xml not found");
            }
            this.service.load(new InputStreamReader(profile));
            String epr = (String)((Stub)stub)._getProperty("javax.xml.rpc.service.endpoint.address");
            String prefix = GHNContext.getContext().getServiceEndpointPrefix();
            this.portTypeJNDIName = epr.substring(epr.lastIndexOf(prefix) + prefix.length());
            WSDDDocument doc = new WSDDDocument(XMLUtils.newDocument((InputStream)this.getResource(WSDD_FILE_NAME)));
            this.deploymentDescriptor = doc.getDeployment().getWSDDService(new QName(null, this.portTypeJNDIName));
            if (this.deploymentDescriptor == null) {
                throw new Exception("Service " + this.portTypeJNDIName + " not found");
            }
            this.securityDescriptor = this.loadServiceSecurityDescriptor();
        }
        catch (Exception e) {
            throw new Exception("Invalid stub distribution:", e);
        }
    }

    private ServiceSecurityDescriptor loadServiceSecurityDescriptor() throws Exception {
        this.logger.debug("Loading outgoing security descriptor");
        String securityDescriptorAbsoluteFileName = this.deploymentDescriptor.getParameter(GCUBEPortTypeContext.WSSD_WSDD_NAME);
        GCUBEDefaultSecurityConfiguration defaultSecurityConfiguration = SecurityContextFactory.getInstance().getSecurityContext().getDefaultServiceSecurityConfiguration();
        ServiceSecurityDescriptor response = null;
        if (defaultSecurityConfiguration != null && defaultSecurityConfiguration.isOutEnabled() && defaultSecurityConfiguration.isOutOverride() || defaultSecurityConfiguration != null && defaultSecurityConfiguration.isOutEnabled() && securityDescriptorAbsoluteFileName == null) {
            this.logger.debug("Ingoing override = " + defaultSecurityConfiguration.isOutOverride());
            this.logger.debug("sec desc file = " + securityDescriptorAbsoluteFileName);
            this.logger.debug("Loading default ingoing security descriptor");
            response = SecurityContextFactory.getInstance().getSecurityContext().getDefaultOutgoingMessagesSecurityDescriptor();
            this.logger.debug("Security descriptor = " + response);
        } else if (securityDescriptorAbsoluteFileName != null) {
            String line;
            this.logger.debug("loading from the file");
            String securityDescriptor = securityDescriptorAbsoluteFileName.substring(securityDescriptorAbsoluteFileName.lastIndexOf(File.separatorChar) + 1);
            InputStream stream = this.getResource(securityDescriptor);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            File securityDescriptorTempFile = File.createTempFile(this.portTypeJNDIName.replace("/", "."), "securityDescriptor");
            FileWriter writer = new FileWriter(securityDescriptorTempFile);
            while ((line = reader.readLine()) != null) {
                writer.write(line);
            }
            writer.close();
            reader.close();
            response = new ServiceSecurityDescriptor();
            response.parse(ServiceSecurityConfig.loadSecurityDescriptor((String)securityDescriptorTempFile.getAbsolutePath()).getDocumentElement());
            securityDescriptorTempFile.delete();
            this.logger.debug("security descriptor loaded");
        } else {
            this.logger.debug("No security descriptor for this port type");
        }
        return response;
    }

    public static <PORTTYPE extends Remote> PORTTYPE getProxy(PORTTYPE portTypeStub, GCUBEServiceContext context) throws Exception {
        return GCUBERemotePortTypeContext.getProxy(portTypeStub, 60000, context);
    }

    public static <PORTTYPE extends Remote> PORTTYPE getProxy(PORTTYPE portTypeStub, GCUBEServiceContext context, int callTimeout) throws Exception {
        return GCUBERemotePortTypeContext.getProxy(portTypeStub, callTimeout, context);
    }

    @Deprecated
    public static <PORTTYPE extends Remote> PORTTYPE getProxy(PORTTYPE portTypeStub, GCUBEScope scope, GCUBESecurityManager ... securityManager) throws Exception {
        ScopeProvider.instance.set(scope.toString());
        return GCUBERemotePortTypeContext.getProxy(portTypeStub);
    }

    @Deprecated
    public static <PORTTYPE extends Remote> PORTTYPE getProxy(PORTTYPE portTypeStub, GCUBEScope scope, int callTimeout, GCUBESecurityManager ... securityManager) throws Exception {
        ScopeProvider.instance.set(scope.toString());
        return GCUBERemotePortTypeContext.getProxy(portTypeStub, callTimeout, new GCUBEServiceContext[0]);
    }

    @Deprecated
    public static <PORTTYPE extends Remote> PORTTYPE getProxy(PORTTYPE portTypeStub, GCUBEScopeManager scopeManager, GCUBESecurityManager ... securityManager) throws Exception {
        return GCUBERemotePortTypeContext.getProxy(portTypeStub);
    }

    @Deprecated
    public static <PORTTYPE extends Remote> PORTTYPE getProxy(PORTTYPE portTypeStub, GCUBEScopeManager scopeManager, int callTimeout, GCUBESecurityManager ... securityManager) throws Exception {
        return GCUBERemotePortTypeContext.getProxy(portTypeStub, callTimeout, new GCUBEServiceContext[0]);
    }

    public static <PORTTYPE extends Remote> PORTTYPE getProxy(PORTTYPE portTypeStub) throws Exception {
        return GCUBERemotePortTypeContext.getProxy(portTypeStub, 60000, new GCUBEServiceContext[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <PORTTYPE extends Remote> PORTTYPE getProxy(PORTTYPE portTypeStub, int callTimeout, GCUBEServiceContext ... context) throws Exception {
        GCUBEMethodInterceptor gCUBEMethodInterceptor;
        GCUBERemotePortTypeContext<Object> stubContext;
        Map<Class<? extends Remote>, GCUBERemotePortTypeContext<?>> map = contexts;
        synchronized (map) {
            stubContext = contexts.get(portTypeStub.getClass());
            if (stubContext == null) {
                stubContext = new GCUBERemotePortTypeContext<PORTTYPE>(portTypeStub);
                contexts.put(portTypeStub.getClass(), stubContext);
            }
            ((Stub)portTypeStub).setTimeout(callTimeout);
        }
        if (context != null && context.length != 0) {
            GCUBERemotePortTypeContext<Object> gCUBERemotePortTypeContext = stubContext;
            gCUBERemotePortTypeContext.getClass();
            gCUBEMethodInterceptor = new GCUBEMethodInterceptor(gCUBERemotePortTypeContext, portTypeStub, context[0]);
        } else {
            GCUBERemotePortTypeContext<Object> gCUBERemotePortTypeContext = stubContext;
            gCUBERemotePortTypeContext.getClass();
            gCUBEMethodInterceptor = new GCUBEMethodInterceptor(gCUBERemotePortTypeContext, portTypeStub);
        }
        GCUBEMethodInterceptor interceptor = gCUBEMethodInterceptor;
        return (PORTTYPE)((Remote)Enhancer.create(portTypeStub.getClass(), (Callback)interceptor));
    }

    @Override
    public InputStream getResource(String resourceName) {
        String className = this.portTypeClass.getSimpleName();
        String classFileName = className + ".class";
        String classFilePath = this.portTypeClass.getPackage().toString().replace('.', '/') + "/" + className;
        String pathToClass = this.portTypeClass.getResource(classFileName).toString();
        String url = pathToClass.toString().substring(0, pathToClass.length() + 2 - ("/" + classFilePath).length()) + "/META-INF/" + resourceName;
        try {
            return new URL(url).openStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getServiceProperty(String prop) {
        try {
            return this.getJNDIContext().lookup(JNDI_STUBS_ROOT_CONTEXT + this.serviceJNDIName + "/" + prop);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Object getProperty(String prop, boolean ... required) throws RuntimeException {
        return super.getProperty(JNDI_STUBS_ROOT_CONTEXT + "/" + this.portTypeJNDIName + "/" + prop, required);
    }

    public GCUBEService getService() {
        return this.service;
    }

    public WSDDService getDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public ServiceSecurityDescriptor getSecurityDescriptor() {
        return this.securityDescriptor;
    }

    protected void parseJNDIConfig(InputStream config) throws Exception {
        Context stubContext = null;
        try {
            stubContext = (Context)this.getJNDIContext().lookup(JNDI_STUBS_ROOT_CONTEXT);
        }
        catch (NamingException e) {
            stubContext = ((Context)this.getJNDIContext().lookup("java:comp/env/")).createSubcontext("stubs");
        }
        Digester digester = new Digester();
        digester.setNamespaceAware(true);
        digester.setValidating(false);
        digester.addRuleSet((RuleSet)new JNDIConfigRuleSet("jndiConfig/"));
        digester.push((Object)new NamingContext(stubContext, null));
        digester.parse(config);
        digester.clear();
    }

    static class GCUBEMethodInterceptor
    implements MethodInterceptor {
        final GCUBESecurityManager securityManager;
        final PORTTYPE portType;
        final String identity;
        final /* synthetic */ GCUBERemotePortTypeContext this$0;

        GCUBEMethodInterceptor(PORTTYPE portType, GCUBEServiceContext context) {
            this.this$0 = var1_1;
            this.portType = portType;
            this.identity = context.getServiceClass().toUpperCase() + ":" + context.getName().toUpperCase() + ":" + GHNContext.getContext().getHostnameAndPort();
            this.securityManager = context;
        }

        GCUBEMethodInterceptor(PORTTYPE portType) {
            this.this$0 = var1_1;
            this.identity = GHNContext.getContext().getStatus() == GHNContext.Status.DEPLOYED ? GHNContext.getContext().getHostname() : GHNContext.getContext().getHostnameAndPort();
            this.portType = portType;
            this.securityManager = SecurityContextFactory.getInstance().getSecurityContext().getCredentialsAdder();
        }

        public Object intercept(Object proxy, Method method, Object[] input, MethodProxy methodProxy) throws Throwable {
            if (method.getName().equals("finalize") && method.getDeclaringClass() == Object.class) {
                return null;
            }
            Stub stub = (Stub)this.portType;
            stub.clearHeaders();
            stub.setHeader(GCUBERemotePortTypeContext.SCOPE_NS, GCUBERemotePortTypeContext.CLASS_HEADER_NAME, (Object)this.this$0.getService().getServiceClass());
            stub.setHeader(GCUBERemotePortTypeContext.SCOPE_NS, GCUBERemotePortTypeContext.NAME_HEADER_NAME, (Object)this.this$0.getService().getServiceName());
            stub.setHeader(GCUBERemotePortTypeContext.SCOPE_NS, GCUBERemotePortTypeContext.SCOPE_HEADER_NAME, (Object)ScopeProvider.instance.get());
            ((Stub)this.portType).setHeader(GCUBERemotePortTypeContext.CALLER_NS, GCUBERemotePortTypeContext.CALLER_HEADER_NAME, (Object)this.identity);
            if (this.securityManager != null && this.securityManager.isSecurityEnabled() && this.this$0.getSecurityDescriptor() != null) {
                GCUBESecurityManager.AuthMode authMode = GCUBESecurityManager.AuthMode.NONE;
                GCUBESecurityManager.AuthMethod authMethod = GCUBESecurityManager.AuthMethod.NONE;
                List authMethods = this.this$0.getSecurityDescriptor().getAuthMethods(new QName(null, method.getName()));
                if (authMethods == null) {
                    authMethods = this.this$0.getSecurityDescriptor().getDefaultAuthMethods();
                }
                if (authMethods != null) {
                    for (Object authMethodObject : authMethods) {
                        int protType = -1;
                        if (authMethodObject instanceof GSISecureConvAuthMethod) {
                            this.this$0.logger.debug("Gsi conversation");
                            authMethod = GCUBESecurityManager.AuthMethod.GSI_CONV;
                            protType = ((GSISecureConvAuthMethod)authMethodObject).getProtectionType();
                        } else if (authMethodObject instanceof GSITransportAuthMethod) {
                            this.this$0.logger.debug("Gsi transport");
                            authMethod = GCUBESecurityManager.AuthMethod.GSI_TRANS;
                            protType = ((GSITransportAuthMethod)authMethodObject).getProtectionType();
                        }
                        switch (protType) {
                            case 0: {
                                authMode = GCUBESecurityManager.AuthMode.BOTH;
                                break;
                            }
                            case 1: {
                                authMode = GCUBESecurityManager.AuthMode.INTEGRITY;
                                break;
                            }
                            case 2: {
                                authMode = GCUBESecurityManager.AuthMode.PRIVACY;
                            }
                        }
                    }
                }
                GCUBESecurityManager.DelegationMode delegationMode = GCUBESecurityManager.DelegationMode.NONE;
                if (authMethod == GCUBESecurityManager.AuthMethod.GSI_CONV) {
                    this.this$0.logger.debug("GSI conversation set: setting delegation...");
                    int runAsType = this.this$0.getSecurityDescriptor().getRunAsType(new QName(null, method.getName()));
                    if (runAsType == -1) {
                        runAsType = this.this$0.getSecurityDescriptor().getDefaultRunAsType();
                    }
                    if (runAsType == 1) {
                        delegationMode = GCUBESecurityManager.DelegationMode.FULL;
                    }
                    this.this$0.logger.debug("delegation set as " + (Object)((Object)delegationMode));
                }
                this.securityManager.setAuthMethod(authMethod);
                this.securityManager.setSecurity((Remote)this.portType, authMode, delegationMode);
            }
            try {
                return methodProxy.invoke(this.portType, input);
            }
            catch (GCUBEFault e) {
                if (e.getClass() != GCUBEFault.class) {
                    throw e;
                }
                String type = e.getFaultType();
                if (type == null) {
                    this.this$0.logger.warn("Fault is untyped could not narrow it");
                    throw e;
                }
                GCUBEFault f = e;
                if (type.equals("RETRY_EQUIVALENT")) {
                    f = new GCUBERetryEquivalentFault((Exception)((Object)e), new String[0]);
                }
                if (type.equals("RETRY_SAME")) {
                    f = new GCUBERetrySameFault((Exception)((Object)e), new String[0]);
                }
                if (type.equals("UNRECOVERABLE")) {
                    f = new GCUBEUnrecoverableFault((Exception)((Object)e), new String[0]);
                }
                f.setFaultType(e.getFaultType());
                f.setFaultMessage(e.getFaultMessage());
                f.setFaultDetail(e.getFaultDetails());
                throw f;
            }
        }
    }
}

