/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.utils.encryption;

import java.security.Key;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.XMLCipher;
import org.gcube.common.utils.encryption.Encrypter;
import org.gcube.common.utils.encryption.SymmetricKey;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLDocumentEncrypter
implements Encrypter<Element> {
    private static final String docAlgorithmURI = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    private boolean encryptElementNames = false;
    private static XMLDocumentEncrypter singleton;
    static Log log;

    XMLDocumentEncrypter() {
    }

    public static XMLDocumentEncrypter getEncrypter() {
        if (singleton == null) {
            singleton = new XMLDocumentEncrypter();
        }
        return singleton;
    }

    @Override
    public Element decrypt(Element encryptedDataElement, String ... keyname) throws Exception {
        NodeList encryptedDataNodes = encryptedDataElement.getChildNodes();
        if (encryptedDataNodes.getLength() == 0) {
            System.out.println("Nothing to decrypt");
            return encryptedDataElement;
        }
        System.out.println("To decrypt " + encryptedDataNodes.getLength());
        Key ekey = SymmetricKey.getKey(keyname);
        XMLCipher xmlCipher = XMLCipher.getInstance((String)docAlgorithmURI);
        xmlCipher.init(2, ekey);
        for (int i = 0; i < encryptedDataNodes.getLength(); ++i) {
            xmlCipher.doFinal(encryptedDataElement.getOwnerDocument(), (Element)encryptedDataNodes.item(i));
        }
        return encryptedDataElement;
    }

    @Override
    public Element encrypt(Element element, String ... keyname) throws Exception {
        Key ekey = SymmetricKey.getKey(keyname);
        XMLCipher xmlCipher = XMLCipher.getInstance((String)docAlgorithmURI);
        xmlCipher.init(1, ekey);
        xmlCipher.doFinal(element.getOwnerDocument(), element, !this.encryptElementNames);
        return element;
    }

    public void setEncryptElementNames(boolean encryptElementNames) {
        this.encryptElementNames = encryptElementNames;
    }

    static {
        log = LogFactory.getLog((String)XMLDocumentEncrypter.class.getName());
        Init.init();
    }
}

