/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.descriptor;

import javax.xml.namespace.QName;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.descriptor.SecurityDescriptorException;
import org.globus.wsrf.impl.security.descriptor.util.ElementHandler;
import org.globus.wsrf.impl.security.descriptor.util.ElementParser;
import org.globus.wsrf.impl.security.descriptor.util.ElementParserException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProtectionLevelParser
implements ElementHandler {
    private static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.descriptor.errors");
    public static final QName QNAME = new QName("http://www.globus.org", "protection-level");
    private boolean privacy = false;
    private boolean integrity = false;

    public void parse(Element elem) throws ElementParserException {
        ElementParser.checkElement(elem, QNAME);
        for (Node currentChild = elem.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (currentChild.getNodeType() != 1) continue;
            String name = currentChild.getLocalName();
            if (name.equalsIgnoreCase("none")) {
                throw new SecurityDescriptorException(i18n.getMessage("unsupportedProtLevel", (Object)name));
            }
            if (name.equalsIgnoreCase("integrity")) {
                this.integrity = true;
                continue;
            }
            if (name.equalsIgnoreCase("privacy")) {
                this.privacy = true;
                continue;
            }
            throw new SecurityDescriptorException(i18n.getMessage("badProtLevel", (Object)name));
        }
    }

    public boolean isIntegrity() {
        return this.integrity;
    }

    public boolean isPrivacy() {
        return this.privacy;
    }
}

