/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.util;

import java.util.LinkedList;
import java.util.List;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.StorageHint;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSInformationObjectResponse;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSInformationObjectTreeResponse;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSOIDResponse;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSRawContentLocationConfig;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSResponseConfig;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSTreeWalkRule;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.InformationObjectResponse;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.InformationObjectTreeResponse;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.OIDResponse;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.SMSResponseConfig;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.TreeWalkRule;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.util.RawContentLocationConverter;

public class ObjectToWSResponseConfigConverter {
    public static WSResponseConfig convertToWsResponseConfig(SMSResponseConfig responseConfig) {
        WSResponseConfig wsResponseConfig = new WSResponseConfig();
        switch (responseConfig.getResponseType()) {
            case OID: {
                wsResponseConfig.setOidResponse(ObjectToWSResponseConfigConverter.convertToWsOIdResponse((OIDResponse)responseConfig));
                break;
            }
            case INFORMATION_OBJECT: {
                wsResponseConfig.setInformationObjectResponse(ObjectToWSResponseConfigConverter.convertToInformationObjectResponse((InformationObjectResponse)responseConfig));
                break;
            }
            case INFORMATION_OBJECT_TREE: {
                wsResponseConfig.setInformationObjectTreeResponse(ObjectToWSResponseConfigConverter.convertToInformationObjectTreeResponse((InformationObjectTreeResponse)responseConfig));
            }
        }
        return wsResponseConfig;
    }

    protected static WSInformationObjectResponse convertToInformationObjectResponse(InformationObjectResponse informationObjectResponse) {
        List<StorageHint> hints = informationObjectResponse.getHints();
        StorageHint[] sHints = hints.toArray(new StorageHint[hints.size()]);
        WSRawContentLocationConfig locationConfig = RawContentLocationConverter.convertToWSRawContentLocationConfig(informationObjectResponse.getLocation());
        return new WSInformationObjectResponse(locationConfig, sHints);
    }

    protected static WSOIDResponse convertToWsOIdResponse(OIDResponse oidResponse) {
        return new WSOIDResponse();
    }

    public static WSInformationObjectTreeResponse convertToInformationObjectTreeResponse(InformationObjectTreeResponse informationObjectTreeResponse) {
        List<WSTreeWalkRule> wsRules = ObjectToWSResponseConfigConverter.convertToWalkRules(informationObjectTreeResponse.getWalkRules());
        List<StorageHint> hints = informationObjectTreeResponse.getHints();
        StorageHint[] sHints = hints.toArray(new StorageHint[hints.size()]);
        WSRawContentLocationConfig locationConfig = RawContentLocationConverter.convertToWSRawContentLocationConfig(informationObjectTreeResponse.getContentLocation());
        return new WSInformationObjectTreeResponse(locationConfig, informationObjectTreeResponse.getHops(), sHints, wsRules.toArray(new WSTreeWalkRule[wsRules.size()]));
    }

    protected static List<WSTreeWalkRule> convertToWalkRules(List<TreeWalkRule> rules) {
        LinkedList<WSTreeWalkRule> wsRules = new LinkedList<WSTreeWalkRule>();
        for (TreeWalkRule rule : rules) {
            wsRules.add(ObjectToWSResponseConfigConverter.convertToWalkRule(rule));
        }
        return wsRules;
    }

    protected static WSTreeWalkRule convertToWalkRule(TreeWalkRule rule) {
        return new WSTreeWalkRule(rule.getRole(), rule.getSecondaryRole());
    }
}

