/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.List;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicStorageHints;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.FileTransferParameters;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.GCUBERetrySameIOFault;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.GCUBEUnrecoverableValueNotValidFault;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.InfoObjectTree;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.NameAndType;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.PropertyDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.SMSPortType;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.SMSPortType1PortType;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.StorageHint;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.StorageManagementCall;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.protocol.SMSInputStream;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.InformationObjectTreeResponse;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.TreeWalkRule;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.service.SMSPortType1ServiceAddressingLocator;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.service.SMSServiceAddressingLocator;

public class SMSContentUtil {
    private static final int DEFAULT_TIMEOUT_MS = 600000;
    protected static final int CHUNK_SIZE = 0x100000;
    protected static final StorageHint[] APPEND_HINTS = new StorageHint[]{new StorageHint("append-content", BasicStorageHints.HINT_VALUE_TRUE)};
    protected static Logger logger = Logger.getLogger(SMSContentUtil.class);

    public static String uploadContent(GCUBEScope scope, InputStream is, GCUBESecurityManager ... securityManagers) throws Exception {
        logger.trace((Object)"finding SMS pt");
        GCUBESecurityManager securityManager = null;
        if (securityManagers != null && securityManagers.length > 0) {
            securityManager = securityManagers[0];
        }
        SMSPortType1PortType pt = SMSContentUtil.getStorageManagementPortType1(scope, securityManager);
        logger.trace((Object)"creating the IO");
        String oid = SMSContentUtil.createIO(pt);
        logger.trace((Object)("oid: " + oid));
        logger.trace((Object)"uploading content");
        SMSContentUtil.uploadStream(pt, is, oid);
        logger.trace((Object)"upload complete");
        SMSPortType pt2 = SMSContentUtil.getStorageManagementPortType(scope, securityManager);
        StorageManagementCall sm = new StorageManagementCall(pt2);
        logger.trace((Object)"retrieving content url");
        InfoObjectTree tree = sm.retrieveTree(oid, InformationObjectTreeResponse.walkedInformationObjectTree(Collections.<TreeWalkRule>emptyList()));
        logger.trace((Object)"IO retrieved");
        return SMSContentUtil.getUrl(tree.getProperties());
    }

    public static InputStream getContent(GCUBEScope scope, String oid, GCUBESecurityManager ... securityManagers) throws Exception {
        GCUBESecurityManager securityManager = null;
        if (securityManagers != null && securityManagers.length > 0) {
            securityManager = securityManagers[0];
        }
        SMSPortType1PortType sms = SMSContentUtil.getStorageManagementPortType1(scope, securityManager);
        return new BufferedInputStream(new SMSInputStream(sms, oid));
    }

    protected static String getUrl(PropertyDescription[] properties) {
        for (PropertyDescription property : properties) {
            if (!property.getName().equals("contentmanagement:ContentUrl")) continue;
            return property.getValue();
        }
        return null;
    }

    protected static String createIO(SMSPortType1PortType pt) throws GCUBERetrySameIOFault, GCUBEUnrecoverableValueNotValidFault, RemoteException {
        NameAndType nameAndType = new NameAndType(new StorageHint[0], "CONTENT", "CONTENT");
        return pt.createInfoObject(nameAndType);
    }

    protected static void uploadStream(SMSPortType1PortType pt, InputStream is, String oid) throws IOException {
        while (!SMSContentUtil.uploadChunk(pt, is, oid)) {
        }
        is.close();
    }

    protected static boolean uploadChunk(SMSPortType1PortType pt, InputStream is, String oid) throws IOException {
        byte[] buffer = new byte[0x100000];
        int read = is.read(buffer, 0, buffer.length);
        if (read < 0) {
            return true;
        }
        boolean last = false;
        if (read < buffer.length) {
            byte[] tmp = new byte[read];
            System.arraycopy(buffer, 0, tmp, 0, read);
            buffer = tmp;
            last = true;
        }
        FileTransferParameters fileTransferParameters = new FileTransferParameters(null, oid, buffer, APPEND_HINTS);
        pt.updateRawContent(fileTransferParameters);
        return last;
    }

    public static SMSPortType1PortType getStorageManagementPortType1(GCUBEScope scope, GCUBESecurityManager securityManager) throws Exception {
        EndpointReferenceType epr = SMSContentUtil.getServicePortTypeEndpoint(scope, "ContentManagement", "StorageManagementService", "gcube/contentmanagement/storagelayer/storagemanagementservice/porttype1");
        SMSPortType1ServiceAddressingLocator sl = new SMSPortType1ServiceAddressingLocator();
        SMSPortType1PortType pt = sl.getSMSPortType1PortTypePort(epr);
        return (SMSPortType1PortType)GCUBERemotePortTypeContext.getProxy((Remote)pt, (GCUBEScope)scope, (int)600000, (GCUBESecurityManager[])new GCUBESecurityManager[]{securityManager});
    }

    protected static SMSPortType getStorageManagementPortType(GCUBEScope scope, GCUBESecurityManager securityManager) throws Exception {
        EndpointReferenceType epr = SMSContentUtil.getServicePortTypeEndpoint(scope, "ContentManagement", "StorageManagementService", "gcube/contentmanagement/storagelayer/storagemanagementservice/porttype");
        SMSServiceAddressingLocator sl = new SMSServiceAddressingLocator();
        SMSPortType pt = sl.getSMSPortTypePort(epr);
        return (SMSPortType)GCUBERemotePortTypeContext.getProxy((Remote)pt, (GCUBEScope)scope, (int)600000, (GCUBESecurityManager[])new GCUBESecurityManager[]{securityManager});
    }

    protected static EndpointReferenceType getServicePortTypeEndpoint(GCUBEScope scope, String serviceClass, String serviceName, String portTypeFullName) throws Exception {
        logger.trace((Object)"The start scopes of this GHN are:");
        for (GCUBEScope s : GHNContext.getContext().getStartScopes()) {
            logger.trace((Object)s);
        }
        logger.trace((Object)("The scope of the call to the IS for discovering service instances is: " + scope));
        logger.trace((Object)("serviceClass: " + serviceClass));
        logger.trace((Object)("serviceName: " + serviceName));
        logger.trace((Object)("portTypeFullName: " + portTypeFullName));
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBERIQuery query = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceClass", serviceClass), new AtomicCondition("//ServiceName", serviceName)});
        List RIs = client.execute((ISQuery)query, scope);
        if (RIs.size() == 0) {
            throw new RuntimeException("No services found");
        }
        logger.trace((Object)"found:");
        for (GCUBERunningInstance ri : RIs) {
            logger.trace((Object)("RI: " + ri.getID() + " GHN: " + ri.getGHNID()));
            logger.trace((Object)ri.getAccessPoint().getEndpoint(portTypeFullName));
        }
        EndpointReferenceType epr = ((GCUBERunningInstance)RIs.get(0)).getAccessPoint().getEndpoint(portTypeFullName);
        logger.trace((Object)("using:" + epr));
        return epr;
    }

    static {
        logger.setLevel(Level.ALL);
    }
}

