/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.contexts;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.registry.LocateRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.io.FileSystemUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.jmx.HierarchyDynamicMBean;
import org.apache.log4j.spi.LoggerRepository;
import org.gcube.common.core.contexts.GCUBEContext;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNClientContext;
import org.gcube.common.core.contexts.LocalInstanceContext;
import org.gcube.common.core.contexts.ghn.Builder;
import org.gcube.common.core.contexts.ghn.CredentialConsumer;
import org.gcube.common.core.contexts.ghn.CredentialRequestConsumer;
import org.gcube.common.core.contexts.ghn.Events;
import org.gcube.common.core.contexts.ghn.GHNConsumer;
import org.gcube.common.core.contexts.ghn.Scheduler;
import org.gcube.common.core.contexts.service.Consumer;
import org.gcube.common.core.instrumentation.GHN;
import org.gcube.common.core.monitoring.LocalMonitor;
import org.gcube.common.core.resources.GCUBEHostingNode;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeNotSupportedException;
import org.gcube.common.core.security.context.SecurityContextFactory;
import org.gcube.common.core.security.context.impl.DefaultGHNServerSecurityContext;
import org.gcube.common.core.utils.events.GCUBEProducer;
import org.gcube.common.core.utils.handlers.GCUBEScheduledHandler;
import org.gcube.common.core.utils.proxies.AccessControlProxyContext;
import org.gcube.common.core.utils.proxies.GCUBEProxyFactory;
import org.gcube.common.core.utils.proxies.ReadOnlyProxyContext;
import org.gcube.common.handlers.GCUBEURLStreamHandlerFactory;
import org.globus.wsrf.config.ContainerConfig;
import org.globus.wsrf.container.ServiceContainer;
import org.globus.wsrf.container.ServiceContainerCollection;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.jndi.NamingContext;
import org.globus.wsrf.tools.jndi.JNDIConfigRuleSet;
import org.ietf.jgss.GSSCredential;

public class GHNContext
extends GCUBEContext {
    public static final String GCF_VERSION = "1.6.1";
    public static final String CUSTOMLABELS_JNDI_NAME = "labels";
    public static final String COORDINATES_JNDI_NAME = "coordinates";
    public static final String COUNTRY_JNDI_NAME = "country";
    public static final String LOCATION_JNDI_NAME = "location";
    public static final String SECURITY_JNDI_NAME = "securityenabled";
    public static final String OVERRIDE_SERVICE_SECURITY = "overrideServiceSecurity";
    public static final String STARTSCOPES_JNDI_NAME = "startScopes";
    public static final String ALLOWEDSCOPES_JNDI_NAME = "allowedScopes";
    public static final String INFRASTRUCTURE_NAME = "infrastructure";
    public static final String MODE_JNDI_NAME = "mode";
    public static final String PUBLISHED_HOST_NAME = "publishedHost";
    public static final String PUBLISHED_PORT_NAME = "publishedPort";
    public static final String GHN_TYPE = "GHNtype";
    public static final String OPEN_PORTS = "portRange";
    public static final String CONTAINER_STATUS_JNDI_NAME = "java:comp/env//status";
    public static final String CONFIGDIR_NAME = "config";
    public static final String PROFILE_FILE_NAME = "GHNProfile.xml";
    public static final String IMPLEMENTATIONS_RESOURCE = "implementation.properties";
    public static final String GHN_JNDI_RESOURCE = "GHNConfig.xml";
    public static final String GHN_CLIENT_JNDI_RESOURCE = "GHNConfig.client.xml";
    public static final short GHN_UPDATE_ATTEMPTS = 3;
    public static final String UPDATEINTERVAL_JNDI_NAME = "updateInterval";
    public static final long DEFAULT_UPDATE_INTERVAL = 300L;
    public static final String TRUSTEDGHNINTERVAL_JNDI_NAME = "trustedGHNSynchInterval";
    public static final long DEFAULT_TRUSTEDGHNINTERVAL = 600L;
    public static final int SHUTDOWN_DELAY = 10000;
    private static final String STORAGE_ROOT_PROPERTY = "storage.root";
    public static final String STORAGE_ROOT = System.getProperty("user.home") + File.separatorChar + ".gcore" + File.separatorChar + "persisted" + File.separatorChar + ContainerConfig.getContainerID();
    public static final String MBEANS_PREFIX = "org.gcube";
    public static final int DEFAULT_TEST_INTERVAL = 1800;
    public static final String TESTINTERVAL_JNDI_NAME = "testInterval";
    public static final String MSGBROKER = "MessageBroker";
    public static final String JNDI_SERVICES_BASE_NAME = "java:comp/env//services/";
    protected static Properties implementations = new Properties();
    protected static GHNContext singleton = new GHNContext();
    private static GHNContext singletonproxy;
    private static ServiceContainer container;
    private static GCUBEProducer<Events.GHNTopic, Object> lifetimeProducer;
    private static GCUBEProducer<Events.SecurityTopic, Object> securityProducer;
    private static Mode mode;
    private static Map<String, GCUBEServiceContext> services;
    protected static GCUBEHostingNode node;
    private static Status status;
    private static String statusMessage;
    private static GCUBEScope[] startScopes;
    private static GCUBEScope[] allowedScopes;
    private static Scheduler updatescheduler;
    private static GHN mbean;
    private Consumer RIConsumer = new Consumer(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected synchronized void onRIFailed(GCUBEServiceContext.RILifetimeEvent e) {
            GHNContext.this.logger.trace("blocking calls for service " + ((GCUBEServiceContext)e.getPayload()).getName());
            Status status = status;
            synchronized (status) {
                if (GHNContext.this.getStatus() == Status.CERTIFIED) {
                    GHNContext.this.setStatus(Status.READY, new String[0]);
                }
            }
        }
    };

    protected GHNContext() {
    }

    public static synchronized GHNContext getContext() {
        return singletonproxy;
    }

    protected void initialise() throws Exception {
        this.setStatus(Status.STARTED, new String[0]);
        this.configureGHN(this.getFile(GHN_JNDI_RESOURCE, new boolean[0]));
        this.configureGHNResource();
        this.initializeSecurity();
        new Thread("managementInitialiser"){

            @Override
            public void run() {
                GHNContext.this.initialiseManagement();
            }
        }.start();
        new Thread("monitoringInitialiser"){

            @Override
            public void run() {
                GHNContext.this.initialiseMonitoring();
            }
        }.start();
        new Thread("containerMonitor"){

            @Override
            public void run() {
                GHNContext.this.monitorContainer();
            }
        }.start();
        new Thread("certificationMonitor"){

            @Override
            public void run() {
                GHNContext.this.certify();
            }
        }.start();
        this.setStatus(Status.UPDATED, new String[0]);
    }

    private void initializeSecurity() {
        SecurityContextFactory.getInstance().setSecurityContext(new DefaultGHNServerSecurityContext());
    }

    public boolean isClientMode() {
        try {
            this.getJNDIContext().lookup(CONTAINER_STATUS_JNDI_NAME);
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    protected void configureGHN(File file) throws Exception {
        this.logger.trace("parsing gHN configuration in " + file.getName());
        Digester digester = new Digester();
        digester.setNamespaceAware(true);
        digester.setValidating(false);
        digester.addRuleSet((RuleSet)new JNDIConfigRuleSet("jndiConfig/"));
        digester.push((Object)new NamingContext(this.getJNDIContext(), null));
        digester.parse((InputStream)new FileInputStream(file));
        digester.clear();
        String infrastructure = (String)this.getProperty(INFRASTRUCTURE_NAME, true);
        if (this.isSecurityEnabled() && !GHNContext.getContext().isClientMode()) {
            String[] configAllowedScopes = ((String)this.getProperty(ALLOWEDSCOPES_JNDI_NAME, false)).split(",");
            allowedScopes = new GCUBEScope[configAllowedScopes.length + 1];
            GHNContext.allowedScopes[0] = GCUBEScope.getScope("/" + infrastructure);
            for (int idx = 0; idx < configAllowedScopes.length; ++idx) {
                GHNContext.allowedScopes[idx + 1] = GCUBEScope.getScope("/" + infrastructure + "/" + configAllowedScopes[idx].trim());
            }
            startScopes = new GCUBEScope[]{GCUBEScope.getScope("/" + infrastructure)};
        } else {
            String[] configScopes = ((String)this.getProperty(STARTSCOPES_JNDI_NAME, true)).split(",");
            startScopes = new GCUBEScope[configScopes.length];
            for (int idx = 0; idx < configScopes.length; ++idx) {
                GHNContext.startScopes[idx] = GCUBEScope.getScope("/" + infrastructure + "/" + configScopes[idx].trim());
            }
            allowedScopes = new GCUBEScope[0];
        }
        implementations.load(new FileInputStream(this.getFile(IMPLEMENTATIONS_RESOURCE, new boolean[0])));
        this.logger.trace("installing custom URLStreamHandlerFactory");
        try {
            URL.setURLStreamHandlerFactory(new GCUBEURLStreamHandlerFactory());
        }
        catch (Error e) {
            this.logger.error("could not install custom URLStreamHandlerFactory", e);
        }
    }

    protected void configureGHNResource() throws Exception {
        Long interval;
        block6: {
            node = GHNContext.getImplementation(GCUBEHostingNode.class);
            node.setLogger(this.logger);
            File profile = this.getFile(PROFILE_FILE_NAME, new boolean[0]);
            try {
                try {
                    this.loadGHNResource(profile);
                }
                catch (Exception e) {
                    profile.delete();
                    this.loadGHNResource(profile);
                }
            }
            catch (Exception e) {
                if (!(e instanceof FileNotFoundException)) {
                    this.logger.warn("could not restore gHN profile from " + profile.getName() + ", regenerating it", e);
                }
                Builder.createGHNResource(this);
                if (this.addScope(this.getStartScopes()).size() != 0) break block6;
                throw new GCUBEResource.InvalidScopeException();
            }
        }
        if ((interval = (Long)this.getProperty(UPDATEINTERVAL_JNDI_NAME, false)) == null || interval == 0L) {
            interval = 300L;
        }
        this.logger.info("scheduling updates every " + interval + " seconds");
        updatescheduler = new Scheduler(this, interval, GCUBEScheduledHandler.Mode.LAZY);
        updatescheduler.run();
    }

    private void loadGHNResource(File profile) throws Exception {
        node.load(new FileReader(profile));
        Builder.updateGHNResource(this, true);
        this.logger.trace("restored gHN profile from " + profile.getName());
    }

    private void initialiseMonitoring() {
        HashMap<GCUBEScope, ArrayList<EndpointReferenceType>> monitoredScopes = new HashMap<GCUBEScope, ArrayList<EndpointReferenceType>>();
        for (GCUBEScope scope : startScopes) {
            try {
                if (scope.getServiceMap().getEndpoints(MSGBROKER) == null) continue;
                ArrayList<EndpointReferenceType> listScopes = new ArrayList<EndpointReferenceType>();
                for (EndpointReferenceType msgBrokerEpr : scope.getServiceMap().getEndpoints(MSGBROKER)) {
                    this.logger.info("MSG-Broker found: " + msgBrokerEpr.getAddress().toString() + " for scope: " + scope.toString());
                    listScopes.add(msgBrokerEpr);
                }
                monitoredScopes.put(scope, listScopes);
            }
            catch (GCUBEScopeNotSupportedException e) {
                this.logger.error("Scope not supported", e);
            }
            catch (Exception e) {
                this.logger.error("Error during BrokerMap Initialization", e);
            }
        }
        try {
            String infrastructure = (String)this.getProperty(INFRASTRUCTURE_NAME, true);
            GCUBEScope infrastructureScope = GCUBEScope.getScope("/" + infrastructure);
            if (infrastructureScope.getServiceMap().getEndpoints(MSGBROKER) != null) {
                ArrayList<EndpointReferenceType> listScopes = new ArrayList<EndpointReferenceType>();
                for (EndpointReferenceType msgBrokerEpr : infrastructureScope.getServiceMap().getEndpoints(MSGBROKER)) {
                    this.logger.info("MSG-Broker found: " + msgBrokerEpr.getAddress().toString() + " for scope: " + infrastructureScope.toString());
                    listScopes.add(msgBrokerEpr);
                }
                monitoredScopes.put(infrastructureScope, listScopes);
            }
        }
        catch (GCUBEScopeNotSupportedException e) {
            this.logger.error("Scope not supported", e);
        }
        catch (Exception e) {
            this.logger.error("Error during BrokerMap Initialization", e);
        }
        if (monitoredScopes.isEmpty()) {
            this.logger.warn("missing broker configuration for local monitor");
            return;
        }
        Object val = this.getProperty(TESTINTERVAL_JNDI_NAME, false);
        long interval = val == null ? 1800L : (Long)val;
        LocalMonitor monitor = null;
        try {
            monitor = GHNContext.getImplementation(LocalMonitor.class);
        }
        catch (ClassNotFoundException e) {
            this.logger.error("no implementation is available for the local monitor");
            return;
        }
        catch (Exception e) {
            this.logger.error("unable to initialise the local monitor", e);
            return;
        }
        monitor.setInterval(interval);
        monitor.setBrokerMap(monitoredScopes);
        try {
            monitor.run();
        }
        catch (Exception e) {
            this.logger.error("exception running the local monitor", e);
        }
        this.logger.info("local monitor started");
    }

    private void initialiseManagement() {
        try {
            int port = this.getFreePort();
            LocateRegistry.createRegistry(port);
            final MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            final ClassLoader currentContextLoader = Thread.currentThread().getContextClassLoader();
            MethodInterceptor interceptor = new MethodInterceptor(){

                public Object intercept(Object proxy, Method method, Object[] input, MethodProxy methodProxy) throws Throwable {
                    Thread.currentThread().setContextClassLoader(currentContextLoader);
                    return methodProxy.invoke((Object)mbs, input);
                }
            };
            String hostName = "localhost";
            String url = "service:jmx:rmi:///jndi/rmi://" + hostName + ":" + port + "/jmxrmi";
            JMXConnectorServer connector = JMXConnectorServerFactory.newJMXConnectorServer(new JMXServiceURL(url), null, (MBeanServer)Enhancer.create(MBeanServer.class, (Callback)interceptor));
            connector.start();
            this.logger.info("INITIALISED MANAGEMENT INTERFACE AT " + url);
            mbean = new GHN();
            ManagementFactory.getPlatformMBeanServer().registerMBean(mbean, new ObjectName("org.gcube:type=GHN,value=" + GHNContext.getContext().getHostname()));
            HierarchyDynamicMBean hdm = new HierarchyDynamicMBean();
            ObjectName mbo = new ObjectName("log4j:hierarchy=default");
            mbs.registerMBean(hdm, mbo);
            LoggerRepository r = LogManager.getLoggerRepository();
            Enumeration e = r.getCurrentLoggers();
            while (e.hasMoreElements()) {
                Logger l = (Logger)e.nextElement();
                if (!l.getName().startsWith(MBEANS_PREFIX) && !l.getName().startsWith("org.globus") || !l.getAllAppenders().hasMoreElements()) continue;
                Level currentLevel = l.getLevel();
                l.setLevel(Level.OFF);
                hdm.addLoggerMBean(l.getName());
                l.setLevel(currentLevel);
            }
        }
        catch (RuntimeException e) {
            this.logger.warn("missing configuration for management interface");
        }
        catch (Exception e) {
            this.logger.warn("could not initialise management interface", e);
        }
    }

    private void monitorContainer() {
        try {
            do {
                Thread.sleep(100L);
            } while ((container = ServiceContainerCollection.get((String)this.getBaseURL())) == null);
            this.setStatus(Status.READY, new String[0]);
            System.out.println("gHN started at: " + singleton.getBaseURL() + " with the following services:\n");
            List<String> gPts = singleton.getDeployedPortTypes();
            List<String> pts = singleton.getAllDeployedPortTypes();
            System.out.println("GCUBE SERVICES:\n");
            for (int i = 0; i < gPts.size(); ++i) {
                System.out.println("[" + (i + 1) + "]: " + singleton.getBaseURL() + gPts.get(i));
            }
            System.out.println("\nOTHER SERVICES:\n");
            for (int j = i; j < pts.size(); ++j) {
                if (pts.get(j).contains("gcube")) continue;
                System.out.println("[" + (j + 1) + "]: " + singleton.getBaseURL() + pts.get(j));
            }
            return;
        }
        catch (Exception e) {
            this.logger.fatal("gHN could not complete startup", e);
            this.setStatus(Status.FAILED, new String[0]);
            return;
        }
    }

    private void certify() {
        while (true) {
            try {
                block3: while (true) {
                    Thread.sleep(2000L);
                    Set<GCUBEServiceContext> contexts = this.getServiceContexts();
                    if (contexts.size() == 0) continue;
                    for (GCUBEServiceContext ctxt : contexts) {
                        if (ctxt.getStatus() == GCUBEServiceContext.Status.FAILED) {
                            return;
                        }
                        if (ctxt.getStatus() == GCUBEServiceContext.Status.READIED) continue;
                        continue block3;
                    }
                    break;
                }
                this.setStatus(Status.CERTIFIED, new String[0]);
                return;
            }
            catch (Exception e) {
                this.logger.warn("problem during certification monitoring", e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(Status newStatus, String ... message) throws IllegalStateException {
        if (!newStatus.previous().contains((Object)status)) {
            throw new IllegalStateException("transition from " + (Object)((Object)status) + " to " + (Object)((Object)newStatus) + " is illegal");
        }
        Status status = GHNContext.status;
        synchronized (status) {
            switch (newStatus) {
                case STARTED: {
                    GHNContext.status = newStatus;
                    statusMessage = message != null && message.length > 0 ? message[0] : null;
                    break;
                }
                case READY: {
                    GHNContext.status = newStatus;
                    statusMessage = message != null && message.length > 0 ? message[0] : null;
                    lifetimeProducer.notify(Events.GHNTopic.READY, new Events.GHNLifeTimeEvent());
                    break;
                }
                case CERTIFIED: {
                    GHNContext.status = newStatus;
                    statusMessage = message != null && message.length > 0 ? message[0] : null;
                    this.setStatus(Status.UPDATED, new String[0]);
                    break;
                }
                case UPDATED: {
                    try {
                        node.store(new FileWriter(this.getFile(PROFILE_FILE_NAME, true)));
                    }
                    catch (Exception e) {
                        this.logger.warn("could not serialise gHN profile", e);
                    }
                    lifetimeProducer.notify(Events.GHNTopic.UPDATE, new Events.GHNLifeTimeEvent());
                    break;
                }
                case FAILED: 
                case DOWN: {
                    this.logger.info("the gHN is shutting down in 10 seconds");
                    GHNContext.status = newStatus;
                    statusMessage = message != null && message.length > 0 ? message[0] : null;
                    updatescheduler.stop();
                    Builder.updateGHNResource(this, new boolean[0]);
                    this.setStatus(Status.UPDATED, new String[0]);
                    try {
                        lifetimeProducer.notify(Events.GHNTopic.SHUTDOWN, new Events.GHNLifeTimeEvent());
                    }
                    catch (Exception e) {
                        this.logger.warn("could not inform Running Instances of gHN shutdown");
                    }
                    new Thread("GHNKiller"){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(10000L);
                                GHNContext.exitProcess();
                            }
                            catch (Exception e) {
                                GHNContext.this.logger.error("gHN could not shutdown", e);
                            }
                        }
                    }.start();
                }
            }
        }
        this.logger.trace("the gHN is " + newStatus.toString().toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status getStatus() {
        Status status = GHNContext.status;
        synchronized (status) {
            return GHNContext.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatusMessage() {
        String string = statusMessage;
        synchronized (string) {
            return statusMessage;
        }
    }

    @AccessControlProxyContext.Restricted(value={"org.gcube.common"})
    public void restart(String ... message) {
        this.logger.info("the gHN is going to be restarted...");
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(this.getFile(".restart", new boolean[0])));
            out.write(" ");
            out.close();
            this.shutdown(message);
        }
        catch (Exception e) {
            this.logger.error("could not restart the container", e);
        }
    }

    @AccessControlProxyContext.Restricted(value={"org.gcube.common"})
    public void restartAndClean(String ... message) {
        this.logger.info("the gHN is going to be restarted and cleaned up...");
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(this.getFile(".restartAndClean", new boolean[0])));
            out.write(" ");
            out.close();
            this.shutdown(message);
        }
        catch (Exception e) {
            this.logger.error("could not restart the container", e);
        }
    }

    @AccessControlProxyContext.Restricted(value={"org.gcube.common"})
    public void shutdown(String ... message) {
        this.setStatus(Status.DOWN, message);
    }

    private static void exitProcess() {
        if (container != null) {
            try {
                container.stop();
            }
            catch (Exception e) {
                GHNContext.singleton.logger.warn("gHN could not gracefully stop the container", e);
            }
        }
        GHNContext.singleton.logger.info("the gHN is shutting down now");
        System.exit(0);
    }

    @AccessControlProxyContext.Restricted(value={"org.gcube.common"})
    public synchronized void registerService(GCUBEServiceContext context) throws Exception {
        if (services.containsKey(context.getServiceClass() + context.getName())) {
            throw new Exception("(" + context.getServiceClass() + "," + context.getName() + ") has already registered");
        }
        this.logger.info("REGISTERED RI OF (" + context.getServiceClass().toUpperCase() + "," + context.getName().toUpperCase() + ")");
        services.put(context.getServiceClass() + context.getName(), context);
        context.subscribeLifetTime(this.RIConsumer, new GCUBEServiceContext.RILifetimeTopic[0]);
        lifetimeProducer.notify(Events.GHNTopic.RIREGISTRATION, new Events.GHNRIRegistrationEvent(context));
    }

    public synchronized GCUBEServiceContext getServiceContext(String serviceClass, String serviceName) throws Exception {
        GCUBEServiceContext context = services.get(serviceClass + serviceName);
        if (context == null) {
            throw new Exception("service " + serviceName + " is unknown");
        }
        return GCUBEProxyFactory.getProxy(context, GCUBEServiceContext.class);
    }

    @AccessControlProxyContext.Restricted(value={"org.gcube.common"})
    public synchronized Set<GCUBEServiceContext> getServiceContexts() throws Exception {
        HashSet<GCUBEServiceContext> set = new HashSet<GCUBEServiceContext>();
        set.addAll(services.values());
        return Collections.unmodifiableSet(set);
    }

    public void subscribeGHNEvents(GHNConsumer consumer, Events.GHNTopic ... topics) throws Exception {
        if (topics == null || topics.length == 0) {
            topics = Events.GHNTopic.values();
        }
        lifetimeProducer.subscribe(consumer, topics);
    }

    public void unsubscribeGHNEvents(GHNConsumer consumer, Events.GHNTopic ... topics) {
        lifetimeProducer.unsubscribe(consumer, topics);
    }

    public boolean isSecurityEnabled() {
        return (Boolean)this.getProperty(SECURITY_JNDI_NAME, true);
    }

    public boolean overrideServiceSecurity() {
        Boolean override = (Boolean)this.getProperty(OVERRIDE_SERVICE_SECURITY, new boolean[0]);
        if (override == null) {
            return false;
        }
        return override;
    }

    @AccessControlProxyContext.Restricted
    public void subscribeForCredentialRequest(CredentialRequestConsumer consumer) throws Exception {
        securityProducer.subscribe(consumer, new Events.SecurityTopic[]{Events.SecurityTopic.CREDENTIAL_REQUEST});
    }

    @AccessControlProxyContext.Restricted
    public void subscribeForCredential(CredentialConsumer consumer) throws Exception {
        this.logger.info("subscribing service " + consumer.getServiceContext().getName() + " for credential delegation");
        securityProducer.subscribe(consumer, new Events.SecurityTopic[]{Events.SecurityTopic.CREDENTIAL_DELEGATION});
        securityProducer.notify(Events.SecurityTopic.CREDENTIAL_REQUEST, new Events.CredentialRequestEvent(consumer.getServiceContext()));
    }

    @AccessControlProxyContext.Restricted
    public void delegateCredentials(GCUBEServiceContext context, GSSCredential credentials) {
        this.logger.debug("delegating credentials to service " + context.getName());
        try {
            this.getServiceContext(context.getServiceClass(), context.getName());
        }
        catch (Exception e) {
            this.logger.warn("could not delegate credentials", e);
        }
        securityProducer.notify(Events.SecurityTopic.CREDENTIAL_DELEGATION, new Events.CredentialDelegationEvent(new Events.CredentialPayload(context, credentials)));
    }

    @AccessControlProxyContext.Restricted
    public synchronized Set<GCUBEScope> addScope(GCUBEScope ... scopes) throws GCUBEResource.InvalidScopeException {
        if (this.isSecurityEnabled() && !GHNContext.getContext().isClientMode() && !this.acceptScopes(scopes)) {
            this.logger.error("One of the scope(s) was not accepted by this GHN");
            throw new GCUBEResource.InvalidScopeException();
        }
        Set<GCUBEScope> validScopes = this.getGHN().addScope(scopes);
        if (validScopes.size() > 0) {
            this.setStatus(Status.UPDATED, new String[0]);
        }
        return validScopes;
    }

    private boolean acceptScopes(GCUBEScope ... scopes) {
        if (scopes == null) {
            return false;
        }
        for (GCUBEScope scope : scopes) {
            if (this.containScope(this.getAllowedScopes(), scope)) continue;
            this.logger.error("Scope " + scope.toString() + " is not in the list of allowed Scopes for this gHN (" + Arrays.toString(this.getAllowedScopes()) + ")");
            return false;
        }
        return true;
    }

    private boolean containScope(GCUBEScope[] scopes, GCUBEScope scope) {
        for (GCUBEScope itemScope : scopes) {
            if (itemScope == null) continue;
            this.logger.trace("Checking " + itemScope.getName());
            if (itemScope.getName().compareToIgnoreCase(scope.getName()) != 0) continue;
            return true;
        }
        return false;
    }

    @AccessControlProxyContext.Restricted
    public synchronized Set<GCUBEScope> removeScope(GCUBEScope ... scopes) {
        Set<GCUBEScope> validScopes = this.getGHN().removeScope(scopes);
        if (validScopes.size() > 0) {
            this.setStatus(Status.UPDATED, new String[0]);
        }
        return validScopes;
    }

    public static synchronized <INTERFACE> INTERFACE getImplementation(Class<INTERFACE> interfaceClass) throws Exception {
        String className = implementations.getProperty(interfaceClass.getSimpleName());
        if (className == null) {
            return null;
        }
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        if (!interfaceClass.isAssignableFrom(clazz)) {
            throw new Exception(className + " does not implement " + interfaceClass.getName());
        }
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        return (INTERFACE)constructor.newInstance(new Object[0]);
    }

    @Override
    public File getFile(String fileName, boolean ... writeMode) throws IllegalArgumentException {
        return super.getFile(this.getLocation() + File.separatorChar + CONFIGDIR_NAME + File.separatorChar + fileName, writeMode);
    }

    @Override
    public InputStream getResource(String resourceName) {
        return this.getClass().getResourceAsStream("/config/" + resourceName);
    }

    public String getGHNID() {
        return node.getID();
    }

    public boolean isGHNReady() {
        return this.getStatus() == Status.READY || this.getStatus().previous().contains((Object)Status.READY);
    }

    public GHN getManagementBean() {
        return mbean;
    }

    @ReadOnlyProxyContext.ReadOnly
    public GCUBEHostingNode getGHN() {
        return node;
    }

    public Mode getMode() {
        if (mode == null) {
            if (((String)this.getProperty(MODE_JNDI_NAME, true)).compareToIgnoreCase(Mode.STANDALONE.toString()) == 0) {
                return Mode.STANDALONE;
            }
            if (((String)this.getProperty(MODE_JNDI_NAME, true)).compareToIgnoreCase(Mode.ROOT.toString()) == 0) {
                return Mode.ROOT;
            }
            return Mode.CONNECTED;
        }
        return mode;
    }

    public Type getType() {
        if (((String)this.getProperty(MODE_JNDI_NAME, true)).compareToIgnoreCase(Type.STATIC.toString()) == 0) {
            return Type.STATIC;
        }
        return Type.DYNAMIC;
    }

    public void setMode(Mode mode) {
        GHNContext.mode = mode;
    }

    public Integer getFreePort() throws RuntimeException, Exception {
        String portRange = (String)this.getProperty(OPEN_PORTS, true);
        String[] bounds = portRange.split("-");
        int left = Integer.parseInt(bounds[0]);
        int right = Integer.parseInt(bounds[1]);
        for (int port = left; port < right; ++port) {
            try {
                ServerSocket s = new ServerSocket(port);
                s.close();
                return port;
            }
            catch (IOException ex) {
                continue;
            }
        }
        throw new Exception("No free port in range " + left + "-" + right);
    }

    private List<String> getAllDeployedPortTypes() throws Exception, IllegalStateException {
        if (!this.isGHNReady()) {
            throw new IllegalStateException();
        }
        ArrayList<String> eprs = new ArrayList<String>();
        Iterator i = container.getEngine().getConfig().getDeployedServices();
        while (i.hasNext()) {
            eprs.add(((ServiceDesc)i.next()).getName());
        }
        Collections.sort(eprs);
        return eprs;
    }

    public List<String> getDeployedPortTypes() throws Exception, IllegalStateException {
        ArrayList<String> entryNames = new ArrayList<String>();
        for (String portType : this.getAllDeployedPortTypes()) {
            if (!portType.contains("gcube")) continue;
            entryNames.add(portType);
        }
        return entryNames;
    }

    public synchronized GCUBEScope[] getStartScopes() {
        return startScopes;
    }

    public synchronized GCUBEScope[] getAllowedScopes() {
        return allowedScopes;
    }

    public long getTrustedGHNSynchInterval() {
        try {
            return (Long)this.getProperty(TRUSTEDGHNINTERVAL_JNDI_NAME, true);
        }
        catch (Exception e) {
            return 600L;
        }
    }

    public String getLocation() {
        String loc = System.getenv("GLOBUS_LOCATION");
        return loc != null ? loc : System.getProperty("GLOBUS_LOCATION");
    }

    public String getVirtualPlatformsLocation() {
        return this.getLocation() + File.separator + "virtual-platforms";
    }

    public String getBaseURL() throws IOException {
        return ServiceHost.getBaseURL().toString();
    }

    public String getBaseURLToPublish() throws IOException {
        String baseURL = this.getBaseURL();
        if (this.getProperty(PUBLISHED_HOST_NAME, false) != null) {
            baseURL = baseURL.replace(ServiceHost.getHost(), (String)this.getProperty(PUBLISHED_HOST_NAME, false));
        }
        if (this.getProperty(PUBLISHED_PORT_NAME, false) != null) {
            baseURL = baseURL.replace(Integer.toString(ServiceHost.getPort()), Integer.toString((Integer)this.getProperty(PUBLISHED_PORT_NAME, false)));
        }
        return baseURL;
    }

    public int getPublishedPort() {
        if (this.getProperty(PUBLISHED_PORT_NAME, false) != null) {
            return (Integer)this.getProperty(PUBLISHED_PORT_NAME, false);
        }
        return this.getPort();
    }

    public int getPort() {
        return ServiceHost.getPort();
    }

    public String getPublishedHostname() {
        if (this.getProperty(PUBLISHED_HOST_NAME, false) != null) {
            return (String)this.getProperty(PUBLISHED_HOST_NAME, false);
        }
        return this.getHostname();
    }

    public LocalInstanceContext getLocalInstanceContext() {
        return LocalInstanceContext.getContext();
    }

    public String getHostname() {
        try {
            return ServiceHost.getHost();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    public String getServiceEndpointPrefix() {
        return "/wsrf/services/";
    }

    public String getStorageRoot() {
        String root = System.getProperty(STORAGE_ROOT_PROPERTY);
        return root == null ? STORAGE_ROOT : root;
    }

    public long getFreeSpace(String localFS) {
        long free = 0L;
        try {
            free = FileSystemUtils.freeSpace((String)localFS);
        }
        catch (IOException ioe) {
            this.logger.warn("unable to detect the free space on the disk", ioe);
        }
        return free;
    }

    public String getUptime() {
        String lines = "";
        String linetemp = null;
        try {
            Process p = Runtime.getRuntime().exec("uptime");
            p.waitFor();
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((linetemp = input.readLine()) != null) {
                lines = lines + linetemp;
            }
            input.close();
            p.destroy();
            lines = lines.split(",")[0].split("up")[1].trim();
        }
        catch (Exception e) {
            this.logger.warn("unable to detect the uptime of this machine", e);
            lines = "unable to detect";
        }
        return lines;
    }

    public Map<String, Long> getMemoryUsage() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        OperatingSystemMXBean mxbean = ManagementFactory.getOperatingSystemMXBean();
        com.sun.management.OperatingSystemMXBean sunmxbean = (com.sun.management.OperatingSystemMXBean)mxbean;
        long freeMemory = sunmxbean.getFreePhysicalMemorySize() / 0x100000L;
        long availableMemory = sunmxbean.getTotalPhysicalMemorySize() / 0x100000L;
        map.put("MemoryAvailable", freeMemory);
        map.put("MemoryTotalSize", availableMemory);
        long ramVirtualAvailable = Runtime.getRuntime().freeMemory() / 0x100000L;
        long ramVirtualSize = Runtime.getRuntime().totalMemory() / 0x100000L;
        map.put("VirtualAvailable", ramVirtualAvailable);
        map.put("VirtualSize", ramVirtualSize);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<HashMap<String, String>> getCPUInfo() {
        ArrayList<HashMap<String, String>> map = new ArrayList<HashMap<String, String>>();
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(new File("/proc/cpuinfo")));
            String line = null;
            HashMap<String, String> currentProcessor = null;
            while ((line = input.readLine()) != null) {
                if (line.startsWith("processor")) {
                    if (currentProcessor != null) {
                        map.add((HashMap)currentProcessor.clone());
                    }
                    currentProcessor = new HashMap<String, String>();
                }
                try {
                    if (line.contains("vendor_id")) {
                        currentProcessor.put("vendor_id", line.split(":")[1].trim());
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    if (line.contains("cpu family")) {
                        currentProcessor.put("cpu_family", line.split(":")[1].trim());
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    if (line.contains("model\t") || line.contains("model\b")) {
                        currentProcessor.put("model", line.split(":")[1].trim());
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    if (line.contains("model name")) {
                        currentProcessor.put("model_name", line.split(":")[1].trim());
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    if (line.contains("cpu MHz")) {
                        currentProcessor.put("cpu_MHz", line.split(":")[1].trim());
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    if (line.contains("cache size")) {
                        currentProcessor.put("cache_size", line.split(":")[1].trim().split(" ")[0]);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    if (!line.contains("bogomips")) continue;
                    currentProcessor.put("bogomips", line.split(":")[1].trim());
                }
                catch (Exception ex) {}
            }
            if (currentProcessor != null) {
                map.add(currentProcessor);
            }
        }
        catch (FileNotFoundException e) {
            this.logger.warn("unable to acquire CPU info");
        }
        catch (Exception ex) {
            this.logger.warn("unable to acquire CPU info", ex);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                this.logger.warn("unable to release the CPU resource reader", ex);
            }
        }
        return map;
    }

    public Map<String, Double> getLoadStatistics() {
        HashMap<String, Double> result = new HashMap<String, Double>();
        try {
            File loadadv = new File("/proc/loadavg");
            if (loadadv.exists()) {
                int c;
                FileReader reader = new FileReader(loadadv);
                StringBuilder content = new StringBuilder();
                while ((c = ((Reader)reader).read()) != -1) {
                    content.append((char)c);
                }
                ((Reader)reader).close();
                Pattern p = Pattern.compile("^(.*?)\\s{1}(.*?)\\s{1}(.*?)\\s{1}(.*)$");
                Matcher matcher = p.matcher(content.toString());
                if (matcher.matches() && matcher.groupCount() > 3) {
                    result.put("1min", new Double(matcher.group(1)));
                    result.put("5mins", new Double(matcher.group(2)));
                    result.put("15mins", new Double(matcher.group(3).split("\\s")[0]));
                }
            }
        }
        catch (Exception ioe) {
            this.logger.warn("unable to detect the load values of this machine", ioe);
        }
        return result;
    }

    public String getIP() {
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            return localMachine.getHostAddress();
        }
        catch (UnknownHostException e) {
            this.logger.warn("unable to detect the IP address of the host");
            return "";
        }
    }

    public String getHostnameAndPort() {
        return this.getHostname() + ":" + this.getPort();
    }

    public String getPublishedHostnameAndPort() {
        return this.getPublishedHostname() + ":" + this.getPublishedPort();
    }

    public String getHostDomain() throws IOException {
        return this.trimDomain(this.getHostname());
    }

    public String getPublishedHostDomain() throws IOException {
        return this.trimDomain(this.getPublishedHostname());
    }

    private String trimDomain(String hostname) {
        Pattern pattern = Pattern.compile("([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})");
        Matcher regexMatcher = pattern.matcher(hostname);
        if (regexMatcher.matches()) {
            return hostname;
        }
        String[] tokens = hostname.split("\\.");
        if (tokens.length < 2) {
            return hostname;
        }
        return tokens[tokens.length - 2] + "." + tokens[tokens.length - 1];
    }

    static {
        lifetimeProducer = new GCUBEProducer();
        securityProducer = new GCUBEProducer();
        services = Collections.synchronizedMap(new HashMap());
        status = Status.DEPLOYED;
        startScopes = null;
        allowedScopes = null;
        updatescheduler = null;
        try {
            GHNContext.singleton.logger.info("INITIALISING GHN");
            if (singleton.isClientMode()) {
                singleton = new GHNClientContext();
            }
            singletonproxy = GCUBEProxyFactory.getProxy(singleton, new Class[0]);
            singleton.initialise();
        }
        catch (Throwable e) {
            GHNContext.singleton.logger.fatal("gHN could not complete initialisation", e);
            GHNContext.exitProcess();
        }
    }

    public static enum Status {
        DEPLOYED{

            @Override
            public List<Status> previous() {
                return Collections.singletonList(UNREACHABLE);
            }

            public String toString() {
                return "deployed";
            }
        }
        ,
        STARTED{

            @Override
            public List<Status> previous() {
                return Arrays.asList(DEPLOYED, UNREACHABLE);
            }

            public String toString() {
                return "started";
            }
        }
        ,
        CERTIFIED{

            @Override
            public List<Status> previous() {
                return Arrays.asList(READY, UNREACHABLE);
            }

            public String toString() {
                return "certified";
            }
        }
        ,
        UPDATED{

            @Override
            public List<Status> previous() {
                return Arrays.asList(DEPLOYED, STARTED, READY, CERTIFIED, FAILED, DOWN, UNREACHABLE);
            }

            public String toString() {
                return "updated";
            }
        }
        ,
        READY{

            @Override
            public List<Status> previous() {
                return Arrays.asList(STARTED, CERTIFIED, UNREACHABLE);
            }

            public String toString() {
                return "ready";
            }
        }
        ,
        FAILED{

            @Override
            public List<Status> previous() {
                return Arrays.asList(STARTED, READY, CERTIFIED, UNREACHABLE);
            }

            public String toString() {
                return "failed";
            }
        }
        ,
        DOWN{

            @Override
            public List<Status> previous() {
                return Arrays.asList(DEPLOYED, STARTED, READY, CERTIFIED, FAILED, UNREACHABLE);
            }

            public String toString() {
                return "down";
            }
        }
        ,
        UNREACHABLE{

            @Override
            public List<Status> previous() {
                return Arrays.asList(CERTIFIED, UNREACHABLE);
            }

            public String toString() {
                return "unreachable";
            }
        };


        public abstract List<Status> previous();
    }

    public static enum Type {
        DYNAMIC("DYNAMIC"),
        STATIC("STATIC"),
        SELFCLEANING("SELFCLEANING");

        String type;

        private Type(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }

    public static enum Mode {
        STANDALONE("STANDALONE"),
        CONNECTED("CONNECTED"),
        ROOT("ROOT");

        String mode;

        private Mode(String mode) {
            this.mode = mode;
        }

        public String toString() {
            return this.mode;
        }
    }
}

