/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.messaging.endpoints;

import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.gcube.common.messaging.endpoints.Constants;
import org.gcube.common.messaging.endpoints.EndpointRetriever;
import org.gcube.common.scope.api.ScopeProvider;

public class ScheduledRetriever {
    EndpointRetriever retriever = null;

    public ScheduledRetriever(String scope, long intervalTime) {
        this.retriever = new EndpointRetriever(scope);
        ScopeProvider.instance.set(scope);
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        scheduler.scheduleWithFixedDelay(this.retriever, 0L, intervalTime, TimeUnit.SECONDS);
    }

    public ArrayList<String> getEndpoints() {
        return this.retriever.getEndpoints();
    }

    public String getFailoverEndpoint() {
        String endpointString = "";
        for (String endpoint : this.retriever.getEndpoints()) {
            if (endpointString.isEmpty()) {
                endpointString = endpointString + "(" + endpoint;
                continue;
            }
            endpointString = endpointString + "," + endpoint;
        }
        endpointString = endpointString + ")";
        return Constants.failoverPrefix + endpointString;
    }
}

