/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.resources.kxml.service;

import org.gcube.common.core.resources.service.Dependency;
import org.gcube.common.core.resources.service.Package;
import org.gcube.common.resources.kxml.KGCUBEResource;
import org.gcube.common.resources.kxml.common.KPlatform;
import org.gcube.common.resources.kxml.service.KDependency;
import org.gcube.common.resources.kxml.utils.KAny;
import org.gcube.common.resources.kxml.utils.KBoolean;
import org.gcube.common.resources.kxml.utils.KStringList;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;

public class KPackage {
    public static void load(Package p, KXmlParser parser) throws Exception {
        if (parser.getName().equals("Description")) {
            p.setDescription(parser.nextText().trim());
        }
        if (parser.getName().equals("Name")) {
            p.setName(parser.nextText().trim());
        }
        if (parser.getName().equals("Version")) {
            p.setVersion(parser.nextText().trim());
        }
        if (parser.getName().equals("MavenCoordinates")) {
            KPackage.loadCoordinates(p, parser);
        }
        if (parser.getName().equals("TargetPlatform")) {
            p.setTargetPlatform(KPlatform.load(parser, "TargetPlatform"));
        }
        if (parser.getName().equals("MultiVersion")) {
            p.setMultiVersion(KBoolean.load(parser));
        }
        if (parser.getName().equals("Mandatory")) {
            p.setMandatoryLevel(Package.ScopeLevel.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "level")));
        }
        if (parser.getName().equals("Shareable")) {
            p.setSharingLevel(Package.ScopeLevel.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "level")));
        }
        if (parser.getName().equals("Requirement")) {
            p.getGHNRequirements().add(KGHNRequirement.load(parser));
        }
        if (parser.getName().equals("InstallScripts")) {
            p.setInstallScripts(KStringList.load("InstallScripts", parser));
        }
        if (parser.getName().equals("UninstallScripts")) {
            p.setUninstallScripts(KStringList.load("UninstallScripts", parser));
        }
        if (parser.getName().equals("RebootScripts")) {
            p.setRebootScripts(KStringList.load("RebootScripts", parser));
        }
        if (parser.getName().equals("Dependency")) {
            p.getDependencies().add(KDependency.load(parser));
        }
        if (parser.getName().equals("SpecificData")) {
            p.setSpecificData(KAny.load("SpecificData", parser));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void loadCoordinates(Package p, KXmlParser parser) throws Exception {
        String groupId = null;
        String artifactId = null;
        String version = null;
        String classifier = null;
        block5: while (true) {
            switch (parser.next()) {
                case 2: {
                    if (parser.getName().equals(Package.MavenCoordinate.groupId.name())) {
                        groupId = parser.nextText().trim();
                    }
                    if (parser.getName().equals(Package.MavenCoordinate.artifactId.name())) {
                        artifactId = parser.nextText().trim();
                    }
                    if (parser.getName().equals(Package.MavenCoordinate.version.name())) {
                        version = parser.nextText().trim();
                    }
                    if (!parser.getName().equals(Package.MavenCoordinate.classifier.name())) break;
                    classifier = parser.nextText().trim();
                    break;
                }
                case 3: {
                    if (!parser.getName().equals("MavenCoordinates")) break;
                    break block5;
                }
                case 1: {
                    throw new Exception("Parsing failed at MavenCoordinates");
                }
            }
        }
        p.setMavenCoordinates(groupId, artifactId, version, classifier);
    }

    public static void store(Package component, KXmlSerializer serializer) throws Exception {
        if (component.getDescription() != null) {
            serializer.startTag(KGCUBEResource.NS, "Description").text(component.getDescription().trim()).endTag(KGCUBEResource.NS, "Description");
        }
        if (component.getName() != null) {
            serializer.startTag(KGCUBEResource.NS, "Name").text(component.getName().trim()).endTag(KGCUBEResource.NS, "Name");
        }
        if (component.getVersion() != null) {
            serializer.startTag(KGCUBEResource.NS, "Version").text(component.getVersion().trim()).endTag(KGCUBEResource.NS, "Version");
        }
        if (component.getMavenCoordinate(Package.MavenCoordinate.groupId) != null) {
            serializer.startTag(KGCUBEResource.NS, "MavenCoordinates");
            serializer.startTag(KGCUBEResource.NS, Package.MavenCoordinate.groupId.name()).text(component.getMavenCoordinate(Package.MavenCoordinate.groupId)).endTag(KGCUBEResource.NS, Package.MavenCoordinate.groupId.name());
            serializer.startTag(KGCUBEResource.NS, Package.MavenCoordinate.artifactId.name()).text(component.getMavenCoordinate(Package.MavenCoordinate.artifactId)).endTag(KGCUBEResource.NS, Package.MavenCoordinate.artifactId.name());
            serializer.startTag(KGCUBEResource.NS, Package.MavenCoordinate.version.name()).text(component.getMavenCoordinate(Package.MavenCoordinate.version)).endTag(KGCUBEResource.NS, Package.MavenCoordinate.version.name());
            if (component.getMavenCoordinate(Package.MavenCoordinate.classifier) != null) {
                serializer.startTag(KGCUBEResource.NS, Package.MavenCoordinate.classifier.name()).text(component.getMavenCoordinate(Package.MavenCoordinate.classifier)).endTag(KGCUBEResource.NS, Package.MavenCoordinate.classifier.name());
            }
            serializer.endTag(KGCUBEResource.NS, "MavenCoordinates");
        }
        if (component.getTargetPlatform() != null) {
            KPlatform.store(component.getTargetPlatform(), serializer, "TargetPlatform");
        }
        if (component.getMultiVersion() != null) {
            serializer.startTag(KGCUBEResource.NS, "MultiVersion");
            KBoolean.store(component.getMultiVersion(), serializer);
            serializer.endTag(KGCUBEResource.NS, "MultiVersion");
        }
        if (component.getMandatoryLevel() != null) {
            serializer.startTag(KGCUBEResource.NS, "Mandatory").attribute(KGCUBEResource.NS, "level", component.getMandatoryLevel().toString()).endTag(KGCUBEResource.NS, "Mandatory");
        }
        if (component.getSharingLevel() != null) {
            serializer.startTag(KGCUBEResource.NS, "Shareable").attribute(KGCUBEResource.NS, "level", component.getSharingLevel().toString()).endTag(KGCUBEResource.NS, "Shareable");
        }
        if (component.getGHNRequirements().size() != 0) {
            serializer.startTag(KGCUBEResource.NS, "GHNRequirements");
            for (Package.GHNRequirement r : component.getGHNRequirements()) {
                KGHNRequirement.store(r, serializer);
            }
            serializer.endTag(KGCUBEResource.NS, "GHNRequirements");
        }
        if (component.getInstallScripts().size() != 0) {
            KStringList.store("InstallScripts", "File", component.getInstallScripts(), serializer);
        }
        if (component.getUninstallScripts().size() != 0) {
            KStringList.store("UninstallScripts", "File", component.getUninstallScripts(), serializer);
        }
        if (component.getRebootScripts().size() != 0) {
            KStringList.store("RebootScripts", "File", component.getRebootScripts(), serializer);
        }
        if (component.getDependencies().size() != 0) {
            serializer.startTag(KGCUBEResource.NS, "Dependencies");
            for (Dependency d : component.getDependencies()) {
                KDependency.store(d, serializer);
            }
            serializer.endTag(KGCUBEResource.NS, "Dependencies");
        }
        KAny.store("SpecificData", component.getSpecificData(), serializer);
    }

    public static class KGHNRequirement {
        public static Package.GHNRequirement load(KXmlParser parser) throws Exception {
            Package.GHNRequirement r = new Package.GHNRequirement();
            String categoryName = parser.getAttributeValue(KGCUBEResource.NS, "category").trim();
            if (Package.GHNRequirement.Category.hasValue(categoryName)) {
                r.setCategory(Package.GHNRequirement.Category.valueOf(categoryName));
            } else {
                r.setCategory(categoryName);
            }
            if (parser.getAttributeValue(KGCUBEResource.NS, "key") != null) {
                r.setKey(parser.getAttributeValue(KGCUBEResource.NS, "key").trim());
            }
            r.setValue(parser.getAttributeValue(KGCUBEResource.NS, "value").trim());
            if (parser.getAttributeValue(KGCUBEResource.NS, "requirement") != null) {
                r.setRequirement(parser.getAttributeValue(KGCUBEResource.NS, "requirement").trim());
            }
            r.setOperator(Package.GHNRequirement.OpType.fromValue(parser.getAttributeValue(KGCUBEResource.NS, "operator").trim()));
            return r;
        }

        public static void store(Package.GHNRequirement component, KXmlSerializer serializer) throws Exception {
            if (component.getCategory() != null) {
                serializer.startTag(KGCUBEResource.NS, "Requirement");
                serializer.attribute(KGCUBEResource.NS, "category", component.getCategory().toString());
                if (component.getKey() != null) {
                    serializer.attribute(KGCUBEResource.NS, "key", component.getKey().trim());
                }
                if (component.getRequirement() != null) {
                    serializer.attribute(KGCUBEResource.NS, "requirement", component.getRequirement().trim());
                }
                if (component.getValue() != null) {
                    serializer.attribute(KGCUBEResource.NS, "value", component.getValue().trim());
                }
                serializer.attribute(KGCUBEResource.NS, "operator", component.getOperator().value().trim());
                serializer.endTag(KGCUBEResource.NS, "Requirement");
            }
        }
    }
}

