/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.StorageHint;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.AbstractSMSResponseConfig;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.SMSResponseType;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.content.NoRawContent;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.content.RawContentAsUrl;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.content.RawContentInLocation;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.content.RawContentInMessage;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.content.RawContentLocationConfig;

public class InformationObjectResponse
extends AbstractSMSResponseConfig {
    protected RawContentLocationConfig location;
    protected List<StorageHint> hints;

    public static InformationObjectResponse plainInformationObject() {
        LinkedList<StorageHint> hints = new LinkedList<StorageHint>();
        hints.add(new StorageHint("return-plain-object", String.valueOf(Boolean.TRUE)));
        return new InformationObjectResponse(NoRawContent.instance(), hints);
    }

    public static InformationObjectResponse plainInformationObjectWithProperties() {
        LinkedList<StorageHint> hints = new LinkedList<StorageHint>();
        hints.add(new StorageHint("return-object-without-references", String.valueOf(Boolean.TRUE)));
        return new InformationObjectResponse(RawContentAsUrl.instance(), hints);
    }

    public static InformationObjectResponse completeInformationObject() {
        return new InformationObjectResponse(NoRawContent.instance(), Collections.<StorageHint>emptyList());
    }

    public static InformationObjectResponse completeInformationObjectWithContent(String location) {
        return new InformationObjectResponse(new RawContentInLocation(location), Collections.<StorageHint>emptyList());
    }

    public static InformationObjectResponse completeInformationObjectWithContentInMessage() {
        return new InformationObjectResponse(RawContentInMessage.instance(), Collections.<StorageHint>emptyList());
    }

    public static InformationObjectResponse plainInformationObjectWithContent(String location) {
        LinkedList<StorageHint> hints = new LinkedList<StorageHint>();
        hints.add(new StorageHint("return-plain-object", String.valueOf(Boolean.TRUE)));
        return new InformationObjectResponse(new RawContentInLocation(location), hints);
    }

    public static InformationObjectResponse plainInformationObjectWithContentInMessage() {
        LinkedList<StorageHint> hints = new LinkedList<StorageHint>();
        hints.add(new StorageHint("return-plain-object", String.valueOf(Boolean.TRUE)));
        return new InformationObjectResponse(RawContentInMessage.instance(), hints);
    }

    public InformationObjectResponse(RawContentLocationConfig location, List<StorageHint> hints) {
        super(SMSResponseType.INFORMATION_OBJECT);
        this.location = location;
        this.hints = hints;
    }

    public RawContentLocationConfig getLocation() {
        return this.location;
    }

    public List<StorageHint> getHints() {
        return this.hints;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("InformationObjectResponse [hints=");
        builder.append(this.hints);
        builder.append(", location=");
        builder.append(this.location);
        builder.append("]");
        return builder.toString();
    }
}

