/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import org.apache.axis.MessageContext;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;

public class HandlerChainImpl
extends ArrayList
implements HandlerChain {
    private String[] _roles;
    private int falseIndex = -1;
    protected List handlerInfos = new ArrayList();

    public String[] getRoles() {
        return this._roles;
    }

    public void setRoles(String[] roles) {
        if (roles != null) {
            this._roles = (String[])roles.clone();
        }
    }

    public void init(Map map) {
    }

    public HandlerChainImpl() {
    }

    public HandlerChainImpl(List handlerInfos) {
        this.handlerInfos = handlerInfos;
        for (int i = 0; i < handlerInfos.size(); ++i) {
            this.add(this.newHandler(this.getHandlerInfo(i)));
        }
    }

    public void addNewHandler(String className, Map config) {
        try {
            HandlerInfo handlerInfo = new HandlerInfo(ClassUtils.forName(className), config, null);
            this.handlerInfos.add(handlerInfo);
            this.add(this.newHandler(handlerInfo));
        }
        catch (Exception ex) {
            String messageText = Messages.getMessage("NoJAXRPCHandler00", className);
            throw new JAXRPCException(messageText, (Throwable)ex);
        }
    }

    public boolean handleFault(javax.xml.rpc.handler.MessageContext _context) {
        SOAPMessageContext context = (SOAPMessageContext)_context;
        int endIdx = this.size() - 1;
        if (this.falseIndex != -1) {
            endIdx = this.falseIndex;
        }
        for (int i = endIdx; i >= 0; --i) {
            if (this.getHandlerInstance(i).handleFault((javax.xml.rpc.handler.MessageContext)context)) continue;
            return false;
        }
        return true;
    }

    public boolean handleRequest(javax.xml.rpc.handler.MessageContext _context) {
        ((MessageContext)_context).setRoles(this.getRoles());
        SOAPMessageContext context = (SOAPMessageContext)_context;
        for (int i = 0; i < this.size(); ++i) {
            Handler currentHandler = this.getHandlerInstance(i);
            try {
                if (currentHandler.handleRequest((javax.xml.rpc.handler.MessageContext)context)) continue;
                this.falseIndex = i;
                return false;
            }
            catch (SOAPFaultException sfe) {
                this.falseIndex = i;
                throw sfe;
            }
        }
        return true;
    }

    public boolean handleResponse(javax.xml.rpc.handler.MessageContext context) {
        int endIdx = this.size() - 1;
        if (this.falseIndex != -1) {
            endIdx = this.falseIndex;
        }
        for (int i = endIdx; i >= 0; --i) {
            if (this.getHandlerInstance(i).handleResponse(context)) continue;
            return false;
        }
        return true;
    }

    public void destroy() {
        int endIdx = this.size() - 1;
        if (this.falseIndex != -1) {
            endIdx = this.falseIndex;
        }
        for (int i = endIdx; i >= 0; --i) {
            this.getHandlerInstance(i).destroy();
        }
        this.falseIndex = -1;
        this.clear();
    }

    private Handler getHandlerInstance(int index) {
        return (Handler)this.get(index);
    }

    private HandlerInfo getHandlerInfo(int index) {
        return (HandlerInfo)this.handlerInfos.get(index);
    }

    private Handler newHandler(HandlerInfo handlerInfo) {
        try {
            Handler handler = (Handler)handlerInfo.getHandlerClass().newInstance();
            handler.init(handlerInfo);
            return handler;
        }
        catch (Exception ex) {
            String messageText = Messages.getMessage("NoJAXRPCHandler00", handlerInfo.getHandlerClass().toString());
            throw new JAXRPCException(messageText, (Throwable)ex);
        }
    }
}

