/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.Topic;
import org.globus.wsrf.TopicList;
import org.globus.wsrf.topicexpression.InvalidTopicExpressionException;
import org.globus.wsrf.topicexpression.TopicExpressionEvaluator;
import org.globus.wsrf.topicexpression.TopicExpressionException;
import org.globus.wsrf.topicexpression.TopicExpressionResolutionException;
import org.globus.wsrf.topicexpression.UnsupportedTopicExpressionDialectException;
import org.globus.wsrf.utils.Resources;
import org.oasis.wsn.TopicExpressionType;

public class SimpleTopicExpressionEvaluator
implements TopicExpressionEvaluator {
    static Log logger = LogFactory.getLog((String)SimpleTopicExpressionEvaluator.class.getName());
    private static I18n i18n = I18n.getI18n((String)Resources.class.getName());
    private static String[] dialects = new String[]{"http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple"};

    public Collection resolve(TopicExpressionType expression, TopicList topicList) throws UnsupportedTopicExpressionDialectException, TopicExpressionResolutionException, InvalidTopicExpressionException, TopicExpressionException {
        QName topicName = (QName)expression.getValue();
        logger.debug((Object)("Looking for topic with namespace: " + topicName.getNamespaceURI() + " and local part " + topicName.getLocalPart()));
        Vector<Topic> result = new Vector<Topic>();
        LinkedList<QName> topicPath = new LinkedList<QName>();
        topicPath.add(topicName);
        Topic topic = topicList.getTopic(topicPath);
        if (topic != null) {
            result.add(topic);
        }
        return result;
    }

    public String[] getDialects() {
        return dialects;
    }

    public List getConcreteTopicPath(TopicExpressionType expression) throws UnsupportedTopicExpressionDialectException, InvalidTopicExpressionException, TopicExpressionException {
        LinkedList<Object> result = new LinkedList<Object>();
        result.add(expression.getValue());
        return result;
    }

    public TopicExpressionType toTopicExpression(List topicPath) throws InvalidTopicExpressionException, TopicExpressionException {
        if (topicPath == null || topicPath.size() != 1) {
            throw new InvalidTopicExpressionException(i18n.getMessage("invalidSimpleTopicPath"));
        }
        TopicExpressionType result = null;
        try {
            result = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (Object)((QName)topicPath.get(0)));
        }
        catch (IOException e) {
            throw new TopicExpressionException("", e);
        }
        return result;
    }
}

