/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.ocsp;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ocsp.ResponseData;
import org.bouncycastle.asn1.ocsp.SingleResponse;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.ocsp.RespID;
import org.bouncycastle.ocsp.SingleResp;

public class RespData {
    ResponseData data;

    public RespData(ResponseData responseData) {
        this.data = responseData;
    }

    public int getVersion() {
        return this.data.getVersion().getValue().intValue() + 1;
    }

    public RespID getResponderId() {
        return new RespID(this.data.getResponderID());
    }

    public Date getProducedAt() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssz");
        return simpleDateFormat.parse(this.data.getProducedAt().getTime(), new ParsePosition(0));
    }

    public SingleResp[] getResponses() {
        ASN1Sequence aSN1Sequence = this.data.getResponses();
        SingleResp[] singleRespArray = new SingleResp[aSN1Sequence.size()];
        int n = 0;
        while (n != singleRespArray.length) {
            singleRespArray[n] = new SingleResp(SingleResponse.getInstance(aSN1Sequence.getObjectAt(n)));
            ++n;
        }
        return singleRespArray;
    }

    public X509Extensions getResponseExtensions() {
        return this.data.getResponseExtensions();
    }
}

