/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.signature;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.algorithms.MessageDigestAlgorithm;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Manifest;
import org.apache.xml.security.signature.ReferenceNotInitializedException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.InvalidTransformException;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.InclusiveNamespaces;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.DigesterOutputStream;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.IdResolver;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Reference
extends SignatureElementProxy {
    public static boolean CacheSignedNodes = false;
    static Log log = LogFactory.getLog((class$org$apache$xml$security$signature$Reference == null ? (class$org$apache$xml$security$signature$Reference = Reference.class$("org.apache.xml.security.signature.Reference")) : class$org$apache$xml$security$signature$Reference).getName());
    public static final String OBJECT_URI = "http://www.w3.org/2000/09/xmldsig#Object";
    public static final String MANIFEST_URI = "http://www.w3.org/2000/09/xmldsig#Manifest";
    Manifest _manifest = null;
    XMLSignatureInput _transformsOutput;
    static /* synthetic */ Class class$org$apache$xml$security$signature$Reference;

    protected Reference(Document document, String string, String string2, Manifest manifest, Transforms transforms, String string3) throws XMLSignatureException {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._baseURI = string;
        this._manifest = manifest;
        this.setURI(string2);
        if (transforms != null) {
            this._constructionElement.appendChild(transforms.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
        Object object = MessageDigestAlgorithm.getInstance(this._doc, string3);
        this._constructionElement.appendChild(((ElementProxy)object).getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
        object = XMLUtils.createElementInSignatureSpace(this._doc, "DigestValue");
        this._constructionElement.appendChild((Node)object);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    protected Reference(Element element, String string, Manifest manifest) throws XMLSecurityException {
        super(element, string);
        this._manifest = manifest;
    }

    public MessageDigestAlgorithm getMessageDigestAlgorithm() throws XMLSignatureException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "DigestMethod", 0);
        if (element == null) {
            return null;
        }
        String string = element.getAttributeNS(null, "Algorithm");
        if (string == null) {
            return null;
        }
        return MessageDigestAlgorithm.getInstance(this._doc, string);
    }

    public void setURI(String string) {
        if (this._state == 0 && string != null) {
            this._constructionElement.setAttributeNS(null, "URI", string);
        }
    }

    public String getURI() {
        return this._constructionElement.getAttributeNS(null, "URI");
    }

    public void setId(String string) {
        if (this._state == 0 && string != null) {
            this._constructionElement.setAttributeNS(null, "Id", string);
            IdResolver.registerElementById(this._constructionElement, string);
        }
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public void setType(String string) {
        if (this._state == 0 && string != null) {
            this._constructionElement.setAttributeNS(null, "Type", string);
        }
    }

    public String getType() {
        return this._constructionElement.getAttributeNS(null, "Type");
    }

    public boolean typeIsReferenceToObject() {
        return this.getType() != null && this.getType().equals(OBJECT_URI);
    }

    public boolean typeIsReferenceToManifest() {
        return this.getType() != null && this.getType().equals(MANIFEST_URI);
    }

    private void setDigestValueElement(byte[] byArray) {
        if (this._state == 0) {
            Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "DigestValue", 0);
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                element.removeChild(node);
            }
            String string = Base64.encode(byArray);
            Text text = this._doc.createTextNode(string);
            element.appendChild(text);
        }
    }

    public void generateDigestValue() throws XMLSignatureException, ReferenceNotInitializedException {
        if (this._state == 0) {
            this.setDigestValueElement(this.calculateDigest());
        }
    }

    public XMLSignatureInput getContentsBeforeTransformation() throws ReferenceNotInitializedException {
        try {
            Attr attr = this._constructionElement.getAttributeNodeNS(null, "URI");
            String string = attr == null ? null : attr.getNodeValue();
            ResourceResolver resourceResolver = ResourceResolver.getInstance(attr, this._baseURI, this._manifest._perManifestResolvers);
            if (resourceResolver == null) {
                Object[] objectArray = new Object[]{string};
                throw new ReferenceNotInitializedException("signature.Verification.Reference.NoInput", objectArray);
            }
            resourceResolver.addProperties(this._manifest._resolverProperties);
            XMLSignatureInput xMLSignatureInput = resourceResolver.resolve(attr, this._baseURI);
            return xMLSignatureInput;
        }
        catch (ResourceResolverException resourceResolverException) {
            throw new ReferenceNotInitializedException("empty", resourceResolverException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new ReferenceNotInitializedException("empty", xMLSecurityException);
        }
    }

    public XMLSignatureInput getTransformsInput() throws ReferenceNotInitializedException {
        XMLSignatureInput xMLSignatureInput;
        XMLSignatureInput xMLSignatureInput2 = this.getContentsBeforeTransformation();
        try {
            xMLSignatureInput = new XMLSignatureInput(xMLSignatureInput2.getBytes());
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new ReferenceNotInitializedException("empty", canonicalizationException);
        }
        catch (IOException iOException) {
            throw new ReferenceNotInitializedException("empty", iOException);
        }
        xMLSignatureInput.setSourceURI(xMLSignatureInput2.getSourceURI());
        return xMLSignatureInput;
    }

    private XMLSignatureInput getContentsAfterTransformation(XMLSignatureInput xMLSignatureInput, OutputStream outputStream) throws XMLSignatureException {
        try {
            Transforms transforms = this.getTransforms();
            XMLSignatureInput xMLSignatureInput2 = null;
            if (transforms != null) {
                this._transformsOutput = xMLSignatureInput2 = transforms.performTransforms(xMLSignatureInput, outputStream);
            } else {
                xMLSignatureInput2 = xMLSignatureInput;
            }
            return xMLSignatureInput2;
        }
        catch (ResourceResolverException resourceResolverException) {
            throw new XMLSignatureException("empty", resourceResolverException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new XMLSignatureException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new XMLSignatureException("empty", invalidCanonicalizerException);
        }
        catch (TransformationException transformationException) {
            throw new XMLSignatureException("empty", transformationException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    public XMLSignatureInput getContentsAfterTransformation() throws XMLSignatureException {
        XMLSignatureInput xMLSignatureInput = this.getContentsBeforeTransformation();
        return this.getContentsAfterTransformation(xMLSignatureInput, null);
    }

    public XMLSignatureInput getNodesetBeforeFirstCanonicalization() throws XMLSignatureException {
        try {
            XMLSignatureInput xMLSignatureInput;
            XMLSignatureInput xMLSignatureInput2 = xMLSignatureInput = this.getContentsBeforeTransformation();
            Transforms transforms = this.getTransforms();
            if (transforms != null) {
                Transform transform;
                String string;
                for (int i = 0; !(i >= transforms.getLength() || (string = (transform = transforms.item(i)).getURI()).equals("http://www.w3.org/2001/10/xml-exc-c14n#") || string.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments") || string.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") || string.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments")); ++i) {
                    xMLSignatureInput2 = transform.performTransform(xMLSignatureInput2, null);
                }
                xMLSignatureInput2.setSourceURI(xMLSignatureInput.getSourceURI());
            }
            return xMLSignatureInput2;
        }
        catch (IOException iOException) {
            throw new XMLSignatureException("empty", iOException);
        }
        catch (ResourceResolverException resourceResolverException) {
            throw new XMLSignatureException("empty", resourceResolverException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new XMLSignatureException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new XMLSignatureException("empty", invalidCanonicalizerException);
        }
        catch (TransformationException transformationException) {
            throw new XMLSignatureException("empty", transformationException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    public String getHTMLRepresentation() throws XMLSignatureException {
        try {
            XMLSignatureInput xMLSignatureInput = this.getNodesetBeforeFirstCanonicalization();
            Set set = new HashSet();
            Transforms transforms = this.getTransforms();
            ElementProxy elementProxy = null;
            if (transforms != null) {
                for (int i = 0; i < transforms.getLength(); ++i) {
                    Transform transform = transforms.item(i);
                    String string = transform.getURI();
                    if (!string.equals("http://www.w3.org/2001/10/xml-exc-c14n#") && !string.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments")) continue;
                    elementProxy = transform;
                    break;
                }
            }
            if (elementProxy != null && elementProxy.length("http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces") == 1) {
                InclusiveNamespaces inclusiveNamespaces = new InclusiveNamespaces(XMLUtils.selectNode(elementProxy.getElement().getFirstChild(), "http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces", 0), this.getBaseURI());
                set = InclusiveNamespaces.prefixStr2Set(inclusiveNamespaces.getInclusiveNamespaces());
            }
            return xMLSignatureInput.getHTMLRepresentation(set);
        }
        catch (TransformationException transformationException) {
            throw new XMLSignatureException("empty", transformationException);
        }
        catch (InvalidTransformException invalidTransformException) {
            throw new XMLSignatureException("empty", invalidTransformException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    public XMLSignatureInput getTransformsOutput() {
        return this._transformsOutput;
    }

    protected XMLSignatureInput dereferenceURIandPerformTransforms(OutputStream outputStream) throws XMLSignatureException {
        try {
            XMLSignatureInput xMLSignatureInput = this.getContentsBeforeTransformation();
            XMLSignatureInput xMLSignatureInput2 = this.getContentsAfterTransformation(xMLSignatureInput, outputStream);
            if (!CacheSignedNodes) {
                this._transformsOutput = xMLSignatureInput2;
            }
            return xMLSignatureInput2;
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new ReferenceNotInitializedException("empty", xMLSecurityException);
        }
    }

    public Transforms getTransforms() throws XMLSignatureException, InvalidTransformException, TransformationException, XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "Transforms", 0);
        if (element != null) {
            Transforms transforms = new Transforms(element, this._baseURI);
            return transforms;
        }
        return null;
    }

    public byte[] getReferencedBytes() throws ReferenceNotInitializedException, XMLSignatureException {
        try {
            XMLSignatureInput xMLSignatureInput = this.dereferenceURIandPerformTransforms(null);
            byte[] byArray = xMLSignatureInput.getBytes();
            return byArray;
        }
        catch (IOException iOException) {
            throw new ReferenceNotInitializedException("empty", iOException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new ReferenceNotInitializedException("empty", canonicalizationException);
        }
    }

    private byte[] calculateDigest() throws ReferenceNotInitializedException, XMLSignatureException {
        try {
            MessageDigestAlgorithm messageDigestAlgorithm = this.getMessageDigestAlgorithm();
            messageDigestAlgorithm.reset();
            DigesterOutputStream digesterOutputStream = new DigesterOutputStream(messageDigestAlgorithm);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(digesterOutputStream);
            XMLSignatureInput xMLSignatureInput = this.dereferenceURIandPerformTransforms(bufferedOutputStream);
            xMLSignatureInput.updateOutputStream(bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).flush();
            return digesterOutputStream.getDigestValue();
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new ReferenceNotInitializedException("empty", xMLSecurityException);
        }
        catch (IOException iOException) {
            throw new ReferenceNotInitializedException("empty", iOException);
        }
    }

    public byte[] getDigestValue() throws Base64DecodingException, XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "DigestValue", 0);
        if (element == null) {
            Object[] objectArray = new Object[]{"DigestValue", "http://www.w3.org/2000/09/xmldsig#"};
            throw new XMLSecurityException("signature.Verification.NoSignatureElement", objectArray);
        }
        byte[] byArray = Base64.decode(element);
        return byArray;
    }

    public boolean verify() throws ReferenceNotInitializedException, XMLSecurityException {
        byte[] byArray;
        byte[] byArray2 = this.getDigestValue();
        boolean bl = MessageDigestAlgorithm.isEqual(byArray2, byArray = this.calculateDigest());
        if (!bl) {
            log.warn("Verification failed for URI \"" + this.getURI() + "\"");
        } else {
            log.info("Verification successful for URI \"" + this.getURI() + "\"");
        }
        return bl;
    }

    public String getBaseLocalName() {
        return "Reference";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

