/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.PersistenceCallback;
import org.globus.wsrf.RemoveCallback;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.impl.DirtyFlagHolder;
import org.globus.wsrf.impl.PersistentResourceProperty;
import org.globus.wsrf.impl.ReflectionResource;
import org.globus.wsrf.utils.Resources;
import org.globus.wsrf.utils.XmlPersistenceHelper;

public abstract class PersistentReflectionResource
extends ReflectionResource
implements RemoveCallback,
PersistenceCallback,
DirtyFlagHolder {
    private static I18n i18n = I18n.getI18n(Resources.class.getName());
    private static Log logger = LogFactory.getLog(PersistentReflectionResource.class.getName());
    private boolean dirty = true;
    private XmlPersistenceHelper persistenceHelper;

    protected synchronized XmlPersistenceHelper getPersistenceHelper() {
        if (this.persistenceHelper == null) {
            try {
                this.persistenceHelper = new XmlPersistenceHelper(this.getResourceBeanClass());
            }
            catch (IOException e) {
                logger.error(i18n.getMessage("resourceInitError"), e);
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.persistenceHelper;
    }

    protected abstract Class getResourceBeanClass();

    public synchronized void load(ResourceKey key) throws ResourceException {
        this.getPersistenceHelper().load(key, this);
        this.setDirty(false);
    }

    public synchronized void store() throws ResourceException {
        if (!this.dirty) {
            if (logger.isDebugEnabled()) {
                logger.debug("Dirty flag not set: resource will not be stored");
            }
            return;
        }
        this.getPersistenceHelper().store(this);
        this.setDirty(false);
    }

    protected File getKeyAsFile(Object key) {
        return this.getPersistenceHelper().getKeyAsFile(key);
    }

    protected File getStorageDirectory() {
        return this.getPersistenceHelper().getStorageDirectory();
    }

    public void remove() throws ResourceException {
        this.getPersistenceHelper().remove(this);
    }

    protected ResourceProperty createNewResourceProperty(QName rpQName, Object resourceBean) throws Exception {
        ResourceProperty prop = super.createNewResourceProperty(rpQName, resourceBean);
        return new PersistentResourceProperty(prop, this);
    }

    public void setDirty(boolean changed) {
        this.dirty = changed;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public List getStoredResourceKeyValues() throws IOException {
        return this.getPersistenceHelper().list();
    }
}

