/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.security;

import java.rmi.Remote;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.rpc.Stub;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.common.core.security.impl.GSSSecurityCredentials;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.globus.gsi.GSIConstants;
import org.globus.wsrf.impl.security.authorization.HostAuthorization;
import org.ietf.jgss.GSSCredential;

public abstract class GCUBESecurityManagerImpl
implements GCUBESecurityManager {
    protected GCUBELog logger = new GCUBELog(this);
    protected Map<Thread, GSSCredential> callCredentials = Collections.synchronizedMap(new WeakHashMap());
    protected String name = this.getClass().getSimpleName();
    protected GCUBESecurityManager.AuthMethod authMethod = GCUBESecurityManager.AuthMethod.GSI_CONV;

    public void setLogger(GCUBELog logger) {
        this.logger = logger;
    }

    protected String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
        this.logger.setPrefix(name);
    }

    @Override
    public abstract boolean isSecurityEnabled();

    @Override
    @Deprecated
    public void useCredentials(GSSCredential credentials) throws Exception {
        this.useCredentials(Thread.currentThread(), credentials);
    }

    @Deprecated
    public void useCredentials(Thread thread, GSSCredential ... credentials) throws Exception {
        SecurityCredentials[] gssSecurityCredentials = new GSSSecurityCredentials[credentials.length];
        for (int y = 0; y < credentials.length; ++y) {
            gssSecurityCredentials[y] = new GSSSecurityCredentials(credentials[y]);
        }
        this.useCredentials(thread, gssSecurityCredentials);
    }

    @Override
    public void useCredentials(SecurityCredentials credentials) throws Exception {
        this.useCredentials(Thread.currentThread(), credentials);
    }

    @Override
    public void useCredentials(Thread thread, SecurityCredentials ... credentials) throws Exception {
        if (!this.isSecurityEnabled()) {
            return;
        }
        if (credentials.length == 0) {
            credentials = new SecurityCredentials[]{this.getCredentials()};
        }
        GSSCredential gssCredentials = (GSSCredential)credentials[0].getCredentialsAsObject();
        this.logger.debug("Using credentials of (" + gssCredentials.getName() + ") in thread " + thread.getName() + "(" + thread.getId() + ")");
        this.callCredentials.put(thread, gssCredentials);
    }

    @Override
    public SecurityCredentials getCredentials() {
        GSSCredential internalCred = this.callCredentials.get(Thread.currentThread());
        if (internalCred == null) {
            return null;
        }
        return new GSSSecurityCredentials(internalCred);
    }

    @Override
    public synchronized void setSecurity(Remote s, GCUBESecurityManager.AuthMode e, GCUBESecurityManager.DelegationMode d) throws Exception {
        if (!this.isSecurityEnabled()) {
            return;
        }
        Stub stub = (Stub)s;
        stub._setProperty("org.globus.gsi.credentials", (Object)this.getCredentials());
        stub._setProperty("org.globus.security.context.lifetime", (Object)300);
        String authMethodString = null;
        switch (this.authMethod) {
            case GSI_CONV: {
                authMethodString = "org.globus.security.secConv.msg.type";
                break;
            }
            case GSI_TRANS: {
                authMethodString = "org.globus.security.transport.type";
            }
        }
        switch (e) {
            case INTEGRITY: {
                stub._setProperty(authMethodString, (Object)GSIConstants.SIGNATURE);
                break;
            }
            case PRIVACY: {
                stub._setProperty(authMethodString, (Object)GSIConstants.ENCRYPTION);
                break;
            }
            case BOTH: {
                stub._setProperty(authMethodString, (Object)GSIConstants.SIGNATURE);
                stub._setProperty(authMethodString, (Object)GSIConstants.ENCRYPTION);
            }
        }
        switch (d) {
            case FULL: {
                stub._setProperty("org.globus.security.authorization", (Object)HostAuthorization.getInstance());
                stub._setProperty("org.globus.gsi.mode", (Object)"gsifull");
                break;
            }
            case LIMITED: {
                stub._setProperty("org.globus.security.authorization", (Object)HostAuthorization.getInstance());
                stub._setProperty("org.globus.gsi.mode", (Object)"gsilimited");
            }
        }
        this.logger.debug("Setting authentication=" + e.name() + " and delegation=" + d.name() + " on " + stub.getClass().getSimpleName());
    }

    @Override
    public void setAuthMethod(GCUBESecurityManager.AuthMethod m) {
        this.authMethod = m;
    }
}

