/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.ghnmanager.impl;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.gcube.common.core.contexts.GCUBEContext;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.informationsystem.publisher.ISPublisher;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.ServiceMap;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vremanagement.ghnmanager.impl.contexts.ServiceContext;
import org.gcube.common.vremanagement.ghnmanager.impl.platforms.Finder;
import org.gcube.common.vremanagement.ghnmanager.impl.platforms.GHNPlatforms;
import org.gcube.common.vremanagement.ghnmanager.impl.platforms.PlatformApplication;
import org.gcube.common.vremanagement.ghnmanager.impl.platforms.PlatformCall;
import org.gcube.common.vremanagement.ghnmanager.stubs.AddScopeInputParams;
import org.gcube.common.vremanagement.ghnmanager.stubs.RIData;
import org.gcube.common.vremanagement.ghnmanager.stubs.ScopeRIParams;
import org.gcube.common.vremanagement.ghnmanager.stubs.ShutdownOptions;
import org.gcube.vremanagement.virtualplatform.image.PlatformConfiguration;
import org.gcube.vremanagement.virtualplatform.image.Platforms;
import org.gcube.vremanagement.virtualplatform.image.VirtualPlatform;

public class GHNManager
extends GCUBEPortType {
    protected final GCUBELog logger = new GCUBELog((Object)this, (GCUBEContext)ServiceContext.getContext());

    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public boolean addScope(AddScopeInputParams params) throws GCUBEUnrecoverableFault {
        this.logger.info((Object)("Adding scope " + params.getScope() + " to the GHN"));
        try {
            GCUBEScope scope = GCUBEScope.getScope((String)params.getScope());
            ServiceMap map = new ServiceMap();
            if (params.getMap() == null || params.getMap().compareToIgnoreCase("") == 0) {
                if (scope.getType() == GCUBEScope.Type.VO) {
                    map.load((Reader)new FileReader(GHNContext.getContext().getGHN().getMapFile(scope)));
                } else {
                    map.load((Reader)new FileReader(GHNContext.getContext().getGHN().getMapFile(scope.getEnclosingScope())));
                }
            } else {
                map.load((Reader)new StringReader(params.getMap()));
                new FileWriter(GHNContext.getContext().getGHN().getMapFile(scope)).close();
            }
            GHNContext.getContext().addScope(new GCUBEScope[]{scope});
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to assign the scope " + params.getScope() + " to this GHN"), (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Unable to assign the scope " + params.getScope() + " to this GHN: " + e.getMessage()});
        }
        return true;
    }

    public boolean removeScope(String scope) throws GCUBEUnrecoverableFault {
        this.logger.info((Object)("Removing scope " + scope + " from GHN"));
        try {
            GCUBEScope targetScope = GCUBEScope.getScope((String)scope);
            ((ISPublisher)GHNContext.getImplementation(ISPublisher.class)).removeGCUBEResource(GHNContext.getContext().getGHN().getID(), "GHN", targetScope, (GCUBESecurityManager)ServiceContext.getContext());
            GHNContext.getContext().removeScope(new GCUBEScope[]{targetScope});
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to remove the scope " + scope + " from this GHN"), (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Unable to remove the scope " + scope + " from this GHN: " + e.getMessage()});
        }
        return true;
    }

    public boolean addRIToScope(ScopeRIParams params) throws GCUBEUnrecoverableFault, GCUBEFault {
        this.logger.info((Object)("Adding scope " + params.getScope() + " to RI <" + params.getClazz() + "," + params.getName() + ">"));
        try {
            GHNContext.getContext().getServiceContext(params.getClazz(), params.getName()).addScope(new GCUBEScope[]{GCUBEScope.getScope((String)params.getScope())});
        }
        catch (Exception e) {
            this.logger.debug((Object)"Checking the RI in the local virtual platforms");
            try {
                GCUBERunningInstance instance = GHNContext.getContext().getLocalInstanceContext().getInstance(params.getClazz(), params.getName());
                VirtualPlatform platform = Finder.find(instance.getPlatform());
                if (platform.isAvailable()) {
                    PlatformApplication app = new PlatformApplication(instance);
                    instance.addScope(new GCUBEScope[]{GCUBEScope.getScope((String)params.getScope())});
                    app.publish(instance.getScopes().values(), (GCUBESecurityManager)ServiceContext.getContext(), GCUBEServiceContext.Status.READIED);
                    GHNContext.getContext().getLocalInstanceContext().registerInstance(instance);
                }
            }
            catch (Exception e1) {
                this.logger.warn((Object)("unable to find an instance of service " + params.getClazz() + ", " + params.getName()), (Throwable)e1);
                throw new GCUBEUnrecoverableFault(new String[]{"unable to find an instance of service " + params.getClazz() + ", " + params.getName()});
            }
        }
        return true;
    }

    public boolean activateRI(RIData ri) throws GCUBEUnrecoverableFault, GCUBEFault {
        this.logger.info((Object)("Activating RI <" + ri.getClazz() + "," + ri.getName() + ">"));
        try {
            GHNContext.getContext().getServiceContext(ri.getClazz(), ri.getName()).setStatus(GCUBEServiceContext.Status.READIED);
        }
        catch (Exception e) {
            this.logger.debug((Object)"Checking the RI in the local virtual platforms");
            try {
                GCUBERunningInstance instance = GHNContext.getContext().getLocalInstanceContext().getInstance(ri.getClazz(), ri.getName());
                VirtualPlatform platform = Finder.find(instance.getPlatform());
                if (platform.isAvailable()) {
                    PlatformCall call = new PlatformCall(platform);
                    PlatformApplication app = call.activate(instance);
                    app.publish(instance.getScopes().values(), (GCUBESecurityManager)ServiceContext.getContext(), GCUBEServiceContext.Status.READIED);
                    GHNContext.getContext().getLocalInstanceContext().registerInstance(instance);
                }
            }
            catch (Exception e1) {
                this.logger.warn((Object)("unable to find an instance of service " + ri.getClazz() + ", " + ri.getName()), (Throwable)e1);
                throw new GCUBEUnrecoverableFault(new String[]{"unable to find an instance of service " + ri.getClazz() + ", " + ri.getName()});
            }
        }
        return true;
    }

    public boolean deactivateRI(RIData ri) throws GCUBEUnrecoverableFault, GCUBEFault {
        this.logger.info((Object)("Deactivating RI <" + ri.getClazz() + "," + ri.getName() + ">"));
        try {
            GHNContext.getContext().getServiceContext(ri.getClazz(), ri.getName()).setStatus(GCUBEServiceContext.Status.DOWN);
        }
        catch (Exception e) {
            this.logger.debug((Object)"Checking the RI in the local virtual platforms");
            try {
                GCUBERunningInstance instance = GHNContext.getContext().getLocalInstanceContext().getInstance(ri.getClazz(), ri.getName());
                this.logger.debug((Object)("RI found in platform  " + instance.getPlatform().getName()));
                VirtualPlatform platform = Finder.find(instance.getPlatform());
                if (platform.isAvailable()) {
                    this.logger.debug((Object)("Platform " + platform.getName() + " is available"));
                    PlatformCall call = new PlatformCall(platform);
                    PlatformApplication app = call.deactivate(instance);
                    app.publish(instance.getScopes().values(), (GCUBESecurityManager)ServiceContext.getContext(), GCUBEServiceContext.Status.DOWN);
                    GHNContext.getContext().getLocalInstanceContext().registerInstance(instance);
                }
            }
            catch (Exception e1) {
                this.logger.warn((Object)("unable to find an instance of service " + ri.getClazz() + ", " + ri.getName()), (Throwable)e1);
                throw new GCUBEUnrecoverableFault(new String[]{"unable to find an instance of service " + ri.getClazz() + ", " + ri.getName()});
            }
        }
        return true;
    }

    public boolean removeRIFromScope(ScopeRIParams params) throws GCUBEUnrecoverableFault, GCUBEFault {
        this.logger.info((Object)("Removing scope " + params.getScope() + " to RI <" + params.getClazz() + "," + params.getName() + ">"));
        try {
            GHNContext.getContext().getServiceContext(params.getClazz(), params.getName()).removeScope(new GCUBEScope[]{GCUBEScope.getScope((String)params.getScope())});
        }
        catch (GCUBEException e) {
            this.logger.debug((Object)"Checking the RI in the local virtual platforms");
            try {
                GCUBERunningInstance instance = GHNContext.getContext().getLocalInstanceContext().getInstance(params.getClazz(), params.getName());
                VirtualPlatform platform = Finder.find(instance.getPlatform());
                if (platform.isAvailable()) {
                    PlatformApplication app = new PlatformApplication(instance);
                    instance.removeScope(new GCUBEScope[]{GCUBEScope.getScope((String)params.getScope())});
                    app.publish(instance.getScopes().values(), (GCUBESecurityManager)ServiceContext.getContext(), GCUBEServiceContext.Status.READIED);
                    GHNContext.getContext().getLocalInstanceContext().registerInstance(instance);
                }
            }
            catch (Exception e1) {
                this.logger.warn((Object)("unable to find an instance of service " + params.getClazz() + ", " + params.getName()), (Throwable)e1);
                throw new GCUBEUnrecoverableFault(new String[]{"unable to find an instance of service " + params.getClazz() + ", " + params.getName()});
            }
        }
        catch (Exception e) {
            throw ServiceContext.getContext().getDefaultException(e.getMessage(), e).toFault(new String[0]);
        }
        return true;
    }

    public void shutdown(ShutdownOptions options) throws GCUBEUnrecoverableFault {
        this.logger.info((Object)"Remote request for shutting down the gHN received");
        this.logger.trace((Object)("Shutting down from " + GHNContext.getContext().getStatus().name()));
        List configurations = Platforms.listAvailablePlatforms((File)new File(GHNContext.getContext().getVirtualPlatformsLocation()));
        for (PlatformConfiguration config : configurations) {
            try {
                new PlatformCall(GHNPlatforms.get(config)).shutdown();
            }
            catch (Exception e) {
                this.logger.warn((Object)("Unable to shutdown platform " + config.getName()), (Throwable)e);
            }
        }
        try {
            if (options.isRestart()) {
                if (options.getClean().booleanValue()) {
                    new Thread(){

                        @Override
                        public void run() {
                            GHNContext.getContext().restartAndClean(new String[0]);
                        }
                    }.start();
                } else {
                    new Thread(){

                        @Override
                        public void run() {
                            GHNContext.getContext().restart(new String[0]);
                        }
                    }.start();
                }
            } else {
                new Thread(){

                    @Override
                    public void run() {
                        GHNContext.getContext().shutdown(new String[0]);
                    }
                }.start();
            }
        }
        catch (Exception e) {
            throw new GCUBEUnrecoverableFault(new String[]{"unable to shutdown the container"});
        }
    }
}

