/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import ise.antelope.tasks.CatchTask;
import ise.antelope.tasks.FinallyTask;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;

public class TryTask
extends Task
implements TaskContainer {
    private Vector tasks = new Vector();
    private Task catchTask = null;
    private Task finallyTask = null;
    private boolean doBreak = true;
    private boolean doPrintMessage = true;
    private String messageProperty = null;
    private boolean doPrintStackTrace = false;
    private String stackTraceProperty = null;

    public void init() {
        this.getProject().addTaskDefinition("catch", CatchTask.class);
        this.getProject().addTaskDefinition("finally", FinallyTask.class);
    }

    public void maybeConfigure() throws BuildException {
        if (this.isInvalid()) {
            super.maybeConfigure();
        } else {
            this.getRuntimeConfigurableWrapper().maybeConfigure(this.getProject(), false);
        }
    }

    public void addTask(Task task) {
        if (task instanceof CatchTask) {
            if (this.catchTask == null) {
                this.catchTask = task;
                return;
            }
            throw new BuildException("Only one Catch allowed per Try.");
        }
        if (task instanceof FinallyTask) {
            if (this.finallyTask == null) {
                this.finallyTask = task;
                return;
            }
            throw new BuildException("Only one Finally allowed per Try.");
        }
        this.tasks.addElement(task);
    }

    public void addCatch(CatchTask task) {
        this.addTask(task);
    }

    public void addFinally(FinallyTask task) {
        this.addTask(task);
    }

    public void setBreak(boolean b) {
        this.doBreak = b;
    }

    public void setPrintmessage(boolean b) {
        this.doPrintMessage = b;
    }

    public void setMessageproperty(String name) {
        this.messageProperty = name;
    }

    public void setPrintstacktrace(boolean b) {
        this.doPrintStackTrace = b;
    }

    public void setStacktraceproperty(String name) {
        this.stackTraceProperty = name;
    }

    public void execute() throws BuildException {
        Throwable be = null;
        Enumeration e = this.tasks.elements();
        while (e.hasMoreElements()) {
            Task task = (Task)e.nextElement();
            try {
                task.perform();
            }
            catch (Throwable throwable) {
                block19: {
                    PrintWriter writer;
                    StringWriter stacktrace;
                    be = throwable;
                    if (this.messageProperty != null) {
                        this.getProject().setProperty(this.messageProperty, throwable.getMessage());
                    }
                    if (this.stackTraceProperty != null) {
                        stacktrace = new StringWriter();
                        writer = new PrintWriter((Writer)stacktrace, true);
                        throwable.printStackTrace(writer);
                        this.getProject().setProperty(this.stackTraceProperty, stacktrace.toString());
                    }
                    if (this.doPrintStackTrace) {
                        try {
                            this.log("Task '" + task.getTaskName() + "' in target '" + (task.getOwningTarget() == null ? "unknown" : task.getOwningTarget().getName()) + "' failed, task stack trace follows:");
                            stacktrace = new StringWriter();
                            writer = new PrintWriter((Writer)stacktrace, true);
                            throwable.printStackTrace(writer);
                            this.log(stacktrace.toString());
                        }
                        catch (Exception ignored) {}
                    } else if (this.doPrintMessage) {
                        try {
                            this.log("Task '" + task.getTaskName() + "' in target '" + (task.getOwningTarget() == null ? "unknown" : task.getOwningTarget().getName()) + "' failed, error message is: " + throwable.getMessage());
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                    }
                    if (this.catchTask != null) {
                        try {
                            this.catchTask.perform();
                        }
                        catch (Throwable t) {
                            if (this.finallyTask != null) {
                                try {
                                    this.finallyTask.perform();
                                    break block19;
                                }
                                catch (Exception eeee) {
                                    throw new BuildException(be.getMessage(), new BuildException(eeee.getMessage(), t));
                                }
                            }
                            throw new BuildException(be.getMessage(), t);
                        }
                    }
                }
                if (!this.doBreak) continue;
                break;
            }
        }
        if (this.finallyTask != null) {
            this.finallyTask.perform();
        }
    }
}

