/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.trust2;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;

public abstract class TrustConstants {
    private static final String NS_YEAR_PREFIX = "http://schemas.xmlsoap.org/ws/2004/04/";
    public static final String WST_NS = "http://schemas.xmlsoap.org/ws/2004/04/trust";
    public static final String WST_PREFIX = "wst:";
    public static final String REQUEST_TAG = "RequestSecurityToken";
    public static final QName REQUEST_NAME = new QName("http://schemas.xmlsoap.org/ws/2004/04/trust", "RequestSecurityToken", "wst:");
    public static final String CONTEXT_ATTR = "Context";
    public static final String TOKEN_TYPE = "TokenType";
    public static final String REQUEST_TYPE = "RequestType";
    public static final String BASE = "Base";
    public static final String SUPPORTING = "Supporting";
    public static final String LIFETIME = "Lifetime";
    public static final String LIFETIME_MS = "LifeTime";
    public static final boolean MS_COMPATIBLE_LIFETIMES = true;
    public static final String RESPONSE_TAG = "RequestSecurityTokenResponse";
    public static final QName RESPONSE_NAME = new QName("http://schemas.xmlsoap.org/ws/2004/04/trust", "RequestSecurityTokenResponse", "wst:");
    public static final String REQUESTED_TOKEN = "RequestedSecurityToken";
    public static final String REQUESTED_PROOF = "RequestedProofToken";
    public static final String WSA_NS = "http://schemas.xmlsoap.org/ws/2004/03/addressing";
    public static final String WSA_PREFIX = "wsa:";
    public static final String ACTION_TAG = "Action";
    private static final String SECURITY_TRUST_PREFIX = "http://schemas.xmlsoap.org/ws/2004/04/security/trust/";
    public static URI REQUEST_ISSUE;
    public static URI REQUEST_RENEW;
    public static URI REQUEST_VALIDATE;
    private static final String ACTION_REQUEST_PREFIX = "http://schemas.xmlsoap.org/ws/2004/04/security/trust/RST/";
    public static URI ACTION_REQUEST_ISSUE;
    public static URI ACTION_REQUEST_RENEW;
    public static URI ACTION_REQUEST_VALIDATE;
    private static final String ACTION_RESPONSE_PREFIX = "http://schemas.xmlsoap.org/ws/2004/04/security/trust/RSTR/";
    public static URI ACTION_RESPONSE_ISSUE;
    public static URI ACTION_RESPONSE_RENEW;
    public static URI ACTION_RESPONSE_VALIDATE;

    public static URI getActionRequest(URI requestType) {
        if (REQUEST_ISSUE.equals(requestType)) {
            return ACTION_REQUEST_ISSUE;
        }
        if (REQUEST_ISSUE.equals(requestType)) {
            return ACTION_REQUEST_RENEW;
        }
        if (REQUEST_ISSUE.equals(requestType)) {
            return ACTION_REQUEST_VALIDATE;
        }
        return requestType;
    }

    static {
        try {
            REQUEST_ISSUE = new URI("http://schemas.xmlsoap.org/ws/2004/04/security/trust/Issue");
            REQUEST_RENEW = new URI("http://schemas.xmlsoap.org/ws/2004/04/security/trust/Renew");
            REQUEST_VALIDATE = new URI("http://schemas.xmlsoap.org/ws/2004/04/security/trust/Validate");
            ACTION_REQUEST_ISSUE = new URI("http://schemas.xmlsoap.org/ws/2004/04/security/trust/RST/Issue");
            ACTION_REQUEST_RENEW = new URI("http://schemas.xmlsoap.org/ws/2004/04/security/trust/RST/Renew");
            ACTION_REQUEST_VALIDATE = new URI("http://schemas.xmlsoap.org/ws/2004/04/security/trust/RST/Validate");
            ACTION_RESPONSE_ISSUE = new URI("http://schemas.xmlsoap.org/ws/2004/04/security/trust/RSTR/Issue");
            ACTION_RESPONSE_RENEW = new URI("http://schemas.xmlsoap.org/ws/2004/04/security/trust/RSTR/Renew");
            ACTION_RESPONSE_VALIDATE = new URI("http://schemas.xmlsoap.org/ws/2004/04/security/trust/RSTR/Validate");
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }
}

