/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.informationsystem.client.impl;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.QueryParameter;
import org.kxml2.io.KXmlParser;

public abstract class AbstractQuery<RESULT>
implements ISQuery<RESULT> {
    protected Map<String, String> parameters = Collections.synchronizedMap(new HashMap());
    long ttl = 100000L;
    protected String expression;

    @Override
    public long getTTL() {
        return this.ttl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getExpression() {
        try {
            StringBuilder builder = new StringBuilder();
            KXmlParser parser = new KXmlParser();
            parser.setInput((Reader)new StringReader(this.expression));
            while (true) {
                int tokenType = parser.next();
                switch (tokenType) {
                    case 2: {
                        String name = parser.getName();
                        String value = this.parameters.get(name);
                        if (value != null) {
                            builder.append(value);
                            break;
                        }
                        String replacement = parser.getAttributeValue(null, "ISdefault");
                        if (replacement != null) {
                            this.parameters.put(name, replacement);
                            break;
                        }
                        builder.append("<" + name + ">");
                        break;
                    }
                    case 4: {
                        builder.append(parser.getText());
                        break;
                    }
                    case 3: {
                        String name = parser.getName();
                        if (this.parameters.get(name) != null) break;
                        builder.append("</" + name + ">");
                        break;
                    }
                    case 1: {
                        return builder.toString();
                    }
                }
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setTTL(long ttl) {
        this.ttl = ttl;
    }

    @Override
    public void setExpression(String exp) {
        this.expression = exp;
    }

    public void addParameters(QueryParameter ... parameters) {
        if (parameters == null) {
            return;
        }
        for (QueryParameter parameter : parameters) {
            this.parameters.put(parameter.name, parameter.value);
        }
    }

    protected boolean isWellFormed() {
        return this.getExpression() != null;
    }

    protected abstract RESULT parseResult(String var1) throws ISClient.ISMalformedResultException;
}

