/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.descriptor;

import javax.xml.namespace.QName;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.descriptor.RunAsConstants;
import org.globus.wsrf.impl.security.descriptor.RunAsParserCallback;
import org.globus.wsrf.impl.security.descriptor.SecurityDescriptorException;
import org.globus.wsrf.impl.security.descriptor.util.ElementHandler;
import org.globus.wsrf.impl.security.descriptor.util.ElementParser;
import org.globus.wsrf.impl.security.descriptor.util.ElementParserException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RunAsParser
implements ElementHandler,
RunAsConstants {
    private static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.descriptor.errors");
    public static final QName QNAME = new QName("http://www.globus.org", "run-as");
    private static final QName CALLER_QNAME = new QName("http://www.globus.org", "caller-identity");
    private static final QName SYSTEM_QNAME = new QName("http://www.globus.org", "system-identity");
    private static final QName SERVICE_QNAME = new QName("http://www.globus.org", "service-identity");
    private static final QName RESOURCE_QNAME = new QName("http://www.globus.org", "resource-identity");
    protected RunAsParserCallback callback;

    public RunAsParser(RunAsParserCallback callback) {
        this.callback = callback;
    }

    public void parse(Element elem) throws ElementParserException {
        ElementParser.checkElement(elem, QNAME);
        Node child = ElementParser.getFirstChildElement(elem);
        QName name = ElementParser.getQName(child);
        if (name.equals(CALLER_QNAME)) {
            this.callback.setRunAsType(1);
        } else if (name.equals(SYSTEM_QNAME)) {
            this.callback.setRunAsType(2);
        } else if (name.equals(SERVICE_QNAME)) {
            this.callback.setRunAsType(3);
        } else if (name.equals(RESOURCE_QNAME)) {
            this.callback.setRunAsType(4);
        } else {
            throw new SecurityDescriptorException(i18n.getMessage("badRunAs", (Object)name));
        }
    }
}

