/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.random;

final class StatisticalTests {
    private static final int[] ONE_COUNT = new int[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};

    public static boolean looksRandom(byte[] data) {
        return StatisticalTests.testMonobit(data) && StatisticalTests.testPoker(data);
    }

    public static boolean testMonobit(byte[] data) {
        if (data.length != 2500) {
            throw new IllegalArgumentException("2500 bytes expected");
        }
        int total = 0;
        int i = 0;
        while (i < 2500) {
            int hi = ONE_COUNT[data[i] >> 4 & 0xF];
            int lo = ONE_COUNT[data[i] & 0xF];
            total += hi + lo;
            ++i;
        }
        return 9654 < total && total < 10346;
    }

    public static boolean testPoker(byte[] data) {
        if (data.length != 2500) {
            throw new IllegalArgumentException("2500 bytes expected");
        }
        int[] b = new int[16];
        int i = 0;
        while (i < data.length) {
            int n = data[i] & 0xF;
            b[n] = b[n] + 1;
            int n2 = data[i] >>> 4 & 0xF;
            b[n2] = b[n2] + 1;
            ++i;
        }
        int sigma = 0;
        int i2 = 0;
        while (i2 < 16) {
            sigma += b[i2] * b[i2];
            ++i2;
        }
        float res = 16.0f * (float)sigma / 5000.0f - 5000.0f;
        return 1.03f < res && res < 57.4f;
    }

    private StatisticalTests() {
    }
}

