/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.instancestates;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.informationsystem.publisher.impl.generic.GCUBEGenericBulkPublisher;
import org.gcube.common.informationsystem.publisher.impl.instancestates.InstanceResource;
import org.gcube.common.informationsystem.publisher.impl.instancestates.WSRPDocument;
import org.gcube.common.informationsystem.publisher.impl.registrations.handlers.BaseISPublisherHandler;
import org.gcube.informationsystem.collector.stubs.metadata.MetadataRecord;
import org.gcube.informationsystem.collector.stubs.metadata.MetadataWriter;
import org.w3c.dom.Document;

abstract class BaseInstanceStateHandler
extends BaseISPublisherHandler {
    protected final GCUBEWSResource resource;
    protected String[] name;
    protected GCUBEScope publishingScope;
    protected WSRPDocument rpd;
    protected Document metadata;
    protected static final String providerRPPrefix = "provider";
    protected static final String RPD_COLLECTION_NAME = "gcube://Properties";

    public BaseInstanceStateHandler(GCUBEWSResource resource, GCUBEScope scope, String mode, String ... name) throws Exception {
        this.resource = resource;
        this.name = name;
        this.publishingScope = scope;
        this.rpd = new WSRPDocument(resource);
        this.metadata = this.getMetadata(this.rpd, mode).getAsDocument();
        logger.trace((Object)("Instance state handler created for resource " + this.rpd.getID() + " in scope " + this.publishingScope));
    }

    @Override
    public String getResourceID() {
        return ((GCUBEWSResourceKey)this.resource.getID()).toString();
    }

    public String getResourceName() {
        return this.rpd.getName();
    }

    protected MetadataRecord getMetadata(WSRPDocument rpd, String mode) throws Exception {
        return new MetadataWriter(MetadataRecord.TYPE.INSTANCESTATE, rpd.getSource(), Integer.valueOf(rpd.getPollingInterval() * 3 / 1000), "", rpd.getSourceID(), "", rpd.getNamespace(), mode).getRecord();
    }

    protected void register() throws Exception {
        String resourceLog = this.rpd.getName();
        logger.info((Object)("ISPublisher is going to publish the Resource Property document from " + resourceLog + ":\n" + this.rpd));
        try {
            GCUBEGenericBulkPublisher publisher = new GCUBEGenericBulkPublisher();
            publisher.register(InstanceResource.fromGCUBEWSResource(this.rpd), this.publishingScope, this.metadata);
        }
        catch (Exception e) {
            throw new Exception("Unable to read RPs from the WSResource " + resourceLog, e);
        }
    }
}

