/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.proxy.local;

import gr.uoa.di.madgik.grs.GRS2Exception;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.GRS2ProxyInvalidArgumentException;
import gr.uoa.di.madgik.grs.proxy.GRS2ProxyInvalidOperationException;
import gr.uoa.di.madgik.grs.proxy.IProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalReaderProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.store.buffer.BufferStoreReader;
import java.net.URI;

public class LocalStoreReaderProxy
extends LocalReaderProxy {
    private boolean storeContacted = false;

    @Override
    public void fromLocator(URI locator) throws GRS2ProxyInvalidArgumentException, GRS2ProxyInvalidOperationException {
        BufferStoreReader storeReader = null;
        try {
            if (this.storeContacted) {
                super.fromLocator(locator);
            } else {
                this.storeContacted = true;
                if (locator == null) {
                    throw new GRS2ProxyInvalidArgumentException("Locator cannot be null");
                }
                if (!LocalStoreReaderProxy.isOfType(locator)) {
                    throw new GRS2ProxyInvalidArgumentException("Locator is not of appropriate type " + locator.toString());
                }
                String[] qs = locator.getQuery().trim().split("=");
                if (qs.length != 2) {
                    throw new GRS2ProxyInvalidArgumentException("Invalid query string in locator " + locator.toString());
                }
                if (qs[1].trim().length() == 0) {
                    throw new GRS2ProxyInvalidArgumentException("Invalid key in locator " + locator.toString());
                }
                String key = qs[1];
                LocalWriterProxy newProxy = new LocalWriterProxy();
                storeReader = new BufferStoreReader(key, newProxy);
                URI storeAccessLocator = storeReader.populate();
                this.fromLocator(storeAccessLocator);
            }
        }
        catch (GRS2Exception ex) {
            if (storeReader != null) {
                try {
                    storeReader.dispose();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            throw new GRS2ProxyInvalidOperationException("Could not initialize proxy", ex);
        }
    }

    @Override
    public IBuffer getBuffer() throws GRS2ProxyInvalidOperationException {
        if (!this.storeContacted) {
            throw new GRS2ProxyInvalidOperationException("Method not supported for this proxy type");
        }
        return super.getBuffer();
    }

    public static boolean isOfType(URI locator) {
        if (!locator.getScheme().equalsIgnoreCase("grs2-store-proxy".toString())) {
            return false;
        }
        return locator.getFragment().equalsIgnoreCase(IProxy.ProxyType.LocalStore.toString());
    }
}

