/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.state;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.GCUBEHostingNode;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSFieldsSerializableResource;
import org.gcube.common.vremanagement.deployer.impl.operators.common.Report;
import org.gcube.common.vremanagement.deployer.impl.resources.BasePackage;
import org.gcube.common.vremanagement.deployer.impl.resources.BaseTypedPackage;
import org.gcube.common.vremanagement.deployer.impl.resources.Converter;
import org.gcube.common.vremanagement.deployer.impl.resources.KeyData;
import org.gcube.common.vremanagement.deployer.impl.state.CountableHashMap;
import org.gcube.common.vremanagement.deployer.impl.state.CountableHashSet;
import org.gcube.common.vremanagement.deployer.stubs.deployer.DeployedPackage;

public class DeployerResource
extends GCUBEWSFieldsSerializableResource {
    private static final long serialVersionUID = 1432537954905035439L;
    protected static final String NumPackagesRP = "NumberOfDeployedPackages";
    protected static final String DeployedPackagesRP = "DeployedPackages";
    protected static final String LastDeploymentRP = "LastDeployment";
    static final String[] RPNames = new String[]{"DeployedPackages", "LastDeployment"};
    List<DeployedPackage> packages = new ArrayList<DeployedPackage>();
    int numOfDeployedPackages = 0;
    private CountableHashMap<KeyData, BaseTypedPackage> packageinfo = new CountableHashMap();
    private CountableHashSet<File> filelist = new CountableHashSet();
    private List<Serializable> objsToSerialize = new ArrayList<Serializable>();

    protected synchronized void initialise(Object ... arg0) throws Exception {
        this.objsToSerialize.add(this.packageinfo);
        this.objsToSerialize.add(this.filelist);
        this.setDeployedPackages(new DeployedPackage[0]);
        this.printState();
    }

    protected String[] getPropertyNames() {
        return RPNames;
    }

    public synchronized List<? extends Serializable> getFieldsToSerialize() {
        return this.objsToSerialize;
    }

    public synchronized void setFieldsToSerialize(List<? extends Serializable> objs) {
        this.objsToSerialize = (ArrayList)objs;
        this.packageinfo = (CountableHashMap)this.objsToSerialize.get(0);
        this.objsToSerialize.set(0, this.packageinfo);
        this.filelist = (CountableHashSet)this.objsToSerialize.get(1);
        this.objsToSerialize.set(1, this.filelist);
    }

    public synchronized void setLastDeployment(String lastDeployment) {
        this.getResourcePropertySet().get(LastDeploymentRP).clear();
        this.getResourcePropertySet().get(LastDeploymentRP).add((Object)lastDeployment);
    }

    public synchronized void clearLastDeployment() {
        this.getResourcePropertySet().get(LastDeploymentRP).clear();
    }

    public synchronized String getLastDeployment() {
        if (this.getResourcePropertySet().get(LastDeploymentRP) != null && this.getResourcePropertySet().get(LastDeploymentRP).size() > 0) {
            return (String)this.getResourcePropertySet().get(LastDeploymentRP).get(0);
        }
        return "";
    }

    public synchronized DeployedPackage[] getDeployedPackages() {
        if (this.getResourcePropertySet().get(DeployedPackagesRP) != null && this.getResourcePropertySet().get(DeployedPackagesRP).size() > 0) {
            this.packages = (List)this.getResourcePropertySet().get(DeployedPackagesRP).get(0);
            return this.packages.toArray(new DeployedPackage[this.packages.size()]);
        }
        return new DeployedPackage[0];
    }

    public synchronized void setDeployedPackages(DeployedPackage[] packages) {
        this.packages = new ArrayList<DeployedPackage>(packages.length);
        for (int i = 0; i < packages.length; ++i) {
            this.packages.add(packages[i]);
        }
        this.getResourcePropertySet().get(DeployedPackagesRP).clear();
        this.getResourcePropertySet().get(DeployedPackagesRP).add(this.packages);
    }

    public synchronized void addPackage(BaseTypedPackage pack) {
        this.packages.add(Converter.toDeployablePackage(pack));
        this.packageinfo.put(pack.getKey(), pack);
        this.filelist.addAll(pack.getPackageFileList());
        this.store();
        this.printState();
        if (this.packageinfo.getCounter(pack.getKey()) == 1) {
            GHNContext.getContext().getGHN().getDeployedPackages().add(Converter.toGHNPackage(pack));
            GHNContext.getContext().setStatus(GHNContext.Status.UPDATED, new String[0]);
        }
    }

    public synchronized BaseTypedPackage getPackage(KeyData key) throws NoSuchPackageException {
        if (this.packageinfo.containsKey(key)) {
            return (BaseTypedPackage)this.packageinfo.get(key);
        }
        this.logger.warn((Object)("Package key " + key.toString() + " not found"));
        throw new NoSuchPackageException(key.getPackageName());
    }

    public synchronized boolean isDeployed(BaseTypedPackage pack) {
        return this.packageinfo.containsKey(pack.getKey()) && this.packageinfo.getCounter(pack.getKey()) > 0;
    }

    public synchronized void removePackage(BaseTypedPackage pack) throws NoSuchPackageException {
        this.printState();
        this.packageinfo.remove(pack.getKey());
        this.filelist.removeAll(pack.getPackageFileList());
        if (this.packageinfo.getCounter(pack.getKey()) == 0) {
            this.packages.remove(Converter.toDeployablePackage(pack));
            this.store();
            this.printState();
            GCUBEHostingNode.Package newPack = Converter.toGHNPackage(pack);
            GCUBEHostingNode.Package packToRemove = null;
            for (GCUBEHostingNode.Package toCheck : GHNContext.getContext().getGHN().getDeployedPackages()) {
                if (!toCheck.getPackageName().equals(newPack.getPackageName()) || !toCheck.getPackageVersion().equals(newPack.getPackageVersion()) || !toCheck.getServiceName().equals(newPack.getServiceName()) || !toCheck.getServiceClass().equals(newPack.getServiceClass()) || !toCheck.getServiceVersion().equals(newPack.getServiceVersion())) continue;
                packToRemove = toCheck;
                break;
            }
            if (packToRemove != null) {
                GHNContext.getContext().getGHN().getDeployedPackages().remove(packToRemove);
                GHNContext.getContext().setStatus(GHNContext.Status.UPDATED, new String[0]);
            }
        }
    }

    private void printState() {
        this.logger.trace((Object)("Installed files: \n" + this.filelist));
        this.logger.trace((Object)("Deployed packages: \n" + this.packageinfo));
    }

    public Set<? extends BasePackage> getPackagesToUpdate() {
        HashSet<BasePackage> packages = new HashSet<BasePackage>();
        for (BasePackage pack : this.packageinfo.values()) {
            if (pack.getScopesToAdd().size() <= 0) continue;
            packages.add(pack);
        }
        return packages;
    }

    public Report getLastReport() throws Report.ReportNotFoundException {
        try {
            if (this.getLastDeployment() != null && this.getLastDeployment().compareTo("") != 0) {
                this.logger.trace((Object)("Last deployment report is " + this.getLastDeployment()));
                return Report.load(this.getLastDeployment());
            }
        }
        catch (Report.ReportNotFoundException e) {
            this.logger.debug((Object)"No deployment report available since the latest shut down");
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to read the last deployment report", (Throwable)e);
        }
        throw new Report.ReportNotFoundException();
    }

    public boolean isUndeployable(BaseTypedPackage base, Set<GCUBEScope> scopes) {
        if (scopes.size() == 0) {
            return true;
        }
        return scopes.containsAll(base.getScopes());
    }

    public static class NoSuchPackageException
    extends Exception {
        private static final long serialVersionUID = 3102419117086905179L;

        public NoSuchPackageException(String packageName) {
            super("no dynamic package " + packageName + " found in the gHN state (it might be statically deployed)");
        }
    }
}

