/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.container;

public class Semaphore {
    private int semaphore;

    public Semaphore() {
        this(0);
    }

    public Semaphore(int initialValue) {
        this.semaphore = initialValue;
    }

    public void acquire() throws InterruptedException {
        this.waitForSignal();
    }

    public synchronized void waitForSignal() throws InterruptedException {
        if (this.semaphore > 0) {
            --this.semaphore;
            return;
        }
        while (this.semaphore < 1) {
            this.wait();
        }
        --this.semaphore;
    }

    public void release() {
        this.sendSignal();
    }

    public synchronized void sendSignal() {
        ++this.semaphore;
        this.notify();
    }
}

