/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.NoResourceHomeException;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceContextException;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceHome;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.utils.Resources;

public class ResourceContextImpl
extends ResourceContext {
    private static Log logger = LogFactory.getLog(ResourceContextImpl.class.getName());
    private static I18n i18n = I18n.getI18n(Resources.class.getName());
    private SOAPMessageContext context = null;
    private SOAPMessage message = null;
    private ResourceHome home = null;
    private String homeLocation = null;
    private String service = null;
    private URL serviceURL = null;

    public ResourceContextImpl() {
        this(MessageContext.getCurrentContext());
    }

    public ResourceContextImpl(SOAPMessageContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException(i18n.getMessage("nullArgument", "ctx"));
        }
        this.context = ctx;
        this.message = ctx.getMessage();
    }

    public ResourceContextImpl(SOAPMessageContext ctx, SOAPMessage msg) {
        if (ctx == null) {
            throw new IllegalArgumentException(i18n.getMessage("nullArgument", "ctx"));
        }
        this.context = ctx;
        this.message = msg;
    }

    public ResourceKey getResourceKey() throws ResourceContextException {
        ResourceHome home = this.getResourceHome();
        return this.getResourceKey(home.getKeyTypeName(), home.getKeyTypeClass());
    }

    public ResourceKey getResourceKey(QName keyName, Class keyClass) throws ResourceContextException {
        if (keyName == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("resource key name is null");
            }
            return null;
        }
        SOAPHeaderElement headerElement = this.getResourceKeyHeader(keyName);
        if (headerElement == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("resource key header is null");
            }
            return null;
        }
        try {
            return new SimpleResourceKey(headerElement, keyClass);
        }
        catch (Exception e) {
            throw new ResourceContextException("", e);
        }
    }

    public synchronized ResourceHome getResourceHome() throws NoResourceHomeException, ResourceContextException {
        if (this.home == null) {
            String homeLoc = this.getResourceHomeLocation();
            try {
                InitialContext initialContext = new InitialContext();
                this.home = (ResourceHome)initialContext.lookup(homeLoc);
            }
            catch (NameNotFoundException e) {
                throw new NoResourceHomeException();
            }
            catch (NamingException e) {
                throw new ResourceContextException("", e);
            }
        }
        return this.home;
    }

    public synchronized String getResourceHomeLocation() {
        if (this.homeLocation == null) {
            this.homeLocation = "java:comp/env//services/" + this.getService() + "/home";
        }
        return this.homeLocation;
    }

    public SOAPHeaderElement getResourceKeyHeader() throws ResourceContextException {
        ResourceHome home = this.getResourceHome();
        QName keyName = home.getKeyTypeName();
        return keyName == null ? null : this.getResourceKeyHeader(keyName);
    }

    public SOAPHeaderElement getResourceKeyHeader(QName keyName) throws ResourceContextException {
        try {
            return ResourceContextImpl.getResourceKeyHeader(this.message, keyName, null);
        }
        catch (SOAPException e) {
            throw new ResourceContextException("", e);
        }
    }

    public Resource getResource() throws ResourceContextException, ResourceException {
        ResourceHome home = this.getResourceHome();
        ResourceKey key = this.getResourceKey(home.getKeyTypeName(), home.getKeyTypeClass());
        if (logger.isDebugEnabled()) {
            logger.debug("resource key: " + key);
        }
        Resource resource = home.find(key);
        if (logger.isDebugEnabled()) {
            logger.debug("Found resource: " + resource);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setService(String service) {
        this.service = service;
        ResourceContextImpl resourceContextImpl = this;
        synchronized (resourceContextImpl) {
            this.home = null;
            this.homeLocation = null;
        }
    }

    public String getService() {
        return this.service == null ? ResourceContextImpl.getService(this.context) : this.service;
    }

    public URL getServiceURL() {
        return this.serviceURL == null ? ResourceContextImpl.getServiceURL(this.context) : this.serviceURL;
    }

    public boolean containsProperty(String name) {
        return this.context.containsProperty(name);
    }

    public Object getProperty(String name) {
        return this.context.getProperty(name);
    }

    public void removeProperty(String name) {
        this.context.removeProperty(name);
    }

    public void setProperty(String name, Object value) {
        this.context.setProperty(name, value);
    }

    public Iterator getPropertyNames() {
        return this.context.getPropertyNames();
    }

    public static SOAPHeaderElement getResourceKeyHeader(SOAPMessage msg, QName keyName, String actorURI) throws SOAPException {
        if (msg == null) {
            throw new IllegalArgumentException(i18n.getMessage("nullArgument", "msg"));
        }
        if (keyName == null) {
            throw new IllegalArgumentException(i18n.getMessage("nullArgument", "keyName"));
        }
        SOAPEnvelope env = msg.getSOAPPart().getEnvelope();
        SOAPHeader header = env.getHeader();
        if (header == null) {
            return null;
        }
        Iterator iter = header.examineHeaderElements(actorURI);
        while (iter.hasNext()) {
            SOAPHeaderElement hE = (SOAPHeaderElement)iter.next();
            Name nm = hE.getElementName();
            if (!nm.getLocalName().equals(keyName.getLocalPart()) || !nm.getURI().equals(keyName.getNamespaceURI())) continue;
            return hE;
        }
        return null;
    }

    public static String getService(SOAPMessageContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException(i18n.getMessage("nullArgument", "ctx"));
        }
        if (!(ctx instanceof MessageContext)) {
            throw new IllegalArgumentException(i18n.getMessage("contextNotMessageContext", "ctx"));
        }
        MessageContext msgCtx = (MessageContext)ctx;
        return msgCtx.getTargetService();
    }

    public static URL getServiceURL(SOAPMessageContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException(i18n.getMessage("nullArgument", "ctx"));
        }
        if (!(ctx instanceof MessageContext)) {
            throw new IllegalArgumentException(i18n.getMessage("contextNotMessageContext", "ctx"));
        }
        MessageContext msgCtx = (MessageContext)ctx;
        URL serviceURL = null;
        try {
            serviceURL = new URL((String)msgCtx.getProperty("transport.url"));
        }
        catch (MalformedURLException e) {
            logger.error("", e);
        }
        return serviceURL;
    }
}

