/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.jndi;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.axis.AxisEngine;
import org.apache.axis.MessageContext;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.naming.ContextBindings;
import org.globus.util.I18n;
import org.globus.wsrf.config.ContainerConfig;
import org.globus.wsrf.jndi.NamingContext;
import org.globus.wsrf.tools.jndi.JNDIConfigRuleSet;
import org.globus.wsrf.utils.Resources;
import org.xml.sax.SAXException;

public class JNDIUtils {
    private static Log logger = LogFactory.getLog((String)JNDIUtils.class.getName());
    private static I18n i18n = I18n.getI18n((String)Resources.class.getName());
    public static final String JNDI_CONFIG = "jndi-config.xml";
    private static Context initialContext = null;

    public static Context initJNDI() throws Exception {
        InitialContext result = null;
        Context compContext = null;
        String value = "org.apache.naming";
        String oldValue = System.getProperty("java.naming.factory.url.pkgs");
        if (oldValue != null) {
            value = oldValue.startsWith(value + ":") ? oldValue : value + ":" + oldValue;
        }
        System.setProperty("java.naming.factory.url.pkgs", value);
        value = System.getProperty("java.naming.factory.initial");
        if (value == null) {
            System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
        } else {
            logger.debug((Object)i18n.getMessage("initialContextFactorySet", (Object)value));
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("org.apache.naming.synchronization", "true");
        result = new InitialContext(env);
        if (!ContextBindings.isClassLoaderBound()) {
            ContextBindings.bindContext((Object)"wsrfContext", (Context)result);
            ContextBindings.bindClassLoader((Object)"wsrfContext");
        }
        try {
            result.lookup("java:comp/env");
        }
        catch (NameNotFoundException e) {
            compContext = result.createSubcontext("comp");
            compContext.createSubcontext("env");
        }
        return result;
    }

    public static String getJNDIConfigFileName(MessageContext messageContext) {
        String file = null;
        if (messageContext != null) {
            AxisEngine engine = messageContext.getAxisEngine();
            ContainerConfig config = ContainerConfig.getConfig(engine);
            file = config.getOption(i18n.getMessage("jndiConfigFileOption"));
        }
        return file == null ? "etc/jndi-config.xml" : file;
    }

    public static void parseJNDIConfig(InputStream configInput) throws Exception {
        JNDIUtils.parseJNDIConfig(new InitialContext(), configInput, null);
    }

    public static void parseJNDIConfig(Context initContext, InputStream configInput, AxisEngine engine) throws NamingException, IOException, SAXException {
        if (configInput == null) {
            throw new IllegalArgumentException(i18n.getMessage("nullJNDIConfigInput"));
        }
        if (initContext == null) {
            throw new IllegalArgumentException();
        }
        Context envContext = (Context)initContext.lookup("java:comp/env");
        Digester digester = new Digester();
        digester.setNamespaceAware(true);
        digester.setValidating(false);
        digester.addRuleSet((RuleSet)new JNDIConfigRuleSet("jndiConfig/"));
        digester.push((Object)new NamingContext(envContext, engine));
        digester.parse(configInput);
        digester.clear();
    }

    public static Object lookup(Context context, String name, Class type) throws NamingException {
        if (context == null) {
            throw new IllegalArgumentException(i18n.getMessage("nullArgument", (Object)"context"));
        }
        if (type == null) {
            throw new IllegalArgumentException(i18n.getMessage("nullArgument", (Object)"type"));
        }
        Object tmp = context.lookup(name);
        if (type.isAssignableFrom(tmp.getClass())) {
            return tmp;
        }
        Object[] args = new Object[]{type.getName(), tmp == null ? null : tmp.getClass().getName()};
        throw new NamingException(i18n.getMessage("expectedType", args));
    }

    public static synchronized Context initializeDir(MessageContext msgCtx) throws Exception {
        if (initialContext == null) {
            Context context = JNDIUtils.initJNDI();
            String configProfile = (String)msgCtx.getProperty("config.profile");
            String configFile = configProfile == null ? JNDI_CONFIG : configProfile + "-" + JNDI_CONFIG;
            String dir = (String)msgCtx.getProperty("configPath");
            String configDir = dir == null ? "etc" : dir + File.separator + "etc";
            File fDir = new File(configDir);
            File[] dirs = fDir.listFiles(new DirFilter());
            for (int i = 0; i < dirs.length; ++i) {
                JNDIUtils.processJNDIFile(context, dirs[i], msgCtx.getAxisEngine(), configFile);
            }
            initialContext = context;
        }
        return initialContext;
    }

    private static void processJNDIFile(Context context, File dir, AxisEngine engine, String configFile) throws Exception {
        File file = new File(dir, configFile);
        if (!file.exists()) {
            return;
        }
        logger.debug((Object)("Loading jndi configuration from file: " + file));
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            JNDIUtils.parseJNDIConfig(context, in, engine);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Exception e) {
            NamingException ex = new NamingException(i18n.getMessage("jndiConfigParseError", (Object)file));
            ex.setRootCause(e);
            throw ex;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static synchronized Context initializeFile(MessageContext msgCtx) throws Exception {
        if (initialContext == null) {
            InputStream configInput;
            Context context;
            block6: {
                context = JNDIUtils.initJNDI();
                String configFileName = JNDIUtils.getJNDIConfigFileName(msgCtx);
                try {
                    String cfgDir = null;
                    if (msgCtx == null) {
                        cfgDir = ContainerConfig.getGlobusLocation();
                    } else {
                        cfgDir = (String)msgCtx.getProperty("configPath");
                        if (cfgDir == null) {
                            cfgDir = ".";
                        }
                    }
                    String file = cfgDir + File.separator + configFileName;
                    logger.debug((Object)("Trying to load jndi configuration from file: " + file));
                    configInput = new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    logger.debug((Object)("Trying to load jndi configuration from resource stream: " + configFileName));
                    configInput = JNDIUtils.class.getClassLoader().getResourceAsStream(configFileName);
                    if (configInput != null) break block6;
                    throw new IOException(i18n.getMessage("jndiConfigNotFound"));
                }
            }
            JNDIUtils.parseJNDIConfig(context, configInput, msgCtx.getAxisEngine());
            initialContext = context;
        }
        return initialContext;
    }

    public static String toString(Context ctx, String name) throws NamingException {
        StringBuffer buf = new StringBuffer();
        JNDIUtils.toString(buf, ctx, name, "");
        return buf.toString();
    }

    private static void toString(StringBuffer buf, Context ctx, String name, String tab) throws NamingException {
        buf.append(tab).append("context: ").append(name).append("\n");
        NamingEnumeration<NameClassPair> list = ctx.list(name);
        while (list.hasMore()) {
            NameClassPair nc = list.next();
            if (nc.getClassName().equals("org.apache.naming.NamingContext") || nc.getClassName().equals("org.apache.naming.SynchronizedContext")) {
                JNDIUtils.toString(buf, ctx, name + "/" + nc.getName(), tab + "  ");
                continue;
            }
            buf.append(tab).append(" ").append(nc).append("\n");
        }
    }

    public static Context createSubcontexts(Context currentContext, String name) throws NamingException {
        StringTokenizer tokenizer = new StringTokenizer(name, "/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("") || !tokenizer.hasMoreTokens()) continue;
            try {
                currentContext = currentContext.createSubcontext(token);
            }
            catch (NamingException e) {
                currentContext = (Context)currentContext.lookup(token);
            }
        }
        return currentContext;
    }

    private static class DirFilter
    implements FileFilter {
        private DirFilter() {
        }

        public boolean accept(File path) {
            return path.isDirectory();
        }
    }
}

