/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.security.soa3.connector.integration.utils;

import java.io.File;
import java.io.FileReader;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.axis.message.SOAPHeaderElement;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.security.soa3.configuration.ConfigurationManager;
import org.gcube.security.soa3.configuration.ConfigurationManagerFactory;
import org.gcube.security.soa3.configuration.GSSConfigurationManager;
import org.gcube.security.soa3.connector.integration.utils.Utils;

public class GSSIntegrationUtils {
    public static final String SERVICE_PROPERTIES = "serviceSecurityProperties.props";

    public static void setServiceProperties(GCUBEServiceContext ctxt, String serviceName) {
        GCUBELog log = new GCUBELog(Utils.class);
        Properties properties = null;
        log.debug((Object)("Service name " + serviceName));
        try {
            File servicePropertiesFile = ctxt.getFile(SERVICE_PROPERTIES, new boolean[]{false});
            log.debug((Object)("Service Property file = " + servicePropertiesFile));
            if (servicePropertiesFile != null && servicePropertiesFile.exists()) {
                properties = new Properties();
                properties.load(new FileReader(servicePropertiesFile));
            }
        }
        catch (Exception e) {
            log.debug((Object)"Unable to load local property file");
        }
        ConfigurationManager cm = ConfigurationManagerFactory.getConfigurationManager();
        if (properties != null && cm instanceof GSSConfigurationManager) {
            ((GSSConfigurationManager)cm).setServiceProperties(serviceName, properties);
        }
    }

    public static SOAPHeaderElement generateSoapHeaderBinaryTokenElement(String type, String binaryTokenValue) throws SOAPException {
        GCUBELog log = new GCUBELog(Utils.class);
        log.debug((Object)"Generating token SOAP element");
        log.debug((Object)("Type = " + type));
        log.debug((Object)("Value = " + binaryTokenValue));
        SOAPHeaderElement headerElement = new SOAPHeaderElement(new QName("http://schemas.xmlsoap.org/ws/2002/04/secext", "wsse:BinarySecurityToken"));
        headerElement.addAttribute("http://schemas.xmlsoap.org/ws/2002/04/secext", "ValueType", type);
        headerElement.addAttribute("http://schemas.xmlsoap.org/ws/2002/04/secext", "EncodingType", "wsse:Base64Binary");
        headerElement.addAttribute("http://schemas.xmlsoap.org/ws/2002/04/secext", "Id", "SecurityToken");
        headerElement.setValue(binaryTokenValue);
        log.debug((Object)"Header completed");
        return headerElement;
    }
}

