/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Hashtable;
import javax.naming.directory.DirContext;
import org.apache.naming.resources.DirContextURLConnection;

public class DirContextURLStreamHandler
extends URLStreamHandler {
    private static Hashtable clBindings = new Hashtable();
    private static Hashtable threadBindings = new Hashtable();
    protected DirContext context = null;

    public DirContextURLStreamHandler() {
    }

    public DirContextURLStreamHandler(DirContext dirContext) {
        this.context = dirContext;
    }

    protected URLConnection openConnection(URL uRL) throws IOException {
        DirContext dirContext = this.context;
        if (dirContext == null) {
            dirContext = DirContextURLStreamHandler.get();
        }
        return new DirContextURLConnection(dirContext, uRL);
    }

    public static void setProtocolHandler() {
        String string = System.getProperty("java.protocol.handler.pkgs");
        if (string == null) {
            string = "org.apache.naming.resources";
            System.setProperty("java.protocol.handler.pkgs", string);
        } else if (string.indexOf("org.apache.naming.resources") == -1) {
            string = string + "|org.apache.naming.resources";
            System.setProperty("java.protocol.handler.pkgs", string);
        }
    }

    public static boolean isBound() {
        return clBindings.containsKey(Thread.currentThread().getContextClassLoader()) || threadBindings.containsKey(Thread.currentThread());
    }

    public static void bind(DirContext dirContext) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            clBindings.put(classLoader, dirContext);
        }
    }

    public static void unbind() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            clBindings.remove(classLoader);
        }
    }

    public static void bindThread(DirContext dirContext) {
        threadBindings.put(Thread.currentThread(), dirContext);
    }

    public static void unbindThread() {
        threadBindings.remove(Thread.currentThread());
    }

    public static DirContext get() {
        DirContext dirContext = null;
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        dirContext = (DirContext)clBindings.get(classLoader);
        if (dirContext != null) {
            return dirContext;
        }
        dirContext = (DirContext)threadBindings.get(thread);
        classLoader = classLoader.getParent();
        while (classLoader != null) {
            dirContext = (DirContext)clBindings.get(classLoader);
            if (dirContext != null) {
                return dirContext;
            }
            classLoader = classLoader.getParent();
        }
        if (dirContext == null) {
            throw new IllegalStateException("Illegal class loader binding");
        }
        return dirContext;
    }

    public static void bind(ClassLoader classLoader, DirContext dirContext) {
        clBindings.put(classLoader, dirContext);
    }

    public static void unbind(ClassLoader classLoader) {
        clBindings.remove(classLoader);
    }

    public static DirContext get(ClassLoader classLoader) {
        return (DirContext)clBindings.get(classLoader);
    }

    public static DirContext get(Thread thread) {
        return (DirContext)threadBindings.get(thread);
    }
}

